/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.meta.ui.UiCellsContainer;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiGridContainer;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.meta.ui.UiSimpleContainer;
import com.gridnine.xtrip.common.meta.ui.UiTile;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.meta.ui.UiWidgetBigTableBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetDataView;
import com.gridnine.xtrip.common.meta.ui.UiWidgetTableBox;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;

final class ModelGenerator {
    static void collect(Map<String, ModelClass> models, GenerationContext ctx, UiModel model) throws Exception {
        ModelGenerator.checkModelClass(ctx, model);
        ModelGenerator.addModel(models, model);
    }

    static void collect(Map<String, ModelClass> models, GenerationContext ctx, UiTilesSpace space) {
        ModelGenerator.checkModelClass(ctx, space.getModel());
        ModelGenerator.collectForWidget(models, ctx, space.getOverview());
        for (Object tile : space.getTiles()) {
            ModelGenerator.collectForWidget(models, ctx, tile.getFullPayload());
            ModelGenerator.collectForWidget(models, ctx, tile.getCompactPayload());
        }
        ModelClass mc = ModelGenerator.addModel(models, space.getModel());
        if (space.isDeprecated()) {
            mc.deprecated = true;
        }
        for (UiModel.Field prop : space.getProperties()) {
            ModelGenerator.addField(models, mc, new ModelField(prop.getId(), prop.getType(), prop.isCollection() ? FieldKind.COLLECTION : FieldKind.PROPERTY));
        }
        if (space.getOverview() != null) {
            if (space.getOverview() instanceof UiContainerReference) {
                BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)space.getOverview()).getId());
                ModelGenerator.addField(models, mc, new ModelField("overview", nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
            } else {
                BaseUiWidget widget = (BaseUiWidget)space.getOverview();
                Widgets wdg = Widgets.getFor(widget);
                String type = wdg.getModelFieldType(ctx, widget);
                if (type != null) {
                    ModelGenerator.addField(models, mc, new ModelField("overview", type, wdg.getModelFieldKind()));
                }
            }
        }
        for (UiTile tile : space.getTiles()) {
            String type;
            Widgets wdg;
            BaseUiWidget widget;
            BaseUiContainer nestedCtr;
            if (tile.getFullPayload() != null) {
                if (tile.getFullPayload() instanceof UiContainerReference) {
                    nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)tile.getFullPayload()).getId());
                    ModelGenerator.addField(models, mc, new ModelField(tile.getId() + "Full", nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                } else {
                    widget = (BaseUiWidget)tile.getFullPayload();
                    wdg = Widgets.getFor(widget);
                    type = wdg.getModelFieldType(ctx, widget);
                    if (type != null) {
                        ModelGenerator.addField(models, mc, new ModelField(tile.getId() + "Full", type, wdg.getModelFieldKind()));
                    }
                }
            }
            if (tile.getCompactPayload() == null) continue;
            if (tile.getCompactPayload() instanceof UiContainerReference) {
                nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)tile.getCompactPayload()).getId());
                ModelGenerator.addField(models, mc, new ModelField(tile.getId() + "Compact", nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                continue;
            }
            widget = (BaseUiWidget)tile.getCompactPayload();
            wdg = Widgets.getFor(widget);
            type = wdg.getModelFieldType(ctx, widget);
            if (type == null) continue;
            ModelGenerator.addField(models, mc, new ModelField(tile.getId() + "Compact", type, wdg.getModelFieldKind()));
        }
    }

    static void collect(Map<String, ModelClass> models, GenerationContext ctx, UiGridContainer ctr) {
        ModelGenerator.checkModelClass(ctx, ctr.getModel());
        for (UiGridContainer.Cell cell : ctr.getCells()) {
            if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
            ModelGenerator.collectForWidget(models, ctx, cell.getPayload());
        }
        ModelClass mc = ModelGenerator.addModel(models, ctr.getModel());
        if (ctr.isDeprecated()) {
            mc.deprecated = true;
        }
        for (UiModel.Field prop : ctr.getProperties()) {
            ModelGenerator.addField(models, mc, new ModelField(prop.getId(), prop.getType(), prop.isCollection() ? FieldKind.COLLECTION : FieldKind.PROPERTY));
        }
        for (UiGridContainer.Cell cell : ctr.getCells()) {
            if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)) continue;
            if (cell.getPayload() instanceof UiContainerReference) {
                BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)cell.getPayload()).getId());
                ModelGenerator.addField(models, mc, new ModelField(cell.getId(), nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                continue;
            }
            BaseUiWidget widget = (BaseUiWidget)cell.getPayload();
            Widgets wdg = Widgets.getFor(widget);
            String type = wdg.getModelFieldType(ctx, widget);
            if (type == null) continue;
            ModelGenerator.addField(models, mc, new ModelField(cell.getId(), type, wdg.getModelFieldKind()));
        }
    }

    static void collect(Map<String, ModelClass> models, GenerationContext ctx, UiCellsContainer ctr) {
        ModelGenerator.checkModelClass(ctx, ctr.getModel());
        for (UiCellsContainer.BaseCell cell : ctr.getCells()) {
            if (!(cell instanceof UiCellsContainer.ComplexCell)) continue;
            ModelGenerator.collectForWidget(models, ctx, ((UiCellsContainer.ComplexCell)cell).getPayload());
        }
        ModelClass mc = ModelGenerator.addModel(models, ctr.getModel());
        if (ctr.isDeprecated()) {
            mc.deprecated = true;
        }
        for (UiModel.Field prop : ctr.getProperties()) {
            ModelGenerator.addField(models, mc, new ModelField(prop.getId(), prop.getType(), prop.isCollection() ? FieldKind.COLLECTION : FieldKind.PROPERTY));
        }
        for (UiCellsContainer.BaseCell cell : ctr.getCells()) {
            if (cell instanceof UiCellsContainer.SimpleCell) {
                ModelGenerator.addField(models, mc, new ModelField(cell.getId(), "String", FieldKind.PROPERTY));
                continue;
            }
            if (cell instanceof UiCellsContainer.ComplexCell) {
                UiCellsContainer.ComplexCell complexCell = (UiCellsContainer.ComplexCell)cell;
                if (complexCell.getPayload() instanceof UiContainerReference) {
                    BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)complexCell.getPayload()).getId());
                    ModelGenerator.addField(models, mc, new ModelField(cell.getId(), nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                    continue;
                }
                BaseUiWidget widget = (BaseUiWidget)complexCell.getPayload();
                Widgets wdg = Widgets.getFor(widget);
                String type = wdg.getModelFieldType(ctx, widget);
                if (type == null) continue;
                ModelGenerator.addField(models, mc, new ModelField(cell.getId(), type, wdg.getModelFieldKind()));
                continue;
            }
            throw Xeption.forDeveloper((String)"unsupported type {0} of cell {1} in cells container {2}", (Object[])new Object[]{cell.getClass().getName(), cell.getId(), ctr.getId()});
        }
    }

    static void collect(Map<String, ModelClass> models, GenerationContext ctx, UiCardsContainer ctr) throws Exception {
        ModelGenerator.checkModelClass(ctx, ctr.getModel());
        for (UiCardsContainer.Card card : ctr.getCards()) {
            ModelGenerator.collectForWidget(models, ctx, card.getPayload());
        }
        ModelClass mc = ModelGenerator.addModel(models, ctr.getModel());
        if (ctr.isDeprecated()) {
            mc.deprecated = true;
        }
        for (UiModel.Field prop : ctr.getProperties()) {
            ModelGenerator.addField(models, mc, new ModelField(prop.getId(), prop.getType(), prop.isCollection() ? FieldKind.COLLECTION : FieldKind.PROPERTY));
        }
        for (UiCardsContainer.Card card : ctr.getCards()) {
            if (card.getPayload() instanceof UiContainerReference) {
                BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)card.getPayload()).getId());
                ModelGenerator.addField(models, mc, new ModelField(card.getId(), nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                continue;
            }
            BaseUiWidget widget = (BaseUiWidget)card.getPayload();
            Widgets wdg = Widgets.getFor(widget);
            String type = wdg.getModelFieldType(ctx, widget);
            if (type == null) continue;
            ModelGenerator.addField(models, mc, new ModelField(card.getId(), type, wdg.getModelFieldKind()));
        }
    }

    static void collect(Map<String, ModelClass> models, GenerationContext ctx, UiSimpleContainer ctr) throws Exception {
        ModelGenerator.checkModelClass(ctx, ctr.getModel());
        ModelGenerator.collectForWidget(models, ctx, ctr.getPayload());
        ModelClass mc = ModelGenerator.addModel(models, ctr.getModel());
        if (ctr.isDeprecated()) {
            mc.deprecated = true;
        }
        if (ctr.getPayload() instanceof UiContainerReference) {
            BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiContainerReference)ctr.getPayload()).getId());
            ModelGenerator.addField(models, mc, new ModelField("content", nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
        } else {
            BaseUiWidget widget = (BaseUiWidget)ctr.getPayload();
            Widgets wdg = Widgets.getFor(widget);
            String type = wdg.getModelFieldType(ctx, widget);
            if (type != null) {
                ModelGenerator.addField(models, mc, new ModelField("content", type, wdg.getModelFieldKind()));
            }
        }
    }

    private static void collectForWidget(Map<String, ModelClass> models, GenerationContext ctx, UiElement maybeWidget) {
        block24: {
            block25: {
                block23: {
                    if (!(maybeWidget instanceof UiWidgetTableBox)) break block23;
                    UiWidgetTableBox widget = (UiWidgetTableBox)maybeWidget;
                    ModelGenerator.checkModelClass(ctx, widget.getModel());
                    ModelClass mc = ModelGenerator.addModel(models, widget.getModel());
                    for (UiWidgetTableBox.BaseColumn column : widget.getColumns()) {
                        if (column instanceof UiWidgetTableBox.WidgetColumn) {
                            UiWidgetTableBox.WidgetColumn widgetColumn = (UiWidgetTableBox.WidgetColumn)column;
                            Widgets wdg = Widgets.getFor(widgetColumn.getWidget());
                            String type = wdg.getModelFieldType(ctx, widgetColumn.getWidget());
                            if (type == null) continue;
                            ModelGenerator.addField(models, mc, new ModelField(column.getId(), type, wdg.getModelFieldKind()));
                            continue;
                        }
                        if (column instanceof UiWidgetTableBox.SuperColumn) {
                            UiWidgetTableBox.SuperColumn superColumn = (UiWidgetTableBox.SuperColumn)column;
                            BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(superColumn.getPayload().getId());
                            ModelGenerator.addField(models, mc, new ModelField(column.getId(), nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                            continue;
                        }
                        if (column instanceof UiWidgetTableBox.CustomColumn) {
                            UiWidgetTableBox.CustomColumn customColumn = (UiWidgetTableBox.CustomColumn)column;
                            ModelGenerator.addField(models, mc, new ModelField(column.getId(), customColumn.getModelClassName(), FieldKind.FINAL_PROPERTY));
                            continue;
                        }
                        throw Xeption.forDeveloper((String)"unsupported type {0} of column {1} in table widget", (Object[])new Object[]{column.getClass().getName(), column.getId()});
                    }
                    break block24;
                }
                if (!(maybeWidget instanceof UiWidgetBigTableBox)) break block25;
                UiWidgetBigTableBox widget = (UiWidgetBigTableBox)maybeWidget;
                ModelGenerator.checkModelClass(ctx, widget.getModel());
                ModelClass mc = ModelGenerator.addModel(models, widget.getModel());
                for (UiWidgetBigTableBox.BaseColumn column : widget.getColumns()) {
                    if (column instanceof UiWidgetBigTableBox.SimpleColumn) {
                        UiWidgetBigTableBox.ColumnType type = ((UiWidgetBigTableBox.SimpleColumn)column).getType();
                        switch (type) {
                            case STRING: 
                            case ACTION: {
                                ModelGenerator.addField(models, mc, new ModelField(column.getId(), "String", FieldKind.PROPERTY));
                                break;
                            }
                            case DATE: {
                                ModelGenerator.addField(models, mc, new ModelField(column.getId(), LocalDate.class.getName(), FieldKind.PROPERTY));
                                break;
                            }
                            case DATE_TIME: {
                                ModelGenerator.addField(models, mc, new ModelField(column.getId(), LocalDateTime.class.getName(), FieldKind.PROPERTY));
                                break;
                            }
                            case PRICE: {
                                ModelGenerator.addField(models, mc, new ModelField(column.getId(), BigDecimal.class.getName(), FieldKind.PROPERTY));
                                break;
                            }
                            case BOOLEAN: {
                                ModelGenerator.addField(models, mc, new ModelField(column.getId(), "boolean", FieldKind.PROPERTY));
                                break;
                            }
                            default: {
                                throw Xeption.forDeveloper((String)"unsupported type {0} of column {1} in big table widget", (Object[])new Object[]{type, column.getId()});
                            }
                        }
                        continue;
                    }
                    if (column instanceof UiWidgetBigTableBox.ComboBoxColumn) {
                        UiWidgetBigTableBox.ComboBoxColumn comboBoxColumn = (UiWidgetBigTableBox.ComboBoxColumn)column;
                        String modelClassName = comboBoxColumn.getModelClassName();
                        ModelGenerator.addField(models, mc, new ModelField(column.getId(), modelClassName, FieldKind.PROPERTY));
                        continue;
                    }
                    if (column instanceof UiWidgetBigTableBox.NestedEntityReferenceColumn) {
                        UiWidgetBigTableBox.NestedEntityReferenceColumn nestedEntityReferenceColumn = (UiWidgetBigTableBox.NestedEntityReferenceColumn)column;
                        String rootModelClassName = nestedEntityReferenceColumn.getRootModelClassName();
                        String nestedModelClassName = nestedEntityReferenceColumn.getNestedModelClassName();
                        ModelGenerator.addField(models, mc, new ModelField(column.getId(), String.format("%s<%s, %s>", NestedEntityReference.class.getName(), rootModelClassName, nestedModelClassName), FieldKind.PROPERTY));
                        continue;
                    }
                    if (column instanceof UiWidgetBigTableBox.KeyValueColumn) {
                        UiWidgetBigTableBox.KeyValueColumn keyValueColumn = (UiWidgetBigTableBox.KeyValueColumn)column;
                        String keyModelClassName = keyValueColumn.getKeyModelClassName();
                        String modelClassName = String.format("%s<%s, Object>", Pair.class.getName(), keyModelClassName);
                        ModelGenerator.addField(models, mc, new ModelField(column.getId(), modelClassName, FieldKind.PROPERTY));
                        continue;
                    }
                    if (column instanceof UiWidgetBigTableBox.SuperColumn) {
                        UiWidgetBigTableBox.SuperColumn superColumn = (UiWidgetBigTableBox.SuperColumn)column;
                        BaseUiContainer nestedCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(superColumn.getPayload().getId());
                        ModelGenerator.addField(models, mc, new ModelField(column.getId(), nestedCtr.getModel().getClassName(), FieldKind.FINAL_PROPERTY));
                        continue;
                    }
                    throw Xeption.forDeveloper((String)"unsupported type {0} of column {1} in big table widget", (Object[])new Object[]{column.getClass().getName(), column.getId()});
                }
                break block24;
            }
            if (!(maybeWidget instanceof UiWidgetDataView)) break block24;
            UiWidgetDataView widget = (UiWidgetDataView)maybeWidget;
            ModelGenerator.checkModelClass(ctx, widget.getModel());
            ModelClass mc = ModelGenerator.addModel(models, widget.getModel());
            block14: for (UiWidgetDataView.Column column : widget.getColumns()) {
                switch (column.getType()) {
                    case STRING: {
                        ModelGenerator.addField(models, mc, new ModelField(column.getId(), "String", FieldKind.PROPERTY));
                        continue block14;
                    }
                    case BOOLEAN: {
                        ModelGenerator.addField(models, mc, new ModelField(column.getId(), "Boolean", FieldKind.PROPERTY));
                        continue block14;
                    }
                    case ACTION: {
                        continue block14;
                    }
                }
                throw Xeption.forDeveloper((String)"unsupported type {0} of column {1} in data view widget", (Object[])new Object[]{column.getType(), column.getId()});
            }
        }
    }

    private static ModelClass addModel(Map<String, ModelClass> models, UiModel model) {
        ModelClass result = models.get(model.getClassName());
        if (result == null) {
            result = new ModelClass();
            result.className = model.getClassName();
            models.put(result.className, result);
        }
        if (model.getExtendsId() != null) {
            if (result.extendsId != null) {
                if (!result.extendsId.equals(model.getExtendsId())) {
                    throw Xeption.forDeveloper((String)"super type conflict in VM class {0}", (Object[])new Object[]{result.className});
                }
            } else {
                result.extendsId = model.getExtendsId();
            }
        }
        result.interfaces.addAll(model.getInterfaces());
        for (UiModel.Field field : model.getFields()) {
            ModelGenerator.addField(models, result, new ModelField(field.getId(), field.getType(), field.isCollection() ? FieldKind.COLLECTION : FieldKind.PROPERTY));
        }
        return result;
    }

    private static void addField(Map<String, ModelClass> models, ModelClass model, ModelField field) {
        model.fields.put(field.id, field);
    }

    private static void checkModelClass(GenerationContext ctx, UiModel model) {
        boolean knownType;
        MetaRegistry mr = ctx.getMetaRegistry();
        boolean bl = knownType = BaseDictionary.class.getName().equals(model.getClassName()) || mr.getDictionaries().containsKey(model.getClassName()) || mr.getEntityRefs().containsKey(model.getClassName()) || mr.getEntities().containsKey(model.getClassName()) || mr.getIndexes().containsKey(model.getClassName()) || mr.getEnumRefs().containsKey(model.getClassName()) || mr.getEnums().containsKey(model.getClassName());
        if (knownType) {
            throw Xeption.forDeveloper((String)"known type {0} used as view-model class", (Object[])new Object[]{model.getClassName()});
        }
    }

    static void generate(JavaWriter writer, GenerationContext ctx, Map<String, ModelClass> models) throws Exception {
        for (ModelClass model : models.values()) {
            ModelGenerator.cleanOverridedFields(models, model);
            writer.beginCompilationUnit(ctx.getOutFolder(), model.className);
            if (model.deprecated) {
                writer.code("@Deprecated", new Object[0]);
            }
            String ext = "";
            if (!TextUtil.isBlank((String)model.extendsId)) {
                ext = " extends " + model.extendsId;
            }
            String impl = "";
            for (String itf : model.interfaces) {
                impl = impl.length() == 0 ? impl + " implements " : impl + ", ";
                impl = impl + itf;
            }
            writer.beginBlock("public class %s%s%s", new Object[]{GenUtil.getSimpleClassName((String)model.className), ext, impl});
            for (ModelField field : model.fields.values()) {
                ModelGenerator.generateField(writer, field.id, field.type, field.kind);
            }
            writer.endBlock();
            writer.endCompilationUnit();
        }
    }

    private static void cleanOverridedFields(Map<String, ModelClass> models, ModelClass model) {
        if (model.extendsId == null) {
            return;
        }
        ModelClass superModel = models.get(model.extendsId);
        if (superModel == null) {
            return;
        }
        Iterator<ModelField> it = model.fields.values().iterator();
        while (it.hasNext()) {
            FieldKind existingKind;
            ModelField field = it.next();
            ModelField existingField = ModelGenerator.lookupField(models, superModel, field.id);
            if (existingField == null) continue;
            if (!field.type.equals(existingField.type)) {
                throw Xeption.forDeveloper((String)"types conflict for field {0} in VM class {1} - {2} vs {3}", (Object[])new Object[]{field.id, model.className, existingField.type, field.type});
            }
            FieldKind kind = field.kind;
            if (kind == FieldKind.FINAL_PROPERTY) {
                kind = FieldKind.PROPERTY;
            }
            if ((existingKind = existingField.kind) == FieldKind.FINAL_PROPERTY) {
                existingKind = FieldKind.PROPERTY;
            }
            if (kind != existingKind) {
                throw Xeption.forDeveloper((String)"kinds conflict for field {0} in VM class {1} - {2} vs {3}", (Object[])new Object[]{field.id, model.className, existingField.kind, field.kind});
            }
            if (field.kind == FieldKind.FINAL_PROPERTY && existingField.kind == FieldKind.PROPERTY) {
                existingField.kind = FieldKind.FINAL_PROPERTY;
            }
            it.remove();
        }
    }

    private static ModelField lookupField(Map<String, ModelClass> models, ModelClass model, String id) {
        ModelField result = model.fields.get(id);
        if (result != null || model.extendsId == null) {
            return result;
        }
        ModelClass superModel = models.get(model.extendsId);
        return superModel == null ? null : ModelGenerator.lookupField(models, superModel, id);
    }

    private static void generateField(JavaWriter writer, String name, String type, FieldKind kind) throws IOException {
        switch (kind) {
            case PROPERTY: {
                writer.code("private %s %s;", new Object[]{type, name});
                writer.blank();
                if ("boolean".equals(type)) {
                    writer.beginBlock("public %s is%s()", new Object[]{type, GenUtil.capitalize((String)name)});
                } else {
                    writer.beginBlock("public %s get%s()", new Object[]{type, GenUtil.capitalize((String)name)});
                }
                writer.code("return %s;", new Object[]{name});
                writer.endBlock();
                writer.beginBlock("public void set%s(final %s value)", new Object[]{GenUtil.capitalize((String)name), type});
                writer.code("this.%s = value;", new Object[]{name});
                writer.endBlock();
                break;
            }
            case FINAL_PROPERTY: {
                writer.code("private %s %s;", new Object[]{type, name});
                writer.blank();
                writer.beginBlock("public %s get%s()", new Object[]{type, GenUtil.capitalize((String)name)});
                writer.beginBlock("if (%s == null)", new Object[]{name});
                writer.code("%s = new %s();", new Object[]{name, type});
                writer.endBlock();
                writer.code("return %s;", new Object[]{name});
                writer.endBlock();
                break;
            }
            case COLLECTION: {
                writer.code("private final %s<%s> %s = new %1$s<>();", new Object[]{ArrayList.class.getName(), type, name});
                writer.blank();
                writer.beginBlock("public %s<%s> get%s()", new Object[]{List.class.getName(), type, GenUtil.capitalize((String)name)});
                writer.code("return %s;", new Object[]{name});
                writer.endBlock();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported field kind " + (Object)((Object)kind));
            }
        }
    }

    private ModelGenerator() {
    }

    private static class ModelField {
        final String id;
        final String type;
        FieldKind kind;

        ModelField(String fieldId, String fieldType, FieldKind fieldKind) {
            this.id = fieldId;
            this.type = fieldType;
            this.kind = fieldKind;
        }
    }

    static class ModelClass {
        String className;
        final List<String> interfaces = new ArrayList<String>();
        String extendsId;
        boolean deprecated;
        final Map<String, ModelField> fields = new HashMap<String, ModelField>();

        ModelClass() {
        }
    }

    static enum FieldKind {
        PROPERTY,
        FINAL_PROPERTY,
        COLLECTION;

    }
}

