/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ControllerBasedExpandableColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CustomWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateTimeValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DoubleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.FloatValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.HyperlinkWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.IntValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.KeyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.LongValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TimeValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TripleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ValuesWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.BooleanHistoricalWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.CurrencyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DateHistoricalWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DateTimeHistoricalWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.LocaleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.MoneyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.MultiLingualWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.NestedEntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.PopupWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.PriceHistoricalWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.RateMoneyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.StringHistoricalWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiWidgetActionBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetCheckBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetComboBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetDictBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetEntityBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetEnumBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetHistoricalValueBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetInfoBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetKeyValueBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetMultiLingualBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetNestedEntityBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetPopupBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetRadioBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetTableBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetTextBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetValueBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetValuesBox;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.Pair;

enum TableWidgets {
    INFO{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, String> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, String> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{InfoWidgetColumn.class.getName(), modelClassName});
            CodeGenHelper.genForLabel(((UiWidgetInfoBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getContent(), writer, "column", "setDefaultText");
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    ACTION{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            UiWidgetActionBox columnWidget = (UiWidgetActionBox)((UiWidgetTableBox.WidgetColumn)column).getWidget();
            writer.code("%s<%s, String> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{HyperlinkWidgetColumn.class.getName(), modelClassName});
            CodeGenHelper.genForLabel(columnWidget.getText(), writer, "column", "setDefaultText");
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    TEXT{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, String> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, String> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{TextWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    CHECK_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Boolean> getter = obj -> obj.is%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, Boolean> setter = (obj, value) -> obj.set%s(value.booleanValue());", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{CheckBoxWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            CodeGenHelper.genForLabel(((UiWidgetCheckBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getCaption(), writer, "column", "setText");
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_BOOLEAN{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Boolean> getter = obj -> obj.is%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, Boolean> setter = (obj, value) -> obj.set%s(value == null ? false : value.booleanValue());", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{BooleanValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_TRIPLE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Boolean> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, Boolean> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{TripleValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_INT{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Integer> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            String setterValue = ((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.INT_NULLABLE ? "value" : "value == null ? 0 : value.intValue()";
            writer.code("%s<%s, Integer> setter = (obj, value) -> obj.set%s(%s);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId()), setterValue});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{IntValueWidgetColumn.class.getName(), modelClassName});
            if (((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.INT_NULLABLE) {
                writer.code("column.setDefaultValue(null);", new Object[0]);
            } else {
                writer.code("column.setDefaultValue(Integer.valueOf(0));", new Object[0]);
            }
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_LONG{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Long> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            String setterValue = ((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.LONG_NULLABLE ? "value" : "value == null ? 0L : value.longValue()";
            writer.code("%s<%s, Long> setter = (obj, value) -> obj.set%s(%s);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId()), setterValue});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{LongValueWidgetColumn.class.getName(), modelClassName});
            if (((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.LONG_NULLABLE) {
                writer.code("column.setDefaultValue(null);", new Object[0]);
            } else {
                writer.code("column.setDefaultValue(Long.valueOf(0));", new Object[0]);
            }
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_FLOAT{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Float> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            String setterValue = ((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.FLOAT_NULLABLE ? "value" : "value == null ? 0.0F : value.floatValue()";
            writer.code("%s<%s, Float> setter = (obj, value) -> obj.set%s(%s);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId()), setterValue});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{FloatValueWidgetColumn.class.getName(), modelClassName});
            if (((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.FLOAT_NULLABLE) {
                writer.code("column.setDefaultValue(null);", new Object[0]);
            } else {
                writer.code("column.setDefaultValue(Float.valueOf(0.0F));", new Object[0]);
            }
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_DOUBLE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Double> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            String setterValue = ((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.DOUBLE_NULLABLE ? "value" : "value == null ? 0.0 : value.doubleValue()";
            writer.code("%s<%s, Double> setter = (obj, value) -> obj.set%s(%s);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId()), setterValue});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{DoubleValueWidgetColumn.class.getName(), modelClassName});
            if (((UiWidgetValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getType() == UiWidgetValueBox.Type.DOUBLE_NULLABLE) {
                writer.code("column.setDefaultValue(null);", new Object[0]);
            } else {
                writer.code("column.setDefaultValue(Double.valueOf(0.0));", new Object[0]);
            }
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_PRICE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, BigDecimal.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, BigDecimal.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{PriceValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_MONEY{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, Money.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, Money.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{MoneyValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_RATE_MONEY{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, RateMoney.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, RateMoney.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{RateMoneyValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_LOCALE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, Locale.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, Locale.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{LocaleValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_CURRENCY{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, String.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, String.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{CurrencyValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_DATE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, LocalDate.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, LocalDate.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{DateValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_DATE_TIME{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, LocalDateTime.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, LocalDateTime.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{DateTimeValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_TIME{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, LocalTime.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, LocalTime.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{TimeValueWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUE_TIME_ZONE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, TimeZone.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, TimeZone.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{ComboBoxWidgetColumn.class.getName(), modelClassName, TimeZone.class.getName()});
            writer.code("column.setItemsSupplier(%s.ALL_TIME_ZONES);", new Object[]{Suppliers.class.getName()});
            writer.code("column.setConverter(%s.TIME_ZONE.createStatefulConverter(%sNode.getViewState()::isImmutable));", new Object[]{StandardRenderers.class.getName(), name});
            writer.code("column.setSuggestionsHandler(new %s<>(column.getConverter(), () -> column.getItemsSupplier().get(), column.isSortItems()));", new Object[]{SimpleSuggestionsHandler.class.getName()});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    VALUES{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String valueClassName = ((UiWidgetValuesBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getModelClassName();
            writer.code("%s<%s, %s<%s>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, List.class.getName(), valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter);", new Object[]{ValuesWidgetColumn.class.getName(), modelClassName, valueClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    COMBO_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String valueClassName = ((UiWidgetComboBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getModelClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{ComboBoxWidgetColumn.class.getName(), modelClassName, valueClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    RADIO_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String valueClassName = ((UiWidgetRadioBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getModelClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{ComboBoxWidgetColumn.class.getName(), modelClassName, valueClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    ENTITY_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String valueClassName = ((UiWidgetEntityBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getModelClassName();
            writer.code("%s<%s, %s<%s>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, EntityReference.class.getName(), valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s<%s>> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, EntityReference.class.getName(), valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(%3$s.class, getter, setter);", new Object[]{EntityBoxWidgetColumn.class.getName(), modelClassName, valueClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    NESTED_ENTITY_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String rootClassName = ((UiWidgetNestedEntityBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getRootModelClassName();
            String nestedClassName = ((UiWidgetNestedEntityBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getNestedModelClassName();
            writer.code("%s<%s, %s<%s, %s>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, NestedEntityReference.class.getName(), rootClassName, nestedClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s<%s, %s>> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, NestedEntityReference.class.getName(), rootClassName, nestedClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s, %s> column = new %1$s<>(%3$s.class, %4$s.class, getter, setter);", new Object[]{NestedEntityBoxWidgetColumn.class.getName(), modelClassName, rootClassName, nestedClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    DICT_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String valueClassName = ((UiWidgetDictBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getModelClassName();
            writer.code("%s<%s, %s<%s>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, DictionaryReference.class.getName(), valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s<%s>> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, DictionaryReference.class.getName(), valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(%3$s.class, getter, setter);", new Object[]{DictBoxWidgetColumn.class.getName(), modelClassName, valueClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    ENUM_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String valueClassName = ((UiWidgetEnumBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getModelClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{ComboBoxWidgetColumn.class.getName(), modelClassName, valueClassName});
            writer.code("column.setItemsSupplier(%s.createEnumSupplier(%s.class));", new Object[]{Suppliers.class.getName(), valueClassName});
            writer.code("column.setSuggestionsHandler(new %s<>(column.getConverter(), () -> column.getItemsSupplier().get(), column.isSortItems()));", new Object[]{SimpleSuggestionsHandler.class.getName()});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    KEY_VALUE_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String keyModelClassName = ((UiWidgetKeyValueBox)((UiWidgetTableBox.WidgetColumn)column).getWidget()).getKeyModelClassName();
            String valueClassName = String.format("%s<%s, Object>", Pair.class.getName(), keyModelClassName);
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{KeyValueWidgetColumn.class.getName(), modelClassName, keyModelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    MULTI_LINGUAL{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, L10nString.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, L10nString.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{MultiLingualWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    HISTORICAL_BOOLEAN{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s<%s<Boolean>>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, List.class.getName(), HistoricalValue.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{BooleanHistoricalWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    HISTORICAL_PRICE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s<%s<%s>>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, List.class.getName(), HistoricalValue.class.getName(), BigDecimal.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{PriceHistoricalWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    HISTORICAL_STRING{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s<%s<String>>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, List.class.getName(), HistoricalValue.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{StringHistoricalWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    HISTORICAL_DATE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s<%s<%s>>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, List.class.getName(), HistoricalValue.class.getName(), Date.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{DateHistoricalWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    HISTORICAL_DATE_TIME{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s<%s<%s>>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, List.class.getName(), HistoricalValue.class.getName(), Date.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{DateTimeHistoricalWidgetColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    POPUP{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            UiWidgetPopupBox box = (UiWidgetPopupBox)((UiWidgetTableBox.WidgetColumn)column).getWidget();
            BaseUiContainer payloadCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(box.getPayload().getId());
            String payloadModelClassName = payloadCtr.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, payloadModelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s<%s, %s>> supplier = () -> new %s(new %3$s(%sNode.getViewState().isReadonly()), %6$sNode.getViewState().isReadonly());", new Object[]{Supplier.class.getName(), ViewController.class.getName(), payloadCtr.getId(), payloadModelClassName, payloadCtr.getId() + "Controller", name});
            writer.code("%s<%s, %s, %s> column = new %1$s<>(getter, supplier);", new Object[]{PopupWidgetColumn.class.getName(), modelClassName, payloadModelClassName, payloadCtr.getId()});
            this.configureWidgetColumn(writer, ctx, widget, column);
            CodeGenHelper.genForLabel(box.getCaption(), writer, "column", "setActionText");
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    SUPER{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            BaseUiContainer payloadCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiWidgetTableBox.SuperColumn)column).getPayload().getId());
            String payloadModelClassName = payloadCtr.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, payloadModelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s<%s, %s>> supplier = () -> new %s(new %3$s(%sNode.getViewState().isReadonly()), %6$sNode.getViewState().isReadonly());", new Object[]{Supplier.class.getName(), ViewController.class.getName(), payloadCtr.getId(), payloadModelClassName, payloadCtr.getId() + "Controller", name});
            writer.code("%s<%s, %s, %s> column = new %1$s<>(getter, supplier);", new Object[]{ControllerBasedExpandableColumn.class.getName(), modelClassName, payloadModelClassName, payloadCtr.getId()});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    CUSTOM{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, String name, UiWidgetTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String itemModelClassName = ((UiWidgetTableBox.CustomColumn)column).getModelClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, itemModelClassName, GenUtil.capitalize((String)column.getId())});
            writer.beginBlock("%s<%s<%s>> supplier = () -> ", new Object[]{Supplier.class.getName(), CustomWidget.class.getName(), itemModelClassName});
            writer.beginBlock("try", new Object[0]);
            String widgetClassName = ((UiWidgetTableBox.CustomColumn)column).getWidgetClassName();
            writer.code("return (%s) Class.forName(\"%s\").getConstructor(Boolean.TYPE).newInstance(Boolean.valueOf(%sNode.getViewState().isReadonly()));", new Object[]{CustomWidget.class.getName(), widgetClassName, name});
            writer.restartBlock("catch(Exception e)", new Object[0]);
            writer.code("throw %s.forDeveloper(\"failed instanciating custom widget %s\", e);", new Object[]{Xeption.class.getName(), widgetClassName});
            writer.endBlock();
            writer.endBlock(";");
            writer.code("%s<%s, %s> column = new %1$s<>(getter, supplier);", new Object[]{CustomWidgetColumn.class.getName(), modelClassName, itemModelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    };


    static TableWidgets getFor(UiWidgetTableBox.BaseColumn column) {
        if (column instanceof UiWidgetTableBox.SuperColumn) {
            return SUPER;
        }
        if (column instanceof UiWidgetTableBox.CustomColumn) {
            return CUSTOM;
        }
        if (!(column instanceof UiWidgetTableBox.WidgetColumn)) {
            throw Xeption.forDeveloper((String)("unsupported column class " + column.getClass().getName()), (Object[])new Object[0]);
        }
        BaseUiWidget payload = ((UiWidgetTableBox.WidgetColumn)column).getWidget();
        if (payload instanceof UiWidgetInfoBox) {
            return INFO;
        }
        if (payload instanceof UiWidgetActionBox) {
            return ACTION;
        }
        if (payload instanceof UiWidgetTextBox) {
            return TEXT;
        }
        if (payload instanceof UiWidgetCheckBox) {
            return CHECK_BOX;
        }
        if (payload instanceof UiWidgetValueBox) {
            UiWidgetValueBox widget = (UiWidgetValueBox)payload;
            switch (widget.getType()) {
                case BOOLEAN: {
                    return VALUE_BOOLEAN;
                }
                case TRIPLE: {
                    return VALUE_TRIPLE;
                }
                case INT: 
                case INT_NULLABLE: {
                    return VALUE_INT;
                }
                case LONG: 
                case LONG_NULLABLE: {
                    return VALUE_LONG;
                }
                case FLOAT: 
                case FLOAT_NULLABLE: {
                    return VALUE_FLOAT;
                }
                case DOUBLE: 
                case DOUBLE_NULLABLE: {
                    return VALUE_DOUBLE;
                }
                case PRICE: {
                    return VALUE_PRICE;
                }
                case MONEY: {
                    return VALUE_MONEY;
                }
                case RATE_MONEY: {
                    return VALUE_RATE_MONEY;
                }
                case LOCALE: {
                    return VALUE_LOCALE;
                }
                case CURRENCY: {
                    return VALUE_CURRENCY;
                }
                case DATE: {
                    return VALUE_DATE;
                }
                case DATE_TIME: {
                    return VALUE_DATE_TIME;
                }
                case TIME: {
                    return VALUE_TIME;
                }
                case TIME_ZONE: {
                    return VALUE_TIME_ZONE;
                }
            }
            throw Xeption.forDeveloper((String)("unsupported value widget type " + widget.getType()), (Object[])new Object[0]);
        }
        if (payload instanceof UiWidgetValuesBox) {
            return VALUES;
        }
        if (payload instanceof UiWidgetComboBox) {
            return COMBO_BOX;
        }
        if (payload instanceof UiWidgetRadioBox) {
            return RADIO_BOX;
        }
        if (payload instanceof UiWidgetEntityBox) {
            return ENTITY_BOX;
        }
        if (payload instanceof UiWidgetNestedEntityBox) {
            return NESTED_ENTITY_BOX;
        }
        if (payload instanceof UiWidgetDictBox) {
            return DICT_BOX;
        }
        if (payload instanceof UiWidgetEnumBox) {
            return ENUM_BOX;
        }
        if (payload instanceof UiWidgetKeyValueBox) {
            return KEY_VALUE_BOX;
        }
        if (payload instanceof UiWidgetMultiLingualBox) {
            return MULTI_LINGUAL;
        }
        if (payload instanceof UiWidgetHistoricalValueBox) {
            UiWidgetHistoricalValueBox widget = (UiWidgetHistoricalValueBox)payload;
            switch (widget.getType()) {
                case BOOLEAN: {
                    return HISTORICAL_BOOLEAN;
                }
                case PRICE: {
                    return HISTORICAL_PRICE;
                }
                case STRING: {
                    return HISTORICAL_STRING;
                }
                case DATE: {
                    return HISTORICAL_DATE;
                }
                case DATE_TIME: {
                    return HISTORICAL_DATE_TIME;
                }
            }
            throw Xeption.forDeveloper((String)("unsupported historical value widget type " + widget.getType()), (Object[])new Object[0]);
        }
        if (payload instanceof UiWidgetPopupBox) {
            return POPUP;
        }
        throw Xeption.forDeveloper((String)("unsupported widget type " + payload.getClass().getName()), (Object[])new Object[0]);
    }

    protected void configureWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetTableBox widget, UiWidgetTableBox.BaseColumn column) throws Exception {
        CodeGenHelper.genForLabel(column.getCaption(), writer, "column", "setCaption");
        CodeGenHelper.genSetHelp(column.getHelp(), writer, "column");
        writer.code("column.setId(\"%s\");", new Object[]{column.getId()});
        if (!(column instanceof UiWidgetTableBox.WidgetColumn)) {
            return;
        }
        UiWidgetTableBox.WidgetColumn widgetColumn = (UiWidgetTableBox.WidgetColumn)column;
        if (widgetColumn.getPrefWidth() != null) {
            writer.code("column.setPrefWidth(Double.valueOf(%s));", new Object[]{widgetColumn.getPrefWidth()});
        }
        if (widgetColumn.getPrefWidthEm() != null) {
            writer.code("column.setPrefWidthEm(Double.valueOf(%s));", new Object[]{widgetColumn.getPrefWidthEm()});
        }
        if (widgetColumn.getMaxWidthEm() != null) {
            writer.code("column.setMaxWidthEm(Double.valueOf(%s));", new Object[]{widgetColumn.getMaxWidthEm()});
        }
        if (widgetColumn.getMinWidthEm() != null) {
            writer.code("column.setMinWidthEm(Double.valueOf(%s));", new Object[]{widgetColumn.getMinWidthEm()});
        }
        writer.code("column.setNotHGrowable(%s);", new Object[]{String.valueOf(widgetColumn.isNotHGrowable())});
        CodeGenHelper.genForLabel(widgetColumn.getWidget().getFieldName(), writer, "column", "setFieldName");
        if (widgetColumn.getWidget().getNotEditable() != null) {
            writer.code("column.setNotEditable(Boolean.%s);", new Object[]{widgetColumn.getWidget().getNotEditable() != false ? "TRUE" : "FALSE"});
        }
    }

    abstract void generateWidgetColumn(JavaWriter var1, GenerationContext var2, UiWidgetTableBox var3, String var4, UiWidgetTableBox.BaseColumn var5) throws Exception;
}

