/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CardsContainerGenerator;
import com.gridnine.xtrip.client.fx.core.gen.CellsContainerGenerator;
import com.gridnine.xtrip.client.fx.core.gen.ControllerGenerator;
import com.gridnine.xtrip.client.fx.core.gen.GridContainerGenerator;
import com.gridnine.xtrip.client.fx.core.gen.ModelGenerator;
import com.gridnine.xtrip.client.fx.core.gen.SimpleContainerGenerator;
import com.gridnine.xtrip.client.fx.core.gen.TilesSpaceGenerator;
import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.meta.ui.UiCellsContainer;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiGridContainer;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.meta.ui.UiSimpleContainer;
import com.gridnine.xtrip.common.meta.ui.UiTile;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.meta.ui.UiWidgetBigTableBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetDataView;
import com.gridnine.xtrip.common.meta.ui.UiWidgetGroupsBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetNavigatorBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetPopupBox;
import com.gridnine.xtrip.common.meta.ui.UiWidgetTableBox;
import com.gridnine.xtrip.common.model.Xeption;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiCodeGen
implements CodeGen {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public void generate(GenerationContext ctx) throws Exception {
        this.validateMetaModel(ctx.getUiMetaRegistry());
        JavaWriter writer = new JavaWriter();
        HashMap<String, ModelGenerator.ModelClass> models = new HashMap<String, ModelGenerator.ModelClass>();
        for (UiModel model : ctx.getUiMetaRegistry().getModels().values()) {
            if (!ctx.getUiTypesFilter().accept(model)) continue;
            ModelGenerator.collect(models, ctx, model);
        }
        for (UiTilesSpace space : ctx.getUiMetaRegistry().getSpaces().values()) {
            if (!ctx.getUiTypesFilter().accept((BaseUiMetaElement)space)) continue;
            this.log.debug("generating space " + space.getId());
            ModelGenerator.collect(models, ctx, space);
            TilesSpaceGenerator.generate(writer, ctx, space);
            ControllerGenerator.generate(writer, ctx, space);
        }
        for (BaseUiContainer ctr : ctx.getUiMetaRegistry().getContainers().values()) {
            if (!ctx.getUiTypesFilter().accept((BaseUiMetaElement)ctr)) continue;
            this.log.debug("generating container " + ctr.getId());
            if (ctr instanceof UiGridContainer) {
                UiGridContainer gridCtr = (UiGridContainer)ctr;
                ModelGenerator.collect(models, ctx, gridCtr);
                GridContainerGenerator.generate(writer, ctx, gridCtr);
                ControllerGenerator.generate(writer, ctx, gridCtr);
                continue;
            }
            if (ctr instanceof UiCellsContainer) {
                UiCellsContainer cellsCtr = (UiCellsContainer)ctr;
                ModelGenerator.collect(models, ctx, cellsCtr);
                CellsContainerGenerator.generate(writer, ctx, cellsCtr);
                ControllerGenerator.generate(writer, ctx, cellsCtr);
                continue;
            }
            if (ctr instanceof UiCardsContainer) {
                UiCardsContainer listCtr = (UiCardsContainer)ctr;
                ModelGenerator.collect(models, ctx, listCtr);
                CardsContainerGenerator.generate(writer, ctx, listCtr);
                ControllerGenerator.generate(writer, ctx, listCtr);
                continue;
            }
            if (ctr instanceof UiSimpleContainer) {
                UiSimpleContainer simpleCtr = (UiSimpleContainer)ctr;
                ModelGenerator.collect(models, ctx, simpleCtr);
                SimpleContainerGenerator.generate(writer, ctx, simpleCtr);
                ControllerGenerator.generate(writer, ctx, simpleCtr);
                continue;
            }
            throw Xeption.forDeveloper((String)"unsupported container type {0}", (Object[])new Object[]{ctr.getClass().getName()});
        }
        ModelGenerator.generate(writer, ctx, models);
    }

    private void validateMetaModel(UiMetaRegistry uiMetaRegistry) {
        for (UiTilesSpace space : uiMetaRegistry.getSpaces().values()) {
            long count;
            UiTile tile2;
            if (space.getModel() == null) {
                throw Xeption.forDeveloper((String)("no model specified for space " + space.getId()), (Object[])new Object[0]);
            }
            if (space.getTiles().isEmpty()) {
                throw Xeption.forDeveloper((String)("no tiles defined for space " + space.getId()), (Object[])new Object[0]);
            }
            if (space.getTiles().size() == 1 && space.getOverview() == null && ((tile2 = (UiTile)space.getTiles().get(0)).getFullPayload() == null || tile2.getCompactPayload() != null)) {
                throw Xeption.forDeveloper((String)"single tile space {0} is special case - full view is required but compact view is not allowed", (Object[])new Object[]{space.getId()});
            }
            if (space.getOverview() != null) {
                this.validate(uiMetaRegistry, space.getOverview(), error -> {
                    throw Xeption.forDeveloper((String)String.format("%s for overview in space %s", error, space.getId()), (Object[])new Object[0]);
                });
            }
            if ((count = space.getTiles().stream().filter(tile -> tile.getCompactPayload() == null).count()) != 0L && count != (long)space.getTiles().size()) {
                throw Xeption.forDeveloper((String)("no compact views allowed in \"super compact mode\" for space " + space.getId()), (Object[])new Object[0]);
            }
            for (UiTile tile3 : space.getTiles()) {
                if (tile3.getCompactPayload() == null && tile3.getFullPayload() == null) {
                    throw Xeption.forDeveloper((String)String.format("no compact nor full view defined for tile %s in space %s", tile3.getId(), space.getId()), (Object[])new Object[0]);
                }
                if (tile3.getCompactPayload() != null) {
                    this.validate(uiMetaRegistry, tile3.getCompactPayload(), error -> {
                        throw Xeption.forDeveloper((String)String.format("%s for compact view of tile %s in space %s", error, tile3.getId(), space.getId()), (Object[])new Object[0]);
                    });
                }
                if (tile3.getFullPayload() == null) continue;
                this.validate(uiMetaRegistry, tile3.getFullPayload(), error -> {
                    throw Xeption.forDeveloper((String)String.format("%s for full view of tile %s in space %s", error, tile3.getId(), space.getId()), (Object[])new Object[0]);
                });
            }
            this.validateProperties(space.getProperties(), space.getTiles().stream().map(BaseMetaElement::getId).collect(Collectors.toSet()), error -> {
                throw Xeption.forDeveloper((String)String.format("%s in tiles space %s", error, space.getId()), (Object[])new Object[0]);
            });
        }
        for (BaseUiContainer ctr : uiMetaRegistry.getContainers().values()) {
            if (ctr.getModel() == null) {
                throw Xeption.forDeveloper((String)("no model specified for container " + ctr.getId()), (Object[])new Object[0]);
            }
            if (ctr instanceof UiGridContainer) {
                UiGridContainer gridCtr = (UiGridContainer)ctr;
                if (gridCtr.getCells().isEmpty()) {
                    throw Xeption.forDeveloper((String)("no cells defined for grid container " + ctr.getId()), (Object[])new Object[0]);
                }
                for (UiGridContainer.Cell cell2 : gridCtr.getCells()) {
                    if (UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell2)) continue;
                    if (cell2.getPayload() == null) {
                        throw Xeption.forDeveloper((String)String.format("no payload defined for cell %s in grid container %s", cell2.getId(), ctr.getId()), (Object[])new Object[0]);
                    }
                    this.validate(uiMetaRegistry, cell2.getPayload(), error -> {
                        throw Xeption.forDeveloper((String)String.format("%s for cell %s in grid container %s", error, cell2.getId(), ctr.getId()), (Object[])new Object[0]);
                    });
                }
                this.validateProperties(gridCtr.getProperties(), gridCtr.getCells().stream().filter(cell -> !UiGridContainer.isNewRowMarker((UiGridContainer.Cell)cell)).map(BaseMetaElement::getId).collect(Collectors.toSet()), error -> {
                    throw Xeption.forDeveloper((String)String.format("%s in grid container %s", error, ctr.getId()), (Object[])new Object[0]);
                });
                continue;
            }
            if (ctr instanceof UiCellsContainer) {
                UiCellsContainer cellsCtr = (UiCellsContainer)ctr;
                if (cellsCtr.getColumns().isEmpty()) {
                    throw Xeption.forDeveloper((String)("no columns defined for cells container " + ctr.getId()), (Object[])new Object[0]);
                }
                if (cellsCtr.getCells().isEmpty()) {
                    throw Xeption.forDeveloper((String)("no cells defined for cells container " + ctr.getId()), (Object[])new Object[0]);
                }
                for (UiGridContainer.Cell cell2 : cellsCtr.getCells()) {
                    if (cell2 instanceof UiCellsContainer.SimpleCell) continue;
                    if (!(cell2 instanceof UiCellsContainer.ComplexCell)) {
                        throw Xeption.forDeveloper((String)String.format("unsupported type of cell %s in cells container %s", cell2.getId(), ctr.getId()), (Object[])new Object[0]);
                    }
                    UiCellsContainer.ComplexCell complexCell = (UiCellsContainer.ComplexCell)cell2;
                    if (complexCell.getPayload() == null) {
                        throw Xeption.forDeveloper((String)String.format("no payload defined for cell %s in cells container %s", cell2.getId(), ctr.getId()), (Object[])new Object[0]);
                    }
                    this.validate(uiMetaRegistry, complexCell.getPayload(), arg_0 -> UiCodeGen.lambda$validateMetaModel$8((UiCellsContainer.BaseCell)cell2, ctr, arg_0));
                }
                this.validateProperties(cellsCtr.getProperties(), cellsCtr.getCells().stream().map(BaseMetaElement::getId).collect(Collectors.toSet()), error -> {
                    throw Xeption.forDeveloper((String)String.format("%s in cells container %s", error, ctr.getId()), (Object[])new Object[0]);
                });
                continue;
            }
            if (ctr instanceof UiCardsContainer) {
                UiCardsContainer cardsCtr = (UiCardsContainer)ctr;
                if (cardsCtr.getCards().isEmpty()) {
                    throw Xeption.forDeveloper((String)("no items defined for cards container " + ctr.getId()), (Object[])new Object[0]);
                }
                for (UiCardsContainer.Card card : cardsCtr.getCards()) {
                    if (card.getPayload() == null) {
                        throw Xeption.forDeveloper((String)String.format("no payload defined for card %s in cards container %s", card.getId(), ctr.getId()), (Object[])new Object[0]);
                    }
                    this.validate(uiMetaRegistry, card.getPayload(), error -> {
                        throw Xeption.forDeveloper((String)String.format("%s for card %s in cards container %s", error, card.getId(), ctr.getId()), (Object[])new Object[0]);
                    });
                }
                this.validateProperties(cardsCtr.getProperties(), cardsCtr.getCards().stream().map(BaseMetaElement::getId).collect(Collectors.toSet()), error -> {
                    throw Xeption.forDeveloper((String)String.format("%s in cards container %s", error, ctr.getId()), (Object[])new Object[0]);
                });
                continue;
            }
            if (!(ctr instanceof UiSimpleContainer)) continue;
            UiSimpleContainer simpleCtr = (UiSimpleContainer)ctr;
            if (simpleCtr.getPayload() == null) {
                throw Xeption.forDeveloper((String)("no payload defined for simple container " + ctr.getId()), (Object[])new Object[0]);
            }
            this.validate(uiMetaRegistry, simpleCtr.getPayload(), error -> {
                throw Xeption.forDeveloper((String)String.format("%s for simple container %s", error, ctr.getId()), (Object[])new Object[0]);
            });
        }
    }

    private void validateProperties(List<UiModel.Field> properties, Set<String> ids, Consumer<String> onError) {
        for (UiModel.Field prop : properties) {
            if (!ids.contains(prop.getId())) continue;
            onError.accept("ambigious property with id " + prop.getId());
            break;
        }
    }

    private void validate(UiMetaRegistry uiMetaRegistry, UiElement payload, Consumer<String> onError) {
        block23: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block22: {
                                    if (!(payload instanceof UiContainerReference)) break block22;
                                    UiContainerReference ref = (UiContainerReference)payload;
                                    if (!uiMetaRegistry.getContainers().containsKey(ref.getId())) {
                                        onError.accept("no container found with id " + ref.getId());
                                        return;
                                    }
                                    break block23;
                                }
                                if (!(payload instanceof UiWidgetPopupBox)) break block24;
                                UiWidgetPopupBox widget = (UiWidgetPopupBox)payload;
                                if (widget.getPayload() == null) {
                                    onError.accept("no payload found in popup-box widget");
                                    return;
                                }
                                if (!uiMetaRegistry.getContainers().containsKey(widget.getPayload().getId())) {
                                    onError.accept("no container found with id " + widget.getPayload().getId());
                                    return;
                                }
                                break block23;
                            }
                            if (!(payload instanceof UiWidgetGroupsBox)) break block25;
                            UiWidgetGroupsBox widget = (UiWidgetGroupsBox)payload;
                            if (widget.getStyle() == null) {
                                onError.accept("no style provided for groups-box widget");
                                return;
                            }
                            if (widget.getPayload() == null) {
                                onError.accept("no payload found in groups-box widget");
                                return;
                            }
                            if (!uiMetaRegistry.getContainers().containsKey(widget.getPayload().getId())) {
                                onError.accept("no container found with id " + widget.getPayload().getId());
                                return;
                            }
                            break block23;
                        }
                        if (!(payload instanceof UiWidgetNavigatorBox)) break block26;
                        UiWidgetNavigatorBox widget = (UiWidgetNavigatorBox)payload;
                        if (widget.getStyle() == null) {
                            onError.accept("no style provided for navigator-box widget");
                            return;
                        }
                        if (widget.getVariants().isEmpty()) {
                            onError.accept("no variants found in navigator-box widget");
                            return;
                        }
                        for (UiWidgetNavigatorBox.Variant variant : widget.getVariants()) {
                            if (variant.getPayload() == null) {
                                onError.accept("no payload found for variant in navigator-box widget");
                                return;
                            }
                            if (uiMetaRegistry.getContainers().containsKey(variant.getPayload().getId())) continue;
                            onError.accept("no container found with id " + variant.getPayload().getId());
                            return;
                        }
                        break block23;
                    }
                    if (!(payload instanceof UiWidgetTableBox)) break block27;
                    UiWidgetTableBox widget = (UiWidgetTableBox)payload;
                    if (widget.getModel() == null) {
                        onError.accept("no model specified in table-box widget");
                        return;
                    }
                    for (UiWidgetTableBox.BaseColumn column : widget.getColumns()) {
                        if (column instanceof UiWidgetTableBox.WidgetColumn) {
                            UiWidgetTableBox.WidgetColumn widgetColumn = (UiWidgetTableBox.WidgetColumn)column;
                            if (widgetColumn.getWidget() != null) continue;
                            onError.accept(String.format("no widget provided for column %s in table-box widget", column.getId()));
                            return;
                        }
                        if (column instanceof UiWidgetTableBox.SuperColumn) {
                            UiWidgetTableBox.SuperColumn superColumn = (UiWidgetTableBox.SuperColumn)column;
                            if (superColumn.getPayload() == null) {
                                onError.accept(String.format("no payload provided for column %s in table-box widget", column.getId()));
                                return;
                            }
                            if (uiMetaRegistry.getContainers().containsKey(superColumn.getPayload().getId())) continue;
                            onError.accept(String.format("no container with id %s found for column %s in table-box widget", superColumn.getPayload().getId(), column.getId()));
                            return;
                        }
                        if (column instanceof UiWidgetTableBox.CustomColumn) continue;
                        onError.accept(String.format("unsupported type %s of column %s defined in table-box widget", column.getClass().getName(), column.getId()));
                        return;
                    }
                    break block23;
                }
                if (!(payload instanceof UiWidgetDataView)) break block28;
                UiWidgetDataView widget = (UiWidgetDataView)payload;
                if (widget.getModel() == null) {
                    onError.accept("no model specified in data-view widget");
                    return;
                }
                if (widget.getColumns().isEmpty()) {
                    onError.accept("no columns defined in data-view widget");
                    return;
                }
                break block23;
            }
            if (!(payload instanceof UiWidgetBigTableBox)) break block23;
            UiWidgetBigTableBox widget = (UiWidgetBigTableBox)payload;
            if (widget.getModel() == null) {
                onError.accept("no model specified in big-table-box widget");
                return;
            }
            if (widget.getColumns().isEmpty()) {
                onError.accept("no columns defined in big-table-box widget");
                return;
            }
            for (UiWidgetBigTableBox.BaseColumn column : widget.getColumns()) {
                if (column instanceof UiWidgetBigTableBox.SimpleColumn || column instanceof UiWidgetBigTableBox.ComboBoxColumn || column instanceof UiWidgetBigTableBox.NestedEntityReferenceColumn || column instanceof UiWidgetBigTableBox.KeyValueColumn) continue;
                if (column instanceof UiWidgetBigTableBox.SuperColumn) {
                    UiWidgetBigTableBox.SuperColumn superColumn = (UiWidgetBigTableBox.SuperColumn)column;
                    if (superColumn.getPayload() == null) {
                        onError.accept(String.format("no payload provided for column %s in big-table-box widget", column.getId()));
                        return;
                    }
                    if (uiMetaRegistry.getContainers().containsKey(superColumn.getPayload().getId())) continue;
                    onError.accept(String.format("no container with id %s found for column %s in big-table-box widget", superColumn.getPayload().getId(), column.getId()));
                    return;
                }
                onError.accept(String.format("unsupported type %s of column %s defined in big-table-box widget", column.getClass().getName(), column.getId()));
                return;
            }
        }
    }

    private static /* synthetic */ void lambda$validateMetaModel$8(UiCellsContainer.BaseCell cell, BaseUiContainer ctr, String error) {
        throw Xeption.forDeveloper((String)String.format("%s for cell %s in cells container %s", error, cell.getId(), ctr.getId()), (Object[])new Object[0]);
    }
}

