/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.kb;

import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.common.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javafx.scene.input.KeyCombination;
import org.slf4j.LoggerFactory;

public class KeyBindings {
    private static KeyBindings instance;
    private final File file;
    private final Map<String, KeyCombination> action2keyCombination = new HashMap<String, KeyCombination>();
    private boolean dirty;

    public static synchronized KeyBindings get() {
        if (instance == null) {
            instance = new KeyBindings();
        }
        return instance;
    }

    private KeyBindings() {
        this.file = new File(Environment.getDataFolder(), "settings/key-bindings.properties");
        if (!this.file.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (FileInputStream strm = new FileInputStream(this.file);){
            props.load(strm);
        }
        catch (IOException ioe) {
            LoggerFactory.getLogger(this.getClass()).error("failed loading key bindings from file " + this.file, (Throwable)ioe);
        }
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String id = (String)en.nextElement();
            if (KeyBindingAction.forId(id) == null) continue;
            String keyComb = props.getProperty(id);
            try {
                this.action2keyCombination.put(id, KeyCombination.valueOf((String)keyComb));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("invalid key combination " + keyComb, (Throwable)e);
            }
        }
    }

    public KeyCombination getKeyCombination(KeyBindingAction action) {
        KeyCombination result = this.action2keyCombination.get(action.getId());
        return result == null ? action.getDefaultKeyCombination() : result;
    }

    public void setKeyCombination(KeyBindingAction action, KeyCombination keyCombination) {
        KeyCombination old;
        this.dirty = keyCombination == null || action.getDefaultKeyCombination().equals((Object)keyCombination) ? (this.dirty |= this.action2keyCombination.remove(action.getId()) != null) : (this.dirty |= (old = this.action2keyCombination.put(action.getId(), keyCombination)) == null || !old.equals((Object)keyCombination));
    }

    public void save() {
        if (!this.dirty) {
            return;
        }
        this.file.getParentFile().mkdirs();
        if (this.action2keyCombination.isEmpty()) {
            this.file.delete();
        } else {
            Properties props = new Properties();
            for (Map.Entry<String, KeyCombination> entry : this.action2keyCombination.entrySet()) {
                props.setProperty(entry.getKey(), entry.getValue().getName());
            }
            try (FileOutputStream out = new FileOutputStream(this.file);){
                props.store(out, null);
            }
            catch (IOException ioe) {
                LoggerFactory.getLogger(this.getClass()).error("failed saving key bindings to file " + this.file, (Throwable)ioe);
            }
        }
        this.dirty = false;
    }
}

