/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib;

import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.common.util.Identity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;

enum NodeHandler {
    SPACE{

        @Override
        protected boolean isAwareOf(Node node) {
            return node instanceof TilesSpace;
        }

        @Override
        List<Node> getChildren(Node node) {
            return ((TilesSpace)node).getTiles().stream().filter(tile -> tile.getFullNode() != null).map(Tile::getFullNode).collect(Collectors.toList());
        }

        @Override
        Object save(Node node) {
            List<Tile<?, ?>> tiles = ((TilesSpace)node).getTiles();
            for (int i = 0; i < tiles.size(); ++i) {
                Tile<?, ?> tile = tiles.get(i);
                if (!tile.isExpanded()) continue;
                return i;
            }
            return null;
        }

        @Override
        void restore(Node node, Object state) {
            TilesSpace space;
            List<Tile<?, ?>> tiles;
            if (state == null) {
                return;
            }
            int idx = (Integer)state;
            if (idx < (tiles = (space = (TilesSpace)node).getTiles()).size()) {
                space.expand(tiles.get(idx));
            }
        }

        @Override
        void buildNavigationPath(List<Runnable> path, Node node, String key) {
            TilesSpace space = (TilesSpace)node;
            for (Tile<?, ?> tile : space.getTiles()) {
                if (tile.getFullNode() == null) continue;
                path.add(() -> space.expand(tile));
                if (key.equals(tile.getFullNode().getProperties().get((Object)"model-uid"))) {
                    return;
                }
                int pathLength = path.size();
                ViewWalker.buildNavigationPath(path, tile.getFullNode(), key);
                if (pathLength != path.size()) {
                    return;
                }
                path.remove(pathLength - 1);
            }
        }
    }
    ,
    GROUP{

        @Override
        protected boolean isAwareOf(Node node) {
            return node instanceof BaseGroupsWidget;
        }

        @Override
        List<Node> getChildren(Node node) {
            return ((BaseGroupsWidget)node).getChildren();
        }

        @Override
        Object save(Node node) {
            BaseGroupsWidget widget = (BaseGroupsWidget)node;
            Object selected = widget.getSelectedView();
            return selected == null ? null : Integer.valueOf(widget.getViews().indexOf(selected));
        }

        @Override
        void restore(Node node, Object state) {
            if (state == null) {
                return;
            }
            int idx = (Integer)state;
            BaseGroupsWidget widget = (BaseGroupsWidget)node;
            if (idx >= 0 && idx < widget.getViews().size()) {
                widget.selectView((Node)widget.getViews().get(idx));
            }
        }

        @Override
        void buildNavigationPath(List<Runnable> path, Node node, String key) {
            BaseGroupsWidget widget = (BaseGroupsWidget)node;
            for (Node view : widget.getViews()) {
                path.add(() -> widget.selectView(view));
                if (key.equals(view.getProperties().get((Object)"model-uid"))) {
                    return;
                }
                int pathLength = path.size();
                ViewWalker.buildNavigationPath(path, view, key);
                if (pathLength != path.size()) {
                    return;
                }
                path.remove(pathLength - 1);
            }
        }
    }
    ,
    NAVIGATOR{

        @Override
        protected boolean isAwareOf(Node node) {
            return node instanceof BaseNavigatorWidget;
        }

        @Override
        List<Node> getChildren(Node node) {
            return ((BaseNavigatorWidget)node).getChildren();
        }

        @Override
        Object save(Node node) {
            BaseNavigatorWidget widget = (BaseNavigatorWidget)node;
            Node selected = widget.getSelectedView();
            return selected == null ? null : Integer.valueOf(widget.getViews().indexOf((Object)selected));
        }

        @Override
        void restore(Node node, Object state) {
            BaseNavigatorWidget widget;
            if (state == null) {
                return;
            }
            int idx = (Integer)state;
            if (idx < (widget = (BaseNavigatorWidget)node).getViews().size()) {
                widget.selectView((Node)widget.getViews().get(idx));
            }
        }

        @Override
        void buildNavigationPath(List<Runnable> path, Node node, String key) {
            BaseNavigatorWidget widget = (BaseNavigatorWidget)node;
            for (Node view : widget.getViews()) {
                path.add(() -> widget.selectView(view));
                if (key.equals(view.getProperties().get((Object)"model-uid"))) {
                    return;
                }
                int pathLength = path.size();
                ViewWalker.buildNavigationPath(path, view, key);
                if (pathLength != path.size()) {
                    return;
                }
                path.remove(pathLength - 1);
            }
        }
    }
    ,
    CARDS{

        @Override
        protected boolean isAwareOf(Node node) {
            return node instanceof CardsContainer;
        }

        @Override
        List<Node> getChildren(Node node) {
            return ((CardsContainer)node).getCards().stream().map(Card::getContent).collect(Collectors.toList());
        }

        @Override
        Object save(Node node) {
            CardsContainer cc = (CardsContainer)node;
            ObservableList<Card<?>> cards = cc.getCards();
            boolean[] result = new boolean[cards.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ((Card)cards.get(i)).isCollapsed();
            }
            return result;
        }

        @Override
        void restore(Node node, Object state) {
            if (state == null) {
                return;
            }
            CardsContainer cc = (CardsContainer)node;
            boolean[] states = (boolean[])state;
            ObservableList<Card<?>> cards = cc.getCards();
            int min = Math.min(states.length, cards.size());
            for (int i = 0; i < min; ++i) {
                Card card = (Card)cards.get(i);
                if (!card.isCollapsible()) continue;
                card.setCollapsed(states[i]);
            }
        }

        @Override
        void buildNavigationPath(List<Runnable> path, Node node, String key) {
            CardsContainer cc = (CardsContainer)node;
            for (Card card : cc.getCards()) {
                path.add(() -> card.setCollapsed(false));
                if (key.equals(card.getContent().getProperties().get((Object)"model-uid"))) {
                    return;
                }
                int pathLength = path.size();
                ViewWalker.buildNavigationPath(path, card.getContent(), key);
                if (pathLength != path.size()) {
                    return;
                }
                path.remove(pathLength - 1);
            }
        }
    }
    ,
    TABLE{

        @Override
        protected boolean isAwareOf(Node node) {
            return node instanceof TableWidget;
        }

        @Override
        List<Node> getChildren(Node node) {
            return Collections.emptyList();
        }

        @Override
        Object save(Node node) {
            return null;
        }

        @Override
        void restore(Node node, Object state) {
        }

        @Override
        void buildNavigationPath(List<Runnable> path, Node node, String key) {
            TableWidget widget = (TableWidget)node;
            for (Object obj : widget.getRowsData()) {
                if (!(obj instanceof Identity) || !key.equals(((Identity)obj).getUid())) continue;
                path.add(() -> {});
                return;
            }
        }
    };


    protected abstract boolean isAwareOf(Node var1);

    abstract List<Node> getChildren(Node var1);

    abstract Object save(Node var1);

    abstract void restore(Node var1, Object var2);

    abstract void buildNavigationPath(List<Runnable> var1, Node var2, String var3);

    static NodeHandler forNode(Node node) {
        for (NodeHandler handler : NodeHandler.values()) {
            if (!handler.isAwareOf(node)) continue;
            return handler;
        }
        return null;
    }
}

