/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib;

import com.gridnine.xtrip.client.fx.core.lib.NodeHandler;
import com.gridnine.xtrip.client.fx.core.lib.StateItem;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;

public final class ViewWalker {
    public static void navigateTo(Node node, String key) {
        ArrayList<Runnable> path = new ArrayList<Runnable>();
        ViewWalker.buildNavigationPath(path, node, key);
        path.forEach(Runnable::run);
    }

    static void buildNavigationPath(List<Runnable> path, Node node, String key) {
        NodeHandler handler = NodeHandler.forNode(node);
        if (handler != null) {
            handler.buildNavigationPath(path, node, key);
        } else if (node instanceof Parent) {
            int pathLength = path.size();
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                ViewWalker.buildNavigationPath(path, child, key);
                if (pathLength == path.size()) continue;
                return;
            }
        }
    }

    public static void saveState(Node node) {
        ArrayList<StateItem> items = new ArrayList<StateItem>();
        ViewWalker.collect(items, node, 0);
        if (!items.isEmpty()) {
            node.getProperties().put((Object)"view-state", items);
        }
    }

    private static void collect(List<StateItem> items, Node node, int level) {
        Object children;
        NodeHandler handler = NodeHandler.forNode(node);
        if (handler != null) {
            items.add(new StateItem(level, handler.save(node), handler));
            children = handler.getChildren(node);
        } else if (node instanceof Parent) {
            children = ((Parent)node).getChildrenUnmodifiable();
        } else {
            return;
        }
        for (Node child : children) {
            ViewWalker.collect(items, child, level + 1);
        }
    }

    public static void restoreState(Node node) {
        List items = (List)node.getProperties().remove((Object)"view-state");
        if (items == null) {
            return;
        }
        ViewWalker.restore(items, node, 0);
    }

    private static void restore(List<StateItem> items, Node node, int level) {
        if (items.isEmpty()) {
            return;
        }
        NodeHandler handler = NodeHandler.forNode(node);
        if (handler == null) {
            if (node instanceof Parent) {
                for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                    ViewWalker.restore(items, child, level + 1);
                }
            }
            return;
        }
        StateItem item = items.remove(0);
        if (item.level != level || item.handler != handler) {
            items.clear();
            return;
        }
        handler.restore(node, item.state);
        if (items.isEmpty()) {
            return;
        }
        for (Node child : handler.getChildren(node)) {
            ViewWalker.restore(items, child, level + 1);
            if (!items.isEmpty()) continue;
            return;
        }
    }

    private ViewWalker() {
    }
}

