/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBoxSkin;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.Objects;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;

public class CustomComboBox<T>
extends ComboBox<T> {
    ButtonStyle buttonStyle = ButtonStyle.STANDARD;
    boolean noNulls;
    String clearButtonTooltip = Messages.General_Clean;
    Runnable clearAction = () -> {
        this.requestFocus();
        this.setValue(null);
    };

    public CustomComboBox() {
        this.getStyleClass().addAll((Object[])new String[]{"custom-combo-box", "xtrip-scroll-alt"});
        this.addEventHandler(ComboBoxBase.ON_SHOWN, evt -> {
            CustomComboBoxSkin skin = (CustomComboBoxSkin)this.getSkin();
            ListView listView = (ListView)skin.getPopupContent();
            Object value = this.getValue();
            if (value == null) {
                return;
            }
            int idx = listView.getItems().indexOf(value);
            if (idx >= 0) {
                listView.scrollTo(idx);
            }
        });
        FxUtil.addListener(this.valueProperty(), (s, o, n) -> this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, n == null || UiUtil.NULL_TEXT.equals(n.toString())));
    }

    public void setButtonStyle(ButtonStyle value) {
        this.buttonStyle = Objects.requireNonNull(value);
    }

    public void setNoNulls(boolean val) {
        this.noNulls = val;
    }

    public void setClearButtonTooltip(String value) {
        this.clearButtonTooltip = value;
        CustomComboBoxSkin skin = (CustomComboBoxSkin)this.getSkin();
        if (skin != null) {
            skin.updateTooltips();
        }
    }

    public void setClearAction(Runnable value) {
        this.clearAction = Objects.requireNonNull(value);
    }

    protected Skin<?> createDefaultSkin() {
        return new CustomComboBoxSkin(this);
    }

    public static enum ButtonStyle {
        STANDARD{

            @Override
            IconShape getIconShape() {
                return StandardIconShapes.COMBOBOX_DOWN_ARROW;
            }
        }
        ,
        LIST{

            @Override
            IconShape getIconShape() {
                return StandardIconShapes.COMBOBOX_LIST_ARROW;
            }
        }
        ,
        NAVIGATION{

            @Override
            IconShape getIconShape() {
                return StandardIconShapes.RULER_14X14;
            }
        }
        ,
        HIDDEN{

            @Override
            IconShape getIconShape() {
                return null;
            }
        };


        abstract IconShape getIconShape();
    }
}

