/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabelSkin;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public class CustomLabel
extends Label {
    final ReadOnlyBooleanWrapper truncated = new ReadOnlyBooleanWrapper();

    public CustomLabel() {
        this.init();
    }

    public CustomLabel(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"custom-label");
        this.textProperty().addListener((s, o, n) -> {
            if (this.truncated.get() && !TextUtil.isBlank((String)this.getText())) {
                Tooltip tooltip = this.getTooltip();
                if (tooltip == null) {
                    tooltip = new Tooltip(this.getText());
                    this.setTooltip(tooltip);
                } else {
                    tooltip.setText(this.getText());
                }
            } else {
                this.setTooltip(null);
            }
        });
        this.truncated.addListener((s, o, n) -> {
            if (n.booleanValue() && !TextUtil.isBlank((String)this.getText())) {
                this.setTooltip(new Tooltip(this.getText()));
            } else {
                this.setTooltip(null);
            }
        });
        this.setOnContextMenuRequested(evt -> {
            CustomContextMenu menu = new CustomContextMenu();
            CustomMenuItem item = new CustomMenuItem(Messages.General_Copy_text);
            item.setOnAction(evt2 -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, this.getText())));
            menu.getItems().add((Object)item);
            menu.show((Node)this, evt.getScreenX(), evt.getScreenY());
        });
    }

    public ReadOnlyBooleanProperty truncatedProperty() {
        return this.truncated.getReadOnlyProperty();
    }

    public boolean isTruncated() {
        return this.truncated.get();
    }

    protected Skin<?> createDefaultSkin() {
        return new CustomLabelSkin(this);
    }
}

