/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class ExtendedMessagePane
extends HBox {
    private final MessageType type;

    public static ExtendedMessagePane forMessage(Message message, IndexListParameters<?, ?> parameters, String listTitle) {
        return new ExtendedMessagePane(message.getType() == null ? MessageType.WARNING : message.getType(), message.getMessage() == null ? message.toString() : message.getMessage().toString(), message.getUid(), message.getDetails(), parameters, listTitle);
    }

    protected ExtendedMessagePane(MessageType type, String message, String messageUid, String details, IndexListParameters<?, ?> parameters, String listTitle) {
        StackPane sp;
        IconNode icon;
        String typeClass;
        this.type = type;
        switch (type) {
            case ERROR: {
                typeClass = "error";
                icon = new IconNode(StandardIconShapes.VALIDATOR_ERROR, null, StandardIconIntentions.VALIDATOR_ERROR, null);
                break;
            }
            case FOR_USER: 
            case MESSAGE: {
                typeClass = "info";
                icon = new IconNode(StandardIconShapes.VALIDATOR_MESSAGE, null, StandardIconIntentions.VALIDATOR_MESSAGE, null);
                break;
            }
            default: {
                typeClass = "warning";
                icon = new IconNode(StandardIconShapes.VALIDATOR_WARNING, null, StandardIconIntentions.VALIDATOR_WARNING, null);
            }
        }
        this.getStyleClass().addAll((Object[])new String[]{"message-pane", typeClass});
        CustomLabel text = new CustomLabel(message);
        this.getChildren().add((Object)text);
        text.setGraphic((Node)icon);
        if (parameters != null) {
            HyperlinkWidget listLink = new HyperlinkWidget();
            listLink.setText(listTitle == null ? Messages.List_link : listTitle);
            listLink.setOnAction(event -> IndexListService.get().open("list-for-message-" + messageUid, listTitle == null ? Messages.List_link : listTitle, parameters));
            sp = new StackPane(new Node[]{listLink});
            sp.setAlignment(Pos.CENTER_LEFT);
            this.getChildren().add((Object)sp);
        }
        if (details != null) {
            HyperlinkWidget detailsLink = new HyperlinkWidget();
            detailsLink.setText(Messages.General_Details);
            detailsLink.setOnAction(event -> Dialog.message((Node)this, Messages.General_Details, details));
            sp = new StackPane(new Node[]{detailsLink});
            sp.setAlignment(Pos.CENTER_RIGHT);
            this.getChildren().add((Object)sp);
        }
        HBox.setHgrow((Node)((Node)this.getChildren().get(this.getChildren().size() - 1)), (Priority)Priority.ALWAYS);
    }

    public ExtendedMessagePane makeClosable(Runnable callback) {
        IconNode clearButton;
        switch (this.type) {
            case ERROR: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_ERROR, null);
                break;
            }
            case FOR_USER: 
            case MESSAGE: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_MESSAGE, null);
                break;
            }
            default: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_WARNING, null);
            }
        }
        clearButton.getStyleClass().addAll((Object[])new String[]{"clear-button"});
        Tooltip.install((Node)clearButton, (Tooltip)new Tooltip(Messages.General_Delete_message));
        clearButton.setOnMouseReleased(event -> {
            event.consume();
            callback.run();
        });
        HBox.setHgrow((Node)clearButton, (Priority)Priority.NEVER);
        this.getChildren().add((Object)clearButton);
        return this;
    }
}

