/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.icon;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconView;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class IconNode
extends StackPane {
    private final Pane nodePane;
    private IconShape iconShape;
    private final Styleable shapeParent;
    private final IconIntention iconIntention;
    private final Styleable intentionParent;

    public IconNode(IconShape iconShape, IconIntention iconIntention) {
        this(iconShape, null, iconIntention, null);
    }

    public IconNode(IconShape iconShape, Styleable shapeParent, IconIntention iconIntention, Styleable intentionParent) {
        this.iconShape = iconShape;
        this.shapeParent = shapeParent != null ? shapeParent : this;
        this.iconIntention = iconIntention;
        this.intentionParent = intentionParent != null ? intentionParent : this;
        this.getStyleClass().setAll((Object[])new String[]{"xtrip-icon-node"});
        this.nodePane = new StackPane();
        this.nodePane.getStyleClass().add((Object)"node-pane");
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null && this.nodePane.getChildren().isEmpty()) {
                IconView iconView = new IconView();
                iconView.getStyleClass().setAll((Object[])new String[]{"icon-pane"});
                this.nodePane.getChildren().add((Object)new StackPane(new Node[]{iconView}));
            }
        });
        this.getChildren().add((Object)this.nodePane);
        this.update();
    }

    private void update() {
        if (this.iconShape != null) {
            if (!this.shapeParent.getStyleClass().contains((Object)this.iconShape.getParentStyle())) {
                this.shapeParent.getStyleClass().add((Object)this.iconShape.getParentStyle());
            }
            if (!this.nodePane.getStyleClass().contains((Object)this.iconShape.getStyle())) {
                this.nodePane.getStyleClass().add((Object)this.iconShape.getStyle());
            }
        }
        if (this.iconIntention != null) {
            if (!this.intentionParent.getStyleClass().contains((Object)this.iconIntention.getParentStyle())) {
                this.intentionParent.getStyleClass().add((Object)this.iconIntention.getParentStyle());
            }
            if (!this.nodePane.getStyleClass().contains((Object)this.iconIntention.getStyle())) {
                this.nodePane.getStyleClass().add((Object)this.iconIntention.getStyle());
            }
        }
    }

    public void setIconShape(IconShape shape) {
        if (this.iconShape != null) {
            this.shapeParent.getStyleClass().remove((Object)this.iconShape.getParentStyle());
            this.nodePane.getStyleClass().remove((Object)this.iconShape.getStyle());
        }
        this.iconShape = shape;
        this.update();
    }
}

