/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.icon;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconCache;
import com.sun.javafx.css.converters.StringConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.scene.image.ImageView;

class IconView
extends ImageView {
    private StringProperty shapeStyle;
    private StringProperty intentionStyle;
    private boolean updateImage;

    IconView() {
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.update();
            }
        });
    }

    final void setShapeStyle(String value) {
        this.shapeStyleProperty().setValue(value);
    }

    final String getShapeStyle() {
        return this.shapeStyle != null ? this.shapeStyle.getValue() : null;
    }

    final StringProperty shapeStyleProperty() {
        if (this.shapeStyle == null) {
            this.shapeStyle = new StyleableStringProperty(null){

                protected void invalidated() {
                    IconView.this.updateImage = true;
                    IconView.this.update();
                }

                public CssMetaData<IconView, String> getCssMetaData() {
                    return StyleableProperties.SHAPE_STYLE;
                }

                public Object getBean() {
                    return IconView.this;
                }

                public String getName() {
                    return "shapeStyle";
                }
            };
        }
        return this.shapeStyle;
    }

    final void setIntentionStyle(String value) {
        this.intentionStyleProperty().setValue(value);
    }

    final String getIntentionStyle() {
        return this.intentionStyle != null ? this.intentionStyle.getValue() : null;
    }

    final StringProperty intentionStyleProperty() {
        if (this.intentionStyle == null) {
            this.intentionStyle = new StyleableStringProperty(null){

                protected void invalidated() {
                    IconView.this.updateImage = true;
                    IconView.this.update();
                }

                public CssMetaData<IconView, String> getCssMetaData() {
                    return StyleableProperties.INTENTION_STYLE;
                }

                public Object getBean() {
                    return IconView.this;
                }

                public String getName() {
                    return "intentionStyle";
                }
            };
        }
        return this.intentionStyle;
    }

    private void update() {
        if (this.getScene() == null || !this.updateImage) {
            return;
        }
        this.updateImage = false;
        this.setImage(IconCache.get().getImage(this.getShapeStyle(), this.getIntentionStyle()));
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return IconView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<IconView, String> SHAPE_STYLE = new CssMetaData<IconView, String>("-xtrip-shape-style", StringConverter.getInstance()){

            public boolean isSettable(IconView styleable) {
                return styleable.shapeStyle == null || !styleable.shapeStyle.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(IconView styleable) {
                return (StyleableProperty)styleable.shapeStyleProperty();
            }
        };
        private static final CssMetaData<IconView, String> INTENTION_STYLE = new CssMetaData<IconView, String>("-xtrip-intention-style", StringConverter.getInstance()){

            public boolean isSettable(IconView styleable) {
                return styleable.intentionStyle == null || !styleable.intentionStyle.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(IconView styleable) {
                return (StyleableProperty)styleable.intentionStyleProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<IconView, String>> styleables = new ArrayList<CssMetaData<IconView, String>>(ImageView.getClassCssMetaData());
            styleables.add(SHAPE_STYLE);
            styleables.add(INTENTION_STYLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

