/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.suggestions;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.BaseKeyHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionSession;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsPopup;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.control.ComboBox;

class AsyncKeyHandler<T>
extends BaseKeyHandler<T> {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r, "fx-suggestions:" + this.counter.getAndIncrement());
            result.setDaemon(true);
            return result;
        }
    });
    protected final ComboBox<T> comboBox;
    protected final SuggestionsHandler<T> suggestionsHandler;
    private ScheduledFuture<?> scheduledFuture;

    AsyncKeyHandler(ComboBox<T> cb, SuggestionsHandler<T> handler) {
        super(cb.getEditor());
        this.comboBox = cb;
        this.suggestionsHandler = handler;
    }

    @Override
    protected void initiateSession() {
        String text;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (TextUtil.isBlank((String)(text = this.editor.getText()))) {
            if (this.popup != null) {
                this.popup.hide();
            }
            return;
        }
        this.scheduledFuture = SCHEDULER.schedule(() -> {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.popup == null) {
                this.popup = new SuggestionsPopup<T>(this.comboBox, this.suggestionsHandler);
            }
            FxUtil.submitToFxThread(this.popup::loading);
            this.suggestionsHandler.startSession(new SuggestionSession<T>(){

                @Override
                public String getUserText() {
                    return text;
                }

                @Override
                public void setSuggestions(List<T> items) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    FxUtil.submitToFxThread(() -> {
                        if (AsyncKeyHandler.this.comboBox.getScene() == null || !text.equals(AsyncKeyHandler.this.editor.getText())) {
                            return;
                        }
                        AsyncKeyHandler.this.comboBox.hide();
                        if (items.size() == 1) {
                            if (AsyncKeyHandler.this.popup != null) {
                                AsyncKeyHandler.this.popup.hide();
                            }
                            Object value = items.get(0);
                            AsyncKeyHandler.this.editor.setText(AsyncKeyHandler.this.comboBox.getConverter().toString(value));
                            AsyncKeyHandler.this.comboBox.setValue(value);
                            AsyncKeyHandler.this.comboBox.getEditor().positionCaret(AsyncKeyHandler.this.comboBox.getEditor().getText().length());
                            AsyncKeyHandler.this.suggestionsHandler.onSuggestionSelected(value);
                            return;
                        }
                        if (AsyncKeyHandler.this.popup == null) {
                            AsyncKeyHandler.this.popup = new SuggestionsPopup(AsyncKeyHandler.this.comboBox, AsyncKeyHandler.this.suggestionsHandler);
                        }
                        AsyncKeyHandler.this.popup.setSuggestions(items);
                    });
                }
            });
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    void dispose() {
        super.dispose();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }
}

