/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.text;

import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import java.util.Objects;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class RichTextFlow
extends TextFlow {
    private TextHandler handler;
    private final StringProperty text = new StringPropertyBase(){

        public Object getBean() {
            return RichTextFlow.this;
        }

        public String getName() {
            return "text";
        }

        protected void invalidated() {
            RichTextFlow.this.reflow();
        }
    };

    public RichTextFlow(TextHandler textHandler) {
        this.handler = Objects.requireNonNull(textHandler);
        this.getStyleClass().addAll((Object[])new String[]{"rich-text-flow", "simple-widget"});
    }

    public RichTextFlow(TextHandler textHandler, String textContent) {
        this(textHandler);
        this.text.set((Object)textContent);
    }

    public void setHandler(TextHandler value) {
        this.handler = Objects.requireNonNull(value);
        this.reflow();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public void setText(String value) {
        this.text.set((Object)value);
    }

    public String toPlainText() {
        StringBuilder buf = new StringBuilder();
        for (Node node : this.getChildren()) {
            if (!(node instanceof Text)) continue;
            buf.append(((Text)node).getText());
        }
        return buf.toString();
    }

    protected void reflow() {
        this.getChildren().setAll(this.handler.buildFlow((String)this.text.get()));
    }
}

