/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.text;

import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.util.Pair;

class SimpleHtmlHandler
implements TextHandler {
    private static final List<Pair<Pattern, String>> ESCAPE_PATTERNS = Arrays.asList(new Pair((Object)Pattern.compile("&lt;", 16), (Object)"<"), new Pair((Object)Pattern.compile("&gt;", 16), (Object)">"), new Pair((Object)Pattern.compile("&amp;", 16), (Object)"&"), new Pair((Object)Pattern.compile("&quot;", 16), (Object)"\""), new Pair((Object)Pattern.compile("&nbsp;", 16), (Object)"\u00a0"), new Pair((Object)Pattern.compile("[\\n\\r\\t]"), (Object)""));

    SimpleHtmlHandler() {
    }

    @Override
    public List<Node> buildFlow(String text) {
        if (TextUtil.isBlank((String)text)) {
            return Collections.emptyList();
        }
        if (!text.startsWith("<html>") && !text.startsWith("<HTML>")) {
            return Collections.singletonList(new Text(text));
        }
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayDeque<Tag> tags = new ArrayDeque<Tag>();
        int p = 6;
        int len = text.length();
        StringBuilder buf = new StringBuilder();
        while (p < len) {
            Tag tag;
            int i = text.indexOf(60, p);
            if (i == -1 || i == len - 1) {
                buf.append(this.unescapeEntities(text.substring(p)));
                break;
            }
            int i2 = text.indexOf(62, i);
            if (i2 == -1) {
                buf.append(this.unescapeEntities(text.substring(p)));
                break;
            }
            buf.append(this.unescapeEntities(text.substring(p, i)));
            p = i2 + 1;
            String tagName = text.substring(i + 1, i2).trim().toLowerCase();
            if (tagName.startsWith("br")) {
                buf.append('\n');
                continue;
            }
            if (tagName.startsWith("/")) {
                tag = Tag.of(tagName.substring(1));
                if (tag != null) {
                    this.createNode(result, buf, tags);
                    tags.removeLastOccurrence((Object)tag);
                    continue;
                }
                buf.append(this.unescapeEntities(text.substring(i, i2 + 1)));
                continue;
            }
            tag = Tag.of(tagName);
            if (tag != null) {
                this.createNode(result, buf, tags);
                tags.add(tag);
                continue;
            }
            buf.append(this.unescapeEntities(text.substring(i, i2 + 1)));
        }
        this.createNode(result, buf, tags);
        return result;
    }

    private String unescapeEntities(String str) {
        if (str.isEmpty()) {
            return str;
        }
        String result = str;
        for (Pair<Pattern, String> pair : ESCAPE_PATTERNS) {
            result = ((Pattern)pair.getKey()).matcher(result).replaceAll((String)pair.getValue());
        }
        return result;
    }

    private void createNode(List<Node> result, StringBuilder buf, Deque<Tag> tags) {
        if (buf.length() == 0) {
            return;
        }
        Text node = new Text(buf.toString());
        buf.setLength(0);
        if (tags.contains((Object)Tag.STRIKETHROUGH)) {
            node.getStyleClass().add((Object)"strike");
        }
        if (tags.contains((Object)Tag.UNDERLINE)) {
            node.getStyleClass().add((Object)"underline");
        }
        if (tags.contains((Object)Tag.STRONG)) {
            node.getStyleClass().add((Object)"strong");
        }
        if (tags.contains((Object)Tag.ITALIC)) {
            node.getStyleClass().add((Object)"italic");
        }
        if (tags.contains((Object)Tag.MONOSPACE)) {
            node.getStyleClass().add((Object)"code");
        }
        result.add((Node)node);
    }

    private static enum Tag {
        STRONG,
        ITALIC,
        UNDERLINE,
        STRIKETHROUGH,
        MONOSPACE;


        static Tag of(String str) {
            if (TextUtil.isBlank((String)str)) {
                return null;
            }
            switch (str.trim().toLowerCase()) {
                case "b": 
                case "strong": {
                    return STRONG;
                }
                case "i": 
                case "em": {
                    return ITALIC;
                }
                case "u": {
                    return UNDERLINE;
                }
                case "s": 
                case "strike": 
                case "del": {
                    return STRIKETHROUGH;
                }
                case "code": {
                    return MONOSPACE;
                }
            }
            return null;
        }
    }
}

