/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.tree;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreePane;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;

public abstract class CustomCheckBoxTreeCell<V>
extends CheckBoxTreeCell<V> {
    private CustomCheckBoxTreePane pane;
    private BooleanProperty selectedProperty;

    public void updateItem(V value, boolean empty) {
        super.updateItem(value, empty);
        this.setDisclosureNode(null);
        CheckBoxTreeItem item = (CheckBoxTreeItem)this.getTreeItem();
        if (!empty) {
            if (this.pane == null) {
                this.pane = new CustomCheckBoxTreePane();
            }
            this.pane.getRulerButtonIcon().setOnMousePressed(event -> {
                TreeItem treeItem = this.getTreeItem();
                if (treeItem == null) {
                    return;
                }
                treeItem.setExpanded(!treeItem.isExpanded());
            });
            if (this.selectedProperty != null) {
                this.pane.getSelectedCheckBox().selectedProperty().unbindBidirectional((Property)this.selectedProperty);
            }
            if (item != null) {
                this.selectedProperty = item.selectedProperty();
                this.pane.getSelectedCheckBox().selectedProperty().bindBidirectional((Property)this.selectedProperty);
            }
            this.pane.getTitleLabel().setText(value != null ? this.getTitle(value) : null);
            UiUtil.setHidden((Node)this.pane.getRulerButtonIcon(), item == null || item.isLeaf());
            this.setGraphic((Node)this.pane);
        } else {
            this.setGraphic(null);
        }
        this.setText(null);
    }

    protected abstract String getTitle(V var1);
}

