/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.tree;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeCell;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableCheckBoxTreeItem;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public abstract class CustomCheckBoxTreeView<V> {
    private TreeView<V> treeView;
    private final ObservableList<String> selectedItemsIds = FXCollections.observableArrayList();
    private SortableCheckBoxTreeItem<V> rootItem;
    private GridPane treePane;

    public CustomCheckBoxTreeView(V root) {
        this(root, true, Collections.emptyList());
    }

    public CustomCheckBoxTreeView(V root, boolean showRoot, List<String> selectedIds) {
        this.selectedItemsIds.clear();
        this.selectedItemsIds.addAll(selectedIds);
        this.treeView = new TreeView();
        this.treeView.getStyleClass().add((Object)"xtrip-tree-view");
        this.treeView.setShowRoot(showRoot);
        this.treeView.setCellFactory(new Callback<TreeView<V>, TreeCell<V>>(){

            public TreeCell<V> call(TreeView<V> param) {
                return new CustomCheckBoxTreeCell<V>(){

                    @Override
                    protected String getTitle(V v) {
                        return CustomCheckBoxTreeView.this.getNodeTitle(v);
                    }
                };
            }
        });
        this.treePane = new GridPane();
        UiUtil.gridPosition(this.treePane, this.treeView).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        this.rootItem = new SortableCheckBoxTreeItem();
        this.rootItem.setValue(root);
        this.rootItem.setSelected(this.selectedItemsIds.contains((Object)this.getNodeId(root)));
        this.rootItem.setComparator(this.getComparator());
        this.treeView.setRoot(this.rootItem);
        UiUtil.expand(this.treeView);
        this.populate(this.rootItem, this.getNodeChildren(root));
    }

    private void populate(SortableCheckBoxTreeItem<V> parent, Collection<V> children) {
        for (V child : children) {
            if (child == null) continue;
            SortableCheckBoxTreeItem item = new SortableCheckBoxTreeItem();
            item.setValue(child);
            item.setSelected(this.selectedItemsIds.contains((Object)this.getNodeId(child)));
            item.selectedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.selectedItemsIds.add((Object)this.getNodeId(item.getValue()));
                } else {
                    this.selectedItemsIds.remove((Object)this.getNodeId(item.getValue()));
                }
            });
            parent.add(item);
            this.populate(item, this.getNodeChildren(child));
        }
    }

    public void addNewElementsToParent(SortableCheckBoxTreeItem<V> parent, Collection<V> children) {
        this.populate(parent, children);
    }

    public void setNodesSelection(List<String> selectedIds) {
        this.rootItem.setSelected(selectedIds.contains(this.getNodeId(this.rootItem.getValue())));
        this.setNodesSelection(this.rootItem.getChildren(), selectedIds);
    }

    private void setNodesSelection(ObservableList<TreeItem<V>> items, List<String> selectedIds) {
        for (TreeItem item : items) {
            if (item instanceof SortableCheckBoxTreeItem) {
                ((SortableCheckBoxTreeItem)item).setSelected(selectedIds.contains(this.getNodeId(item.getValue())));
            }
            this.setNodesSelection(item.getChildren(), selectedIds);
        }
    }

    public void setRootSelected(boolean selection) {
        this.rootItem.setSelected(selection);
    }

    public List<String> getSelectedItemsIds() {
        return this.selectedItemsIds;
    }

    public TreeView<V> getTreeView() {
        return this.treeView;
    }

    public GridPane getTreePane() {
        return this.treePane;
    }

    public void setReadonly(boolean readonly) {
        this.treeView.setDisable(readonly);
        if (readonly) {
            this.treeView.setStyle("-fx-opacity: 1");
        }
    }

    public void setNotEditable(boolean notEditable) {
        this.treeView.setDisable(notEditable);
    }

    public void setAclNotEditable(boolean aclNotEditable) {
        this.treeView.setDisable(aclNotEditable);
    }

    protected Comparator<TreeItem<V>> getComparator() {
        return MiscUtil.comparator(item -> item.getValue(), (Comparator)new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (CustomCheckBoxTreeView.this.getNodeId(o1) == null) {
                    return CustomCheckBoxTreeView.this.getNodeId(o2) == null ? 0 : -1;
                }
                if (CustomCheckBoxTreeView.this.getNodeId(o2) == null) {
                    return CustomCheckBoxTreeView.this.getNodeId(o1) == null ? 0 : 1;
                }
                return MiscUtil.compare((Comparable)((Object)CustomCheckBoxTreeView.this.getNodeTitle(o1)), (Comparable)((Object)CustomCheckBoxTreeView.this.getNodeTitle(o2)));
            }
        });
    }

    protected abstract List<V> getNodeChildren(V var1);

    protected abstract String getNodeTitle(V var1);

    protected abstract String getNodeId(V var1);
}

