/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.tree;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomTreeView;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.util.Duration;

public class CustomDndTreeView<T extends Serializable>
extends CustomTreeView<T> {
    private static final PseudoClass DND_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"dnd");
    private static final PseudoClass DND_ABOVE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"dndabove");
    private static final PseudoClass DND_BELOW_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"dndbelow");
    static final PseudoClass DND_AFTER_SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"dndafterselected");
    static final PseudoClass DND_BEFORE_SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"dndbeforeselected");
    private static final DataFormat SERIALIZED_MIME_TYPE = new DataFormat(new String[]{"application/x-java-serialized-object"});
    private DropPolicy dropPolicy;
    private TransferMode[] transferModes;
    private Function<TreeItem<T>, String> renderer;
    private DragLeafChecker<T> dragLeafChecker;
    private DragDetectChecker<T> dragDetectChecker;
    private DragOverChecker<T> dragOverChecker;
    private DragDropHandler<T> dragDropHandler;
    private DragDoneHandler<T> dragDoneHandler;
    private final Timeline scrollTimeline = new Timeline();
    private final Timeline expandTimeline = new Timeline();
    private double offset = 0.0;
    private TreeItem<T> draggedTreeItem;
    private TreeItem<T> overTreeItem;
    private DropType dropType;
    private DropLocation dropLocation;

    public CustomDndTreeView() {
        this.scrollTimeline.setCycleCount(-1);
        this.scrollTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)50.0), "scroll", event -> {
            for (Node node : this.lookupAll(".scroll-bar")) {
                ScrollBar scrollBar;
                if (!(node instanceof ScrollBar) || !(scrollBar = (ScrollBar)node).getOrientation().equals((Object)Orientation.VERTICAL)) continue;
                double value = scrollBar.getValue() + this.offset;
                value = Math.min(value, 1.0);
                value = Math.max(value, 0.0);
                scrollBar.setValue(value);
                break;
            }
        }, new KeyValue[0]));
        this.setOnDragExited(event -> {
            this.offset = event.getY() > 0.0 ? 1.0 / (double)this.getExpandedItemCount() : -1.0 / (double)this.getExpandedItemCount();
            this.scrollTimeline.play();
        });
        this.setOnDragEntered(event -> this.scrollTimeline.stop());
        this.setOnDragDone(event -> this.scrollTimeline.stop());
        this.setCellFactory(treeView -> {
            TreeCell cell = (TreeCell)this.callback.call(treeView);
            cell.setOnDragDetected(event -> {
                TreeItem treeItem;
                if (this.dropPolicy != null && this.transferModes != null && this.transferModes.length > 0 && (treeItem = cell.getTreeItem()) != null && treeItem.getValue() != null && treeItem == this.getSelectionModel().getSelectedItem()) {
                    TransferMode[] allowedTransferModes = null;
                    if (this.dragDetectChecker != null) {
                        List<TransferMode> modes = Stream.of(this.transferModes).filter(item -> this.dragDetectChecker.check((TreeItem<T>)treeItem, (TransferMode)item)).collect(Collectors.toList());
                        allowedTransferModes = modes.toArray(new TransferMode[modes.size()]);
                    } else {
                        allowedTransferModes = this.transferModes;
                    }
                    if (allowedTransferModes.length > 0) {
                        this.draggedTreeItem = treeItem;
                        Dragboard dragboard = this.startDragAndDrop(allowedTransferModes);
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)SERIALIZED_MIME_TYPE, treeItem.getValue());
                        dragboard.setContent((Map)content);
                        if (this.renderer != null) {
                            Label label = new Label("    " + this.renderer.apply(treeItem));
                            new Scene((Parent)label);
                            dragboard.setDragView((Image)label.snapshot(null, null));
                        }
                    }
                }
                event.consume();
            });
            cell.setOnDragOver(event -> {
                Serializable value;
                TreeItem treeItem;
                if (this.dropPolicy != null && this.transferModes != null && this.transferModes.length > 0 && (treeItem = cell.getTreeItem()) != null && treeItem.getValue() != null && (value = (Serializable)event.getDragboard().getContent(SERIALIZED_MIME_TYPE)) != null) {
                    boolean leaf = treeItem.isLeaf();
                    if (this.dragLeafChecker != null) {
                        leaf = this.dragLeafChecker.check(treeItem, event.getTransferMode());
                    }
                    if (this.dropPolicy == DropPolicy.RESTRICTED || this.dropPolicy == DropPolicy.CLASSIC) {
                        double height = cell.getHeight();
                        double cellSceneY = cell.localToScene(0.0, 0.0).getY();
                        double y = event.getSceneY() - cellSceneY;
                        if (leaf && this.dropPolicy == DropPolicy.RESTRICTED) {
                            if (y < height / 2.0) {
                                this.dropType = DropType.SIBLING;
                                this.dropLocation = DropLocation.ABOVE;
                            } else {
                                this.dropType = DropType.SIBLING;
                                this.dropLocation = DropLocation.BELOW;
                            }
                        } else if (y < height / 3.0) {
                            this.dropType = DropType.SIBLING;
                            this.dropLocation = DropLocation.ABOVE;
                        } else if (y > height - height / 3.0) {
                            this.dropType = treeItem.isExpanded() && treeItem.getChildren().size() > 0 ? DropType.CHILD : DropType.SIBLING;
                            this.dropLocation = treeItem.isExpanded() && treeItem.getChildren().size() > 0 ? DropLocation.OVER : DropLocation.BELOW;
                        } else {
                            this.dropType = DropType.CHILD;
                            this.dropLocation = DropLocation.OVER;
                        }
                    } else if (this.dropPolicy == DropPolicy.GROUP) {
                        if (leaf) {
                            this.dropType = DropType.SIBLING;
                            this.dropLocation = DropLocation.OVER;
                        } else {
                            this.dropType = DropType.CHILD;
                            this.dropLocation = DropLocation.OVER;
                        }
                    }
                    boolean accepted = this.isAccepted(this.draggedTreeItem, treeItem, value, event.getTransferMode(), this.dropType, this.dropLocation);
                    if (accepted) {
                        if (this.dropPolicy == DropPolicy.RESTRICTED || this.dropPolicy == DropPolicy.CLASSIC) {
                            cell.pseudoClassStateChanged(DND_ABOVE_PSEUDOCLASS_STATE, this.dropLocation == DropLocation.ABOVE);
                            cell.pseudoClassStateChanged(DND_BELOW_PSEUDOCLASS_STATE, this.dropLocation == DropLocation.BELOW);
                            cell.pseudoClassStateChanged(DND_PSEUDOCLASS_STATE, this.dropLocation == DropLocation.OVER);
                            this.overTreeItem = this.dropLocation == DropLocation.OVER ? treeItem : null;
                        } else if (this.dropPolicy == DropPolicy.GROUP) {
                            cell.pseudoClassStateChanged(DND_PSEUDOCLASS_STATE, true);
                            this.overTreeItem = treeItem;
                        }
                        int row = this.getRow(treeItem);
                        TreeItem previousTreeItem = this.getTreeItem(row - 1);
                        TreeItem nextTreeItem = this.getTreeItem(row + 1);
                        cell.pseudoClassStateChanged(DND_AFTER_SELECTED_PSEUDOCLASS_STATE, previousTreeItem != null && this.getSelectionModel().getSelectedItem() == previousTreeItem);
                        cell.pseudoClassStateChanged(DND_BEFORE_SELECTED_PSEUDOCLASS_STATE, nextTreeItem != null && this.getSelectionModel().getSelectedItem() == nextTreeItem);
                        this.update();
                        event.acceptTransferModes(this.transferModes);
                    }
                }
                event.consume();
            });
            cell.setOnDragEntered(event -> {
                TreeItem treeItem = cell.getTreeItem();
                if (treeItem != null && !treeItem.isLeaf() && treeItem != this.draggedTreeItem) {
                    this.expandTimeline.setCycleCount(1);
                    this.expandTimeline.getKeyFrames().clear();
                    this.expandTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)1000.0), "expand", e -> treeItem.setExpanded(true), new KeyValue[0]));
                    this.expandTimeline.play();
                }
            });
            cell.setOnDragExited(event -> {
                TreeItem treeItem = cell.getTreeItem();
                cell.pseudoClassStateChanged(DND_PSEUDOCLASS_STATE, false);
                cell.pseudoClassStateChanged(DND_ABOVE_PSEUDOCLASS_STATE, false);
                cell.pseudoClassStateChanged(DND_BELOW_PSEUDOCLASS_STATE, false);
                cell.pseudoClassStateChanged(DND_AFTER_SELECTED_PSEUDOCLASS_STATE, false);
                cell.pseudoClassStateChanged(DND_BEFORE_SELECTED_PSEUDOCLASS_STATE, false);
                if (treeItem != null && treeItem == this.overTreeItem) {
                    this.overTreeItem = null;
                    this.update();
                }
                this.expandTimeline.stop();
            });
            cell.setOnDragDropped(event -> {
                Serializable value;
                TreeItem treeItem;
                boolean completed = false;
                if (this.dropPolicy != null && this.transferModes != null && this.transferModes.length > 0 && (treeItem = cell.getTreeItem()) != null && treeItem.getValue() != null && (value = (Serializable)event.getDragboard().getContent(SERIALIZED_MIME_TYPE)) != null && this.dragDropHandler != null) {
                    this.dragDropHandler.handle(this.draggedTreeItem, treeItem, value, event.getTransferMode(), this.dropType, this.dropLocation);
                    completed = true;
                }
                event.setDropCompleted(completed);
                event.consume();
            });
            cell.setOnDragDone(event -> {
                TreeItem treeItem;
                if (this.dropPolicy != null && this.transferModes != null && this.transferModes.length > 0 && (treeItem = cell.getTreeItem()) != null && treeItem.getValue() != null && this.dragDoneHandler != null) {
                    this.dragDoneHandler.handle(treeItem, event.getTransferMode());
                }
                event.consume();
            });
            return cell;
        });
    }

    private boolean isAccepted(TreeItem<T> source, TreeItem<T> target, T value, TransferMode mode, DropType type, DropLocation location) {
        if (source != null && source.getParent() == null) {
            return false;
        }
        if (target != null && target.getParent() == null && type != DropType.CHILD) {
            return false;
        }
        if (source != null && target != null && mode == TransferMode.MOVE) {
            for (TreeItem parent = target; parent != null; parent = parent.getParent()) {
                if (parent != source) continue;
                return false;
            }
        }
        return this.dragOverChecker != null ? this.dragOverChecker.check(source, target, value, mode, type, location) : true;
    }

    private void update() {
        for (Node node : this.lookupAll(".tree-cell")) {
            if (!(node instanceof TreeCell)) continue;
            TreeCell cell = (TreeCell)node;
            TreeItem treeItem = cell.getTreeItem();
            if (this.dropPolicy == DropPolicy.RESTRICTED) {
                cell.pseudoClassStateChanged(DND_PSEUDOCLASS_STATE, treeItem != null && this.overTreeItem != null && (treeItem == this.overTreeItem || treeItem.getParent() != null && treeItem.getParent() == this.overTreeItem));
                continue;
            }
            if (this.dropPolicy != DropPolicy.GROUP) continue;
            cell.pseudoClassStateChanged(DND_PSEUDOCLASS_STATE, treeItem != null && this.overTreeItem != null && (treeItem == this.overTreeItem || !this.overTreeItem.isLeaf() && treeItem.getParent() != null && treeItem.getParent() == this.overTreeItem || this.overTreeItem.isLeaf() && (treeItem.getChildren().contains(this.overTreeItem) || treeItem.getParent() != null && treeItem.getParent().getChildren().contains(this.overTreeItem))));
        }
    }

    public void setDropPolicy(DropPolicy dropPolicy) {
        this.dropPolicy = dropPolicy;
    }

    public void setTransferModes(TransferMode ... transferModes) {
        this.transferModes = transferModes;
    }

    public void setRenderer(Function<TreeItem<T>, String> renderer) {
        this.renderer = renderer;
    }

    public void setDragLeafChecker(DragLeafChecker<T> dragLeafChecker) {
        this.dragLeafChecker = dragLeafChecker;
    }

    public void setDragDetectChecker(DragDetectChecker<T> dragDetectChecker) {
        this.dragDetectChecker = dragDetectChecker;
    }

    public void setDragOverChecker(DragOverChecker<T> dragOverChecker) {
        this.dragOverChecker = dragOverChecker;
    }

    public void setDragDropHandler(DragDropHandler<T> dragDropHandler) {
        this.dragDropHandler = dragDropHandler;
    }

    public void setDragDoneHandler(DragDoneHandler<T> dragDoneHandler) {
        this.dragDoneHandler = dragDoneHandler;
    }

    public static enum DropLocation {
        ABOVE,
        BELOW,
        OVER;

    }

    public static enum DropType {
        SIBLING,
        CHILD;

    }

    public static enum DropPolicy {
        CLASSIC,
        RESTRICTED,
        GROUP;

    }

    public static interface DragDoneHandler<T> {
        public void handle(TreeItem<T> var1, TransferMode var2);
    }

    public static interface DragDropHandler<T> {
        public void handle(TreeItem<T> var1, TreeItem<T> var2, T var3, TransferMode var4, DropType var5, DropLocation var6);
    }

    public static interface DragOverChecker<T> {
        public boolean check(TreeItem<T> var1, TreeItem<T> var2, T var3, TransferMode var4, DropType var5, DropLocation var6);
    }

    public static interface DragDetectChecker<T> {
        public boolean check(TreeItem<T> var1, TransferMode var2);
    }

    public static interface DragLeafChecker<T> {
        public boolean check(TreeItem<T> var1, TransferMode var2);
    }
}

