/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.cards;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;

public class Card<C extends Node>
implements DevTool {
    private final boolean collapsible;
    private final SimpleStringProperty caption;
    private final SimpleObjectProperty<Supplier<QuickHelp>> help = new SimpleObjectProperty();
    private C content;
    private final ReadOnlyBooleanWrapper collapsed = new ReadOnlyBooleanWrapper();
    private boolean hidden;
    private boolean adaptiveHeight;
    private CardsContainer container;
    private final ObservableList<CardAction<C>> actions = FXCollections.observableArrayList();
    private CardPane pane;
    private final String id;

    public Card(String cardId, UiCardsContainer.Style style, String captionText, C contentNode) {
        this.id = cardId;
        switch (style) {
            case STATIC: {
                this.collapsible = false;
                break;
            }
            case EXPANDED: {
                this.collapsible = true;
                break;
            }
            case COLLAPSED: {
                this.collapsible = true;
                this.collapsed.set(true);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unsupported style constant {0}", (Object[])new Object[]{style.name()});
            }
        }
        this.caption = new SimpleStringProperty(captionText);
        this.content = (Node)Objects.requireNonNull(contentNode);
        this.actions.addListener(src -> {
            if (this.pane != null) {
                this.pane.rebuildActionsPane();
            }
            if (this.container != null && !this.hidden) {
                this.container.rebuild();
            }
        });
    }

    public String getId() {
        return this.id;
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public StringProperty captionProperty() {
        return this.caption;
    }

    public String getCaption() {
        return this.caption.get();
    }

    public void setCaption(String value) {
        this.caption.set(value);
    }

    SimpleObjectProperty<Supplier<QuickHelp>> helpProperty() {
        return this.help;
    }

    public void setHelp(Supplier<QuickHelp> value) {
        this.help.set(value);
    }

    public C getContent() {
        return this.content;
    }

    public void setContent(C value) {
        this.content = (Node)Objects.requireNonNull(value);
        if (this.container != null && !this.hidden) {
            this.container.rebuild();
        }
    }

    public ReadOnlyBooleanProperty collapsedProperty() {
        return this.collapsed.getReadOnlyProperty();
    }

    public boolean isCollapsed() {
        return this.collapsed.get();
    }

    public void setCollapsed(boolean value) {
        if (value && !this.collapsible) {
            return;
        }
        this.collapsed.set(value);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean value) {
        if (this.hidden == value) {
            return;
        }
        this.hidden = value;
        if (this.container != null) {
            this.container.rebuild();
        }
    }

    public boolean isAdaptiveHeight() {
        return this.adaptiveHeight;
    }

    public void setAdaptiveHeight(boolean value) {
        if (this.adaptiveHeight == value) {
            return;
        }
        this.adaptiveHeight = value;
        if (this.container != null && !this.hidden) {
            this.container.rebuild();
        }
    }

    public ObservableList<CardAction<C>> getActions() {
        return this.actions;
    }

    public void revalidateActions() {
        if (this.pane != null) {
            this.pane.revalidateActions();
        }
    }

    CardsContainer getContainer() {
        return this.container;
    }

    void setContainer(CardsContainer value) {
        this.container = value;
    }

    CardPane getPane() {
        if (this.pane == null) {
            this.pane = new CardPane(this);
            Styles.manageStyle((Styleable)this.pane, "adopts-widget", this.content.getStyleClass().contains((Object)"simple-widget"));
        }
        return this.pane;
    }

    public void addTitleStyle(String style) {
        Styles.addStyle((Styleable)this.getPane(), style);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<1> result = new ArrayList<1>();
                for (final CardAction action : Card.this.getActions()) {
                    result.add(new DevTool(){

                        @Override
                        public DevToolItem asDevToolItem() {
                            return new DevToolItem(){

                                @Override
                                public Collection<?> getSubItems() {
                                    return Collections.emptyList();
                                }

                                @Override
                                public String getInfo() {
                                    return "A " + MiscUtil.getSimpleClassName(action.getClass()) + " [" + action.getName(Card.this) + ']';
                                }
                            };
                        }
                    });
                }
                result.add(Card.this.getContent());
                return result;
            }

            @Override
            public String getInfo() {
                String result = Card.this.getClass().getSimpleName() + " [" + Card.this.getId() + "] [" + Card.this.getCaption() + ']';
                if (Card.this.isHidden()) {
                    result = result + " [hidden]";
                }
                if (Card.this.getContainer() != null && Card.this.getContainer().getForbiddenCards().contains((Object)Card.this)) {
                    result = result + " [forbidden]";
                }
                return result;
            }
        };
    }
}

