/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.cells;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.BaseCell;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Pos;

public class SimpleCell
extends BaseCell
implements DevTool {
    private final SimpleStringProperty value = new SimpleStringProperty();
    private final SimpleObjectProperty<Supplier<QuickHelp>> help = new SimpleObjectProperty();
    private Style style;
    private final SimpleObjectProperty<Pos> alignment = new SimpleObjectProperty();

    public SimpleCell() {
        this(null, Style.VALUE, Pos.CENTER_LEFT);
    }

    public SimpleCell(String val) {
        this(val, Style.VALUE, Pos.CENTER_LEFT);
    }

    public SimpleCell(String val, Style st) {
        this(val, st, Pos.CENTER_LEFT);
    }

    public SimpleCell(String val, Style st, Pos al) {
        this.value.set(val);
        this.style = Objects.requireNonNull(st);
        this.alignment.set((Object)Objects.requireNonNull(al));
    }

    public StringProperty valueProperty() {
        return this.value;
    }

    public String getValue() {
        return this.value.get();
    }

    public void setValue(String val) {
        this.value.set(val);
    }

    SimpleObjectProperty<Supplier<QuickHelp>> helpProperty() {
        return this.help;
    }

    public void setHelp(Supplier<QuickHelp> val) {
        this.help.set(val);
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style val) {
        if (this.style == val) {
            return;
        }
        this.style = Objects.requireNonNull(val);
        if (this.container != null && !this.isHidden()) {
            this.container.reflow();
        }
    }

    ObjectProperty<Pos> alignmentProperty() {
        return this.alignment;
    }

    public Pos getAlignment() {
        return (Pos)this.alignment.get();
    }

    public void setAlignment(Pos val) {
        this.alignment.set((Object)Objects.requireNonNull(val));
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                String result = SimpleCell.this.getClass().getSimpleName() + " [" + SimpleCell.this.getValue() + ']';
                if (SimpleCell.this.isHidden()) {
                    result = result + " [hidden]";
                }
                if (SimpleCell.this.container != null && SimpleCell.this.container.getForbiddenCells().contains((Object)SimpleCell.this)) {
                    result = result + " [forbidden]";
                }
                return result;
            }
        };
    }

    public static enum Style {
        BASIC{

            @Override
            String getCssClass() {
                return "basic";
            }
        }
        ,
        CAPTION{

            @Override
            String getCssClass() {
                return "caption";
            }
        }
        ,
        VALUE{

            @Override
            String getCssClass() {
                return "value";
            }
        }
        ,
        COMBINED{

            @Override
            String getCssClass() {
                return "combined";
            }
        };


        abstract String getCssClass();
    }
}

