/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.tiles;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilePane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;

public class Tile<C extends Node, F extends Node>
implements DevTool {
    private final String id;
    private final SimpleStringProperty caption;
    private final SimpleObjectProperty<Supplier<QuickHelp>> help = new SimpleObjectProperty();
    private final C compactNode;
    private final F fullNode;
    private final ReadOnlyBooleanWrapper expanded = new ReadOnlyBooleanWrapper();
    private final ObservableList<TileAction<C, F>> actions = FXCollections.observableArrayList();
    private TilesSpace space;
    private TilePane<C, F> collapsedPane;
    private TilePane<C, F> expandedPane;
    private Consumer<Map<String, EventHandler<ActionEvent>>> adminToolsBuilder;

    public Tile(String tileId, String captionText, C compact, F full) {
        this.id = tileId;
        this.caption = new SimpleStringProperty(captionText);
        this.compactNode = compact;
        this.fullNode = full;
    }

    public TilesSpace getSpace() {
        return this.space;
    }

    void setSpace(TilesSpace value) {
        this.space = value;
    }

    public String getId() {
        return this.id;
    }

    public StringProperty captionProperty() {
        return this.caption;
    }

    public String getCaption() {
        return this.caption.get();
    }

    public void setCaption(String value) {
        this.caption.set(value);
    }

    SimpleObjectProperty<Supplier<QuickHelp>> helpProperty() {
        return this.help;
    }

    public void setHelp(Supplier<QuickHelp> value) {
        this.help.set(value);
    }

    public C getCompactNode() {
        return this.compactNode;
    }

    public F getFullNode() {
        return this.fullNode;
    }

    public ReadOnlyBooleanProperty expandedProperty() {
        return this.expanded.getReadOnlyProperty();
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    void setExpanded(boolean value) {
        this.expanded.set(value);
    }

    public ObservableList<TileAction<C, F>> getActions() {
        return this.actions;
    }

    public void revalidateActions() {
        if (this.expanded.get()) {
            if (this.expandedPane != null) {
                this.expandedPane.revalidateActions();
            }
        } else if (this.collapsedPane != null) {
            this.collapsedPane.revalidateActions();
        }
    }

    public void setAdminToolsBuilder(Consumer<Map<String, EventHandler<ActionEvent>>> value) {
        this.adminToolsBuilder = value;
    }

    Consumer<Map<String, EventHandler<ActionEvent>>> getAdminToolsBuilder() {
        return this.adminToolsBuilder;
    }

    TilePane<C, F> getExpandedPane() {
        return this.expandedPane;
    }

    void setExpandedPane(TilePane<C, F> value) {
        this.expandedPane = value;
    }

    TilePane<C, F> getCollapsedPane() {
        return this.collapsedPane;
    }

    void setCollapsedPane(TilePane<C, F> value) {
        this.collapsedPane = value;
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<1> result = new ArrayList<1>();
                for (final TileAction action : Tile.this.getActions()) {
                    result.add(new DevTool(){

                        @Override
                        public DevToolItem asDevToolItem() {
                            return new DevToolItem(){

                                @Override
                                public Collection<?> getSubItems() {
                                    return Collections.emptyList();
                                }

                                @Override
                                public String getInfo() {
                                    return "A " + MiscUtil.getSimpleClassName(action.getClass()) + " [" + action.getName(Tile.this) + ']';
                                }
                            };
                        }
                    });
                }
                if (Tile.this.getCompactNode() != null) {
                    result.add(Tile.this.getCompactNode());
                }
                if (Tile.this.getFullNode() != null) {
                    result.add(Tile.this.getFullNode());
                }
                return result;
            }

            @Override
            public String getInfo() {
                String result = Tile.this.getClass().getSimpleName() + " [" + Tile.this.getId() + "] [" + Tile.this.getCaption() + ']';
                if (Tile.this.getSpace() != null) {
                    if (Tile.this.getSpace().settings.isOffScreen(Tile.this.getId())) {
                        result = result + " [offscreen]";
                    }
                    if (Tile.this.getSpace().getHiddenTiles().contains((Object)Tile.this)) {
                        result = result + " [hidden]";
                    }
                    if (Tile.this.getSpace().getForbiddenTiles().contains((Object)Tile.this)) {
                        result = result + " [forbidden]";
                    }
                }
                return result;
            }
        };
    }
}

