/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

abstract class BaseNumberWidget<N extends Number>
extends StackPane
implements HasViewState,
HasValue<N> {
    private final SimpleObjectProperty<N> value = new SimpleObjectProperty();
    final StringConverter<N> converter;
    private Label readonlyLabel;
    private ClearableTextField textField;
    private String proptText;
    N defaultValue;
    private final ViewState viewState = new ViewState();
    private boolean ignoreValueChange;
    private boolean touched;
    private Predicate<N> valueValidator;

    protected BaseNumberWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"number-value-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.converter = this.createConverter();
        this.value.addListener(evt -> {
            if (this.ignoreValueChange) {
                return;
            }
            this.renderValue();
            this.touched = false;
        });
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.textField != null) {
            this.textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    protected abstract StringConverter<N> createConverter();

    public void setDefaultValue(N val) {
        this.defaultValue = val;
        if (this.value.get() == null && this.defaultValue != null) {
            this.value.set(val);
        }
    }

    public void setValueValidator(Predicate<N> val) {
        this.valueValidator = val;
    }

    @Override
    public ObjectProperty<N> valueProperty() {
        return this.value;
    }

    public N getValue() {
        return (N)((Number)this.value.get());
    }

    public void setValue(N val) {
        this.value.set(val);
    }

    public String getTextValue() {
        Number val = (Number)this.value.get();
        return val == null ? null : this.converter.toString((Object)val);
    }

    public void setPromptText(String val) {
        this.proptText = val;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    protected void clearWidget() {
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.textField = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.textField == null) {
                this.textField = new ClearableTextField(){

                    @Override
                    protected boolean isEmpty() {
                        return super.isEmpty() || MiscUtil.equals(BaseNumberWidget.this.getValue(), BaseNumberWidget.this.defaultValue);
                    }

                    public void clear() {
                        this.deselect();
                        BaseNumberWidget.this.valueProperty().set(BaseNumberWidget.this.defaultValue);
                        this.setText(BaseNumberWidget.this.defaultValue == null ? null : BaseNumberWidget.this.converter.toString(BaseNumberWidget.this.defaultValue));
                        BaseNumberWidget.this.clearWidget();
                    }
                };
                this.textField.focusedProperty().addListener((s, o, n) -> {
                    if (!this.touched) {
                        return;
                    }
                    try {
                        this.ignoreValueChange = true;
                        Number val = (Number)this.converter.fromString(this.textField.getText());
                        if (val == null) {
                            this.value.set(this.defaultValue);
                            if (this.textField != null) {
                                this.textField.setText(this.defaultValue == null ? null : this.converter.toString(this.defaultValue));
                            }
                        } else if (this.valueValidator != null && !this.valueValidator.test(val)) {
                            UiUtil.blink((Node)this.textField);
                            this.value.set(this.defaultValue);
                            if (this.textField != null) {
                                this.textField.setText(this.defaultValue == null ? null : this.converter.toString(this.defaultValue));
                            }
                        } else {
                            this.value.set((Object)val);
                            if (this.textField != null) {
                                this.textField.setText(this.converter.toString((Object)val));
                            }
                        }
                    }
                    catch (Exception e) {
                        UiUtil.blink((Node)this.textField);
                        this.value.set(this.defaultValue);
                        if (this.textField != null) {
                            this.textField.setText(this.defaultValue == null ? null : this.converter.toString(this.defaultValue));
                        }
                    }
                    finally {
                        this.ignoreValueChange = false;
                    }
                });
                this.textField.textProperty().addListener((s, o, n) -> {
                    if (this.ignoreValueChange) {
                        return;
                    }
                    try {
                        this.ignoreValueChange = true;
                        this.touched = true;
                        Number val = (Number)this.converter.fromString(n);
                        if (val == null) {
                            this.value.set(this.defaultValue);
                        } else {
                            this.value.set((Object)val);
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.ignoreValueChange = false;
                    }
                });
                this.getChildren().setAll((Object[])new Node[]{this.textField});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        Number val = (Number)this.value.get();
        String promptText = this.proptText == null ? (this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT) : this.proptText;
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(val == null ? promptText : this.converter.toString((Object)val));
        } else {
            this.ignoreValueChange = true;
            try {
                this.textField.setText(this.converter.toString((Object)val));
                this.textField.setPromptText(promptText);
            }
            finally {
                this.ignoreValueChange = false;
            }
        }
    }

    public boolean hasSameValue(N val) {
        Number current = (Number)this.value.get();
        if (current == null && val == null) {
            return true;
        }
        if (current == null || val == null) {
            return false;
        }
        return this.converter.toString((Object)current).equalsIgnoreCase(this.converter.toString(val));
    }
}

