/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.widgets.BaseNumberWidget;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javafx.util.StringConverter;

public class DoubleValueWidget
extends BaseNumberWidget<Double> {
    static Number parseAsNumber(DecimalFormat nf, String str) {
        ParsePosition pos = new ParsePosition(0);
        Object obj = nf.parseObject(str, pos);
        if (obj != null && pos.getIndex() == str.length()) {
            return (Number)obj;
        }
        String str2 = str.replace('.', ',');
        if (!str2.equals(str) && (obj = nf.parseObject(str2, pos = new ParsePosition(0))) != null && pos.getIndex() == str2.length()) {
            return (Number)obj;
        }
        if (!(str2 = str2.replace(',', '.')).equals(str) && (obj = nf.parseObject(str2, pos = new ParsePosition(0))) != null && pos.getIndex() == str2.length()) {
            return (Number)obj;
        }
        throw new RuntimeException("string [" + str + "] not according to the format [" + nf.toPattern() + ']');
    }

    public DoubleValueWidget(boolean readonly) {
        super(readonly);
    }

    @Override
    protected StringConverter<Double> createConverter() {
        return new StringConverter<Double>(){
            private final DecimalFormat nf;
            {
                LocaleManager lm = LocaleManager.get();
                this.nf = lm.getLocaleData(lm.getCurrentLocale()).getNumberFormat();
            }

            public String toString(Double object) {
                return object == null ? "" : this.nf.format(object);
            }

            public Double fromString(String string) {
                if (string == null) {
                    return null;
                }
                String str = string.trim();
                if (str.isEmpty()) {
                    return null;
                }
                Number obj = DoubleValueWidget.parseAsNumber(this.nf, str);
                if (obj instanceof Double) {
                    return (Double)obj;
                }
                return obj.doubleValue();
            }
        };
    }
}

