/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldSkin;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWithHiddenMaskSwitcherSkin;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;

public class PasswordFieldWidget
extends StackPane
implements HasViewState,
HasValue<String> {
    private final SimpleObjectProperty<String> value = new SimpleObjectProperty();
    private Label readonlyLabel;
    private PasswordField passwordField;
    private boolean hideMaskSwitcher;
    private String promptText = UiUtil.NULL_TEXT;
    private final ViewState viewState = new ViewState();
    final SimpleBooleanProperty showStrengthIndicator = new SimpleBooleanProperty();

    public PasswordFieldWidget(boolean ro) {
        this(ro, false);
    }

    public PasswordFieldWidget(boolean ro, boolean hideMaskSwitcher) {
        this.setHideMaskSwitcher(hideMaskSwitcher);
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"password-field-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener(evt -> this.renderValue());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.passwordField != null) {
            this.passwordField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ObjectProperty<String> valueProperty() {
        return this.value;
    }

    public String getValue() {
        return (String)this.value.get();
    }

    public void setValue(String val) {
        this.value.set((Object)val);
    }

    public void setPromptText(String val) {
        this.promptText = val;
        if (this.passwordField != null) {
            this.passwordField.setPromptText(this.promptText);
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setShowStrengthIndicator(boolean value) {
        this.showStrengthIndicator.set(value);
    }

    public boolean isHideMaskSwitcher() {
        return this.hideMaskSwitcher;
    }

    public void setHideMaskSwitcher(boolean hideMaskSwitcher) {
        this.hideMaskSwitcher = hideMaskSwitcher;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.passwordField = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new Label();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
            this.setDisabled(TextUtil.isBlank((String)this.getValue()));
        } else {
            this.readonlyLabel = null;
            if (this.passwordField == null) {
                this.passwordField = this.isHideMaskSwitcher() ? new PasswordField(){

                    protected Skin<?> createDefaultSkin() {
                        return new PasswordFieldWithHiddenMaskSwitcherSkin(this);
                    }
                } : new PasswordField(){

                    protected Skin<?> createDefaultSkin() {
                        return new PasswordFieldSkin(PasswordFieldWidget.this, this);
                    }
                };
                this.passwordField.setPromptText(this.promptText);
                this.passwordField.textProperty().addListener((s, o, n) -> this.value.set(n));
                this.getChildren().setAll((Object[])new Node[]{this.passwordField});
            }
            this.setDisabled(false);
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        String val = (String)this.value.get();
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(val == null ? UiUtil.NULL_TEXT : "*****");
        } else {
            this.passwordField.setText(val);
        }
    }
}

