/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class TimeValueWidget
extends StackPane
implements HasViewState,
HasValue<LocalTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("ppHH:mm");
    private static final String PROMPT_TEXT = Messages.General_hh_mm;
    private static final String DEFAULT_VALUE = "00:00";
    private static final String ALLOWED_CHARS = "1234567890";
    protected final ObjectProperty<LocalTime> value = new SimpleObjectProperty();
    private Label readonlyLabel;
    protected ClearableTextField textField;
    private final ViewState viewState = new ViewState();
    private String promptText;

    public TimeValueWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
        this.getStyleClass().addAll((Object[])new String[]{"time-value-widget", "simple-widget"});
        this.value.addListener((src, o, n) -> this.renderValue());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.promptText = ViewState.isImmutable(n.intValue()) ? "\u2014" : UiUtil.NULL_TEXT;
            this.updateState();
        });
    }

    public void requestFocus() {
        if (this.textField != null) {
            this.textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ObjectProperty<LocalTime> valueProperty() {
        return this.value;
    }

    public LocalTime getValue() {
        return (LocalTime)this.value.get();
    }

    public void setValue(LocalTime val) {
        this.value.set((Object)val);
    }

    public String getText() {
        LocalTime val = (LocalTime)this.value.get();
        return val == null ? null : val.format(FORMATTER);
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.textField = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.textField == null) {
                this.textField = new ClearableTextField(){

                    public void clear() {
                        this.setText(null);
                        TimeValueWidget.this.value.setValue(null);
                    }
                };
                this.textField.setPromptText(PROMPT_TEXT);
                this.textField.focusedProperty().addListener((src, o, n) -> {
                    String text = this.textField.getText();
                    if (!o.booleanValue()) {
                        if (TextUtil.isBlank((String)text)) {
                            this.textField.setText(DEFAULT_VALUE);
                        }
                    } else if (TextUtil.isBlank((String)text)) {
                        this.textField.clear();
                        this.value.setValue(null);
                    } else {
                        try {
                            int pos = text.indexOf(58);
                            if (pos == -1) {
                                text = MiscUtil.formatTime((Number)Integer.valueOf(text));
                            } else {
                                if (text.length() > 1 && Integer.parseInt(text.substring(0, pos)) > 23) {
                                    text = "23:" + text.substring(pos + 1);
                                }
                                if (text.length() > 4 && Integer.parseInt(text.substring(pos + 1)) > 59) {
                                    text = text.substring(0, pos) + ":59";
                                }
                            }
                            this.value.setValue((Object)LocalTime.parse(text, DateTimeFormatter.ISO_LOCAL_TIME));
                        }
                        catch (Exception e) {
                            UiUtil.blink((Node)this.textField);
                            this.textField.clear();
                            this.value.set(null);
                        }
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent evt) {
                        int pos = TimeValueWidget.this.textField.getCaretPosition();
                        if (TimeValueWidget.ALLOWED_CHARS.contains(evt.getCharacter()) && pos <= 4) {
                            TimeValueWidget.this.textField.deselect();
                            if (pos == 2) {
                                TimeValueWidget.this.textField.forward();
                            }
                            TimeValueWidget.this.textField.deleteNextChar();
                        } else {
                            evt.consume();
                        }
                    }
                });
                this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent evt) {
                        switch (evt.getCode()) {
                            case BACK_SPACE: 
                            case LEFT: {
                                TimeValueWidget.this.textField.backward();
                                break;
                            }
                            case DELETE: 
                            case RIGHT: {
                                TimeValueWidget.this.textField.forward();
                                break;
                            }
                        }
                        evt.consume();
                    }
                });
                this.textField.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent evt) {
                        TimeValueWidget.this.textField.deselect();
                    }
                });
                this.getChildren().setAll((Object[])new Node[]{this.textField});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        LocalTime val = (LocalTime)this.value.get();
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(val == null ? this.promptText : this.getText());
        } else {
            this.textField.setText(this.getText());
        }
    }

    public boolean hasSameValue(LocalTime val) {
        LocalTime current = (LocalTime)this.value.get();
        if (current == null && val == null) {
            return true;
        }
        if (current == null || val == null) {
            return false;
        }
        return FORMATTER.format(current).equalsIgnoreCase(FORMATTER.format(val));
    }
}

