/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.shape.Rectangle;

public class BigTableWidget<T>
extends BorderPane
implements HasViewState,
DevTool {
    private static final ObservableValue<Object> NULL_OBJECT_WRAPPER = new ReadOnlyObjectWrapper();
    private static final double MAX_COLUMN_WIDTH = 5000.0;
    private static final double MIN_COLUMN_WIDTH = 110.0;
    private static final double MIN_COLUMN_WIDTH_THRESHOLD = 20.0;
    private static final String UNRESIZABLE_STYLE = "unresizable";
    private PlaceholderPane placeholderPane;
    TableView<ItemWrapper> tableView;
    private FilteringPane<?> filteringPane;
    private final Label placeholder;
    protected final ViewState viewState = new ViewState();
    protected MultiProvider<T> itemsProvider;
    private final List<BigTableWidgetColumn<T, ?>> columns = new ArrayList();
    final ObservableList<ItemWrapper> data = FXCollections.observableArrayList();
    private final Set<ItemWrapper> filteredOutData = new HashSet<ItemWrapper>();
    protected Predicate<ControlsPane.ButtonType> controlButtonsAvailability = ControlsPane.ADD_REMOVE;
    private String fieldName;
    private boolean dataChanged;
    private static final EventHandler<? super MouseEvent> eventMuter = Event::consume;

    public BigTableWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"big-table-widget");
        this.placeholder = new Label(Messages.General_No_data);
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
        this.data.addListener(src -> {
            this.dataChanged = true;
        });
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.updateTable();
            }
        });
    }

    private void updateResizePolicy() {
        double totalColumnsWidth = this.tableView.getColumns().stream().collect(Collectors.summarizingDouble(TableColumnBase::getWidth)).getSum();
        if (totalColumnsWidth < this.tableView.getWidth() || !TableView.UNCONSTRAINED_RESIZE_POLICY.equals(this.tableView.getColumnResizePolicy())) {
            this.tableView.setColumnResizePolicy(CustomTableView.getConstrainedResizePolicy());
        } else {
            this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        }
    }

    private void initReorderRestriction() {
        this.getTableHeaderRow().getRootHeader().getColumnHeaders().addListener(change -> {
            change.next();
            change.getAddedSubList().forEach(columnHeader -> {
                columnHeader.setOnMousePressed(Event::consume);
                columnHeader.setOnMouseDragged(Event::consume);
            });
        });
    }

    private TableHeaderRow getTableHeaderRow() {
        if (this.tableView.getSkin() == null) {
            this.tableView.setSkin((Skin)new TableViewSkin(this.tableView));
        }
        return (TableHeaderRow)((TableViewSkin)this.tableView.getSkin()).getChildren().stream().filter(node -> node instanceof TableHeaderRow).findFirst().get();
    }

    private void setColumnsMinWidth() {
        this.tableView.getColumns().stream().filter(column -> column.getMinWidth() < 20.0).forEach(column -> column.setMinWidth(110.0));
    }

    private void initResizeRestrictions() {
        this.tableView.getColumns().forEach(column -> column.visibleProperty().addListener(o -> this.updateResizeRestrictions()));
        this.getTableHeaderRow().getRootHeader().widthProperty().addListener(o -> this.updateResizeRestrictions());
    }

    private void updateResizeRestrictions() {
        this.tableView.getColumns().forEach(column -> {
            if (column.getMinWidth() == column.getMaxWidth() || !column.isResizable()) {
                Styles.addStyle((Styleable)column, UNRESIZABLE_STYLE);
                this.addInterceptors((TableColumn<ItemWrapper, ?>)column);
            } else {
                Styles.removeStyle((Styleable)column, UNRESIZABLE_STYLE);
                this.removeInterceptors((TableColumn<ItemWrapper, ?>)column);
            }
        });
    }

    private void addInterceptors(TableColumn<ItemWrapper, ?> column) {
        Rectangle rect = this.getDragRects().get(column);
        if (rect != null) {
            rect.setOnMouseEntered(eventMuter);
            rect.setOnMousePressed(eventMuter);
            rect.setOnMouseDragged(eventMuter);
        } else if (this.tableView.getColumns().indexOf(column) == this.tableView.getColumns().size() - 1) {
            this.addInterceptors(this.getLastVisibleColumn());
        }
    }

    private void removeInterceptors(TableColumn<ItemWrapper, ?> column) {
        Rectangle rect = this.getDragRects().get(column);
        if (rect != null) {
            rect.removeEventHandler(MouseEvent.MOUSE_ENTERED, eventMuter);
            rect.removeEventHandler(MouseEvent.MOUSE_DRAGGED, eventMuter);
            rect.removeEventHandler(MouseEvent.MOUSE_PRESSED, eventMuter);
        }
    }

    private TableColumn<ItemWrapper, ?> getLastVisibleColumn() {
        TableColumn lastVisibleColumn = null;
        int i = this.tableView.getColumns().size() - 1;
        while (lastVisibleColumn == null && i-- > 0) {
            if (!((TableColumn)this.tableView.getColumns().get(i)).isVisible()) continue;
            lastVisibleColumn = (TableColumn)this.tableView.getColumns().get(i);
        }
        return lastVisibleColumn;
    }

    private Map<TableColumn<ItemWrapper, ?>, Rectangle> getDragRects() {
        try {
            Field dragRectsField = NestedTableColumnHeader.class.getDeclaredField("dragRects");
            dragRectsField.setAccessible(true);
            return (Map)dragRectsField.get(this.getTableHeaderRow().getRootHeader());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            ErrorHandler.handle(e);
            return null;
        }
    }

    private void updateState() {
        if (this.tableView == null) {
            return;
        }
        this.tableView.setEditable(!this.viewState.isImmutable());
        this.tableView.refresh();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setPlaceholder(String value) {
        this.placeholder.setText(value);
    }

    public void setColumns(List<BigTableWidgetColumn<T, ?>> value) {
        if (this.tableView != null) {
            throw new IllegalStateException("table is not empty");
        }
        value.forEach(column -> column.setOwner(this));
        ArrayList oldColumns = new ArrayList(this.columns);
        this.columns.clear();
        this.columns.addAll(value);
        oldColumns.forEach(column -> column.setOwner(null));
    }

    public List<BigTableWidgetColumn<T, ?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public BigTableWidgetColumn<T, ?> getColumn(String id) {
        for (BigTableWidgetColumn<T, ?> col : this.columns) {
            if (!id.equals(col.getId())) continue;
            return col;
        }
        throw new IllegalArgumentException("invalid column ID " + id);
    }

    public void setItemsProvider(MultiProvider<T> value) {
        this.itemsProvider = Objects.requireNonNull(value);
    }

    public void setControlButtonsAvailability(Predicate<ControlsPane.ButtonType> value) {
        this.controlButtonsAvailability = Objects.requireNonNull(value);
        this.placeholderPane = null;
        this.updateTable();
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public <N extends Node> void setFiltering(Supplier<N> filtersPaneSupplier, Function<N, Predicate<T>> predicateSupplier, boolean collapsible) {
        FilteringPane<Node> pane = filtersPaneSupplier == null ? null : new FilteringPane<Node>(filtersPaneSupplier, collapsible);
        this.filteringPane = pane;
        this.filteredOutData.clear();
        if (pane != null) {
            pane.setOnApply(filtersPane -> {
                Predicate predicate = (Predicate)predicateSupplier.apply(filtersPane);
                this.filteredOutData.clear();
                this.data.stream().filter(rule -> !predicate.test(rule.getItem())).collect(Collectors.toCollection(() -> this.filteredOutData));
                this.updateTable();
            });
            if (this.tableView != null) {
                this.setTop((Node)this.filteringPane);
            }
        } else {
            this.setTop((Node)this.filteringPane);
        }
        this.updateTable();
    }

    public void applyFiltering() {
        this.filteringPane.apply();
    }

    public int getRowsCount() {
        return this.data.size();
    }

    int getRowIndexOf(T rowData) {
        int i = 0;
        for (ItemWrapper wrapper : this.data) {
            if (rowData.equals(wrapper.getItem())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    T getData(int visibleRowIndex) {
        return this.tableView == null ? null : (T)((ItemWrapper)this.tableView.getItems().get(visibleRowIndex)).getItem();
    }

    public void addRow(int pos) {
        this.itemsProvider.createAny(this.buildItemsConsumer(pos));
    }

    public void addRow(int pos, T item) {
        this.data.add(pos, (Object)new ItemWrapper(item));
        if (this.filteringPane != null) {
            this.filteringPane.reset();
        }
        this.dataChanged = true;
        if (this.filteringPane != null) {
            this.filteringPane.reset();
        }
        if (this.tableView != null) {
            this.tableView.getSelectionModel().clearSelection();
        }
        this.updateTable();
    }

    public void addRow(T item) {
        this.addRow(this.data.size(), item);
    }

    public void removeRow(int pos) {
        this.data.remove(pos);
        this.updateTable();
    }

    public void removeAllRows() {
        this.data.clear();
        this.updateTable();
    }

    public Collection<T> getRowsData() {
        return this.data.stream().map(ItemWrapper::getPopulatedData).collect(Collectors.toList());
    }

    public Object getCellValue(int rowIndex, String columnId) {
        return ((ItemWrapper)this.data.get(rowIndex)).getValue(columnId).get();
    }

    public void setCellValue(int rowIndex, String columnId, Object value) {
        ((ItemWrapper)this.data.get(rowIndex)).getValue(columnId).set(value);
    }

    void readData(Collection<T> model) {
        this.data.setAll((Collection)model.stream().map(x$0 -> new ItemWrapper(x$0)).collect(Collectors.toList()));
        this.dataChanged = false;
        if (this.filteringPane != null) {
            this.filteringPane.reset();
        }
        if (this.tableView != null) {
            this.tableView.getSelectionModel().clearSelection();
        }
        this.updateTable();
    }

    void writeData(Collection<T> model) {
        model.clear();
        this.data.stream().peek(ItemWrapper::writeData).map(ItemWrapper::getItem).collect(Collectors.toCollection(() -> model));
        this.dataChanged = false;
        this.updateTable();
    }

    boolean isDataChanged() {
        if (this.dataChanged) {
            return true;
        }
        for (ItemWrapper item : this.data) {
            if (!item.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    void updateTable() {
        if (this.getScene() == null) {
            return;
        }
        if (this.data.isEmpty()) {
            this.tableView = null;
            if (this.placeholderPane == null) {
                this.placeholderPane = new PlaceholderPane();
                this.placeholderPane.setPlaceholder(this.placeholder);
                if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                    ControlsPane controlsPane = new ControlsPane();
                    controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.itemsProvider.createAny(this.buildItemsConsumer(null))));
                    controlsPane.visibleProperty().bind((ObservableValue)new BooleanBinding(){
                        {
                            this.bind(new Observable[]{BigTableWidget.this.viewState.stateProperty()});
                        }

                        protected boolean computeValue() {
                            return !BigTableWidget.this.viewState.isImmutable();
                        }
                    });
                    this.placeholderPane.setControlsPane(controlsPane);
                }
            }
            this.setTop((Node)this.placeholderPane);
            this.setCenter(null);
            return;
        }
        this.placeholderPane = null;
        if (this.tableView == null) {
            this.tableView = new TableView();
            this.tableView.setMaxHeight(Double.MAX_VALUE);
            this.tableView.widthProperty().addListener(obj -> this.updateResizePolicy());
            this.tableView.setTableMenuButtonVisible(false);
            this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>(this.columns.size());
            boolean hasStyles = this.columns.stream().anyMatch(col -> col.getPrefWidthEm() != null || col.getMaxWidthEm() != null || col.getMinWidthEm() != null);
            for (BigTableWidgetColumn col2 : this.columns) {
                TableColumn tableColumn = new TableColumn(col2.getCaption());
                tableColumn.setId(col2.getId());
                TableColumnSettings.configureSorting(tableColumn, col2.isSortable());
                tableColumn.setCellValueFactory(cdf -> ((ItemWrapper)cdf.getValue()).getValue(col2.getId()));
                tableColumn.setCellFactory(col2.getCellFactory());
                if (col2.getHelp() != null) {
                    TableColumnSettings.setHelp(tableColumn, col2.getHelp());
                }
                if (col2.isNotEditable()) {
                    tableColumn.setEditable(false);
                }
                String style = "";
                if (col2.getPrefWidthEm() != null) {
                    style = style + "-fx-pref-width:" + col2.getPrefWidthEm() + "em;";
                    tableColumn.setPrefWidth(UiUtil.convertEmToPixels(col2.getPrefWidthEm()));
                }
                if (col2.getMaxWidthEm() != null) {
                    style = style + "-fx-max-width:" + col2.getMaxWidthEm() + "em;";
                    tableColumn.setMaxWidth(UiUtil.convertEmToPixels(col2.getMaxWidthEm()));
                }
                if (col2.getMinWidthEm() != null) {
                    style = style + "-fx-min-width:" + col2.getMinWidthEm() + "em;";
                    tableColumn.setMinWidth(UiUtil.convertEmToPixels(col2.getMinWidthEm()));
                }
                if (!style.isEmpty()) {
                    tableColumn.setStyle(style);
                } else if (hasStyles) {
                    tableColumn.setMaxWidth(5000.0);
                }
                tableColumns.add(tableColumn);
            }
            this.tableView.getColumns().addListener(src -> {
                this.initReorderRestriction();
                this.initResizeRestrictions();
                this.setColumnsMinWidth();
                Styles.addStyle((Styleable)this.tableView.getColumns().get(0), "first-column");
            });
            this.tableView.getColumns().addAll(tableColumns);
            this.tableView.editableProperty().addListener(src -> this.toggleControlColumn());
            this.tableView.setEditable(!this.viewState.isImmutable());
            this.setCenter((Node)this.tableView);
            this.setTop((Node)this.filteringPane);
        }
        int idx = 0;
        for (ItemWrapper item2 : this.data) {
            item2.setIndex(idx++);
        }
        if (this.filteringPane != null) {
            Object filteredData = !this.filteredOutData.isEmpty() ? this.data.stream().filter(item -> !this.filteredOutData.contains(item)).collect(Collectors.toList()) : this.data;
            this.filteringPane.setCaption(Messages.getGeneral_Paging_filter(this.fieldName, filteredData.size(), this.data.size()));
            this.tableView.getItems().setAll(filteredData);
        } else {
            this.tableView.getItems().setAll(this.data);
        }
        this.tableView.refresh();
    }

    private void toggleControlColumn() {
        TableColumn col;
        if (this.tableView == null) {
            return;
        }
        String ccId = "__controlColumn";
        if (this.tableView.isEditable()) {
            TableColumn<ItemWrapper, Object> col2 = (TableColumn<ItemWrapper, Object>)this.tableView.getProperties().get((Object)ccId);
            if (this.isControlColumnRequired()) {
                if (col2 == null) {
                    col2 = this.createControlColumn();
                    col2.setId(ccId);
                    this.tableView.getProperties().put((Object)ccId, col2);
                }
                if (!this.tableView.getColumns().contains(col2)) {
                    this.tableView.getColumns().add(col2);
                }
            } else if (col2 != null) {
                this.tableView.getColumns().remove(col2);
            }
        } else if (!this.tableView.getColumns().isEmpty() && ccId.equals((col = (TableColumn)this.tableView.getColumns().get(this.tableView.getColumns().size() - 1)).getId())) {
            this.tableView.getColumns().remove((Object)col);
        }
    }

    private boolean isControlColumnRequired() {
        return Stream.of(ControlsPane.ButtonType.values()).anyMatch(this.controlButtonsAvailability);
    }

    private TableColumn<ItemWrapper, Object> createControlColumn() {
        TableColumn result = new TableColumn();
        double width = Stream.of(ControlsPane.ButtonType.values()).filter(this.controlButtonsAvailability).count() * 28L;
        result.getStyleClass().add((Object)"controls-column");
        result.setMinWidth(width);
        result.setPrefWidth(width);
        result.setMaxWidth(width);
        result.setResizable(false);
        result.setSortable(false);
        result.setEditable(false);
        result.setCellValueFactory(param -> NULL_OBJECT_WRAPPER);
        result.setCellFactory(column -> new TableCell<ItemWrapper, Object>(){
            private ControlsPane graphics;

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setGraphic(null);
                    return;
                }
                if (this.graphics == null) {
                    this.graphics = new ControlsPane();
                    if (BigTableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                        UiUtil.setTooltip((Node)this.graphics.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                            this.forceSelection();
                            BigTableWidget.this.moveDown(this.getRowValue());
                        }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                            {
                                this.bind(new Observable[]{BigTableWidget.this.tableView.getItems(), this.indexProperty()});
                            }

                            protected boolean computeValue() {
                                return !BigTableWidget.this.isMoveDownAvailable(this.getRowValue());
                            }
                        }), Messages.General_Move_line_down_to_one);
                    }
                    if (BigTableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                        UiUtil.setTooltip((Node)this.graphics.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                            this.forceSelection();
                            BigTableWidget.this.moveUp(this.getRowValue());
                        }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                            {
                                this.bind(new Observable[]{BigTableWidget.this.tableView.getItems(), this.indexProperty()});
                            }

                            protected boolean computeValue() {
                                return !BigTableWidget.this.isMoveUpAvailable(this.getRowValue());
                            }
                        }), Messages.General_Move_line_up_to_one);
                    }
                    if (BigTableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                        UiUtil.setTooltip((Node)this.graphics.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                            this.forceSelection();
                            if (BigTableWidget.this.data.removeAll((Collection)this.getTableView().getSelectionModel().getSelectedItems())) {
                                BigTableWidget.this.updateTable();
                            }
                        })), Messages.General_Remove_line);
                    }
                    if (BigTableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                        UiUtil.setTooltip((Node)this.graphics.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                            this.forceSelection();
                            BigTableWidget.this.itemsProvider.createAny(BigTableWidget.this.buildItemsConsumer(this.getIndex() + 1));
                        })), Messages.General_Add_new_line_after_this);
                    }
                }
                this.setGraphic((Node)this.graphics);
            }

            private ItemWrapper getRowValue() {
                int idx = this.getIndex();
                ObservableList items = this.getTableView().getItems();
                return items.isEmpty() || idx < 0 || idx > items.size() - 1 ? null : (ItemWrapper)items.get(idx);
            }

            private void forceSelection() {
                int idx = this.getIndex();
                if (idx >= 0 && idx < this.getTableView().getItems().size()) {
                    this.getTableView().getSelectionModel().select(idx);
                }
            }
        });
        return result;
    }

    Consumer<Collection<T>> buildItemsConsumer(Integer pos) {
        return items -> {
            if (items == null || items.isEmpty()) {
                return;
            }
            ArrayList<ItemWrapper> list = new ArrayList<ItemWrapper>(items.size());
            for (Object item : items) {
                if (item == null) continue;
                list.add(new ItemWrapper(item));
            }
            if (list.isEmpty()) {
                return;
            }
            if (pos == null) {
                this.data.addAll(list);
            } else {
                this.data.addAll(pos.intValue(), list);
            }
            this.dataChanged = true;
            this.updateTable();
        };
    }

    boolean isMoveUpAvailable(ItemWrapper item) {
        if (item == null) {
            return false;
        }
        ObservableList items = this.tableView.getItems();
        int pos = items.indexOf(item);
        if (pos <= 0) {
            return false;
        }
        ItemWrapper upItem = (ItemWrapper)items.get(pos - 1);
        return item.getIndex() - upItem.getIndex() == 1;
    }

    void moveUp(ItemWrapper item) {
        if (item == null) {
            return;
        }
        FxUtil.swap(this.data, item.getIndex() - 1, item.getIndex());
        this.updateTable();
    }

    boolean isMoveDownAvailable(ItemWrapper item) {
        if (item == null) {
            return false;
        }
        ObservableList items = this.tableView.getItems();
        int pos = items.indexOf(item);
        if (pos >= items.size() - 1) {
            return false;
        }
        ItemWrapper downItem = (ItemWrapper)items.get(pos + 1);
        return downItem.getIndex() - item.getIndex() == 1;
    }

    void moveDown(ItemWrapper item) {
        if (item == null) {
            return;
        }
        FxUtil.swap(this.data, item.getIndex(), item.getIndex() + 1);
        this.updateTable();
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return BigTableWidget.this.getColumns();
            }

            @Override
            public String getInfo() {
                return BigTableWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(BigTableWidget.this.viewState);
            }
        };
    }

    class ItemWrapper {
        private final T item;
        private int index;
        private final Map<String, ObjectProperty<Object>> values = new HashMap<String, ObjectProperty<Object>>();

        ItemWrapper(T itm) {
            this.item = itm;
        }

        T getItem() {
            return this.item;
        }

        int getIndex() {
            return this.index;
        }

        void setIndex(int value) {
            this.index = value;
        }

        ObjectProperty<Object> getValue(String columnId) {
            SimpleObjectProperty result = this.values.get(columnId);
            if (result == null) {
                BigTableWidgetColumn column = BigTableWidget.this.getColumn(columnId);
                result = new SimpleObjectProperty(column.getCellValue(this.item));
                for (ChangeListener<?> listener : column.getListeners()) {
                    result.addListener(listener);
                }
                this.values.put(columnId, (ObjectProperty<Object>)result);
            }
            return result;
        }

        void writeData() {
            for (Map.Entry<String, ObjectProperty<Object>> entry : this.values.entrySet()) {
                BigTableWidgetColumn column = BigTableWidget.this.getColumn(entry.getKey());
                if (column.isNotEditable()) continue;
                column.setCellValue(this.item, entry.getValue().getValue());
            }
        }

        boolean isDataChanged() {
            for (Map.Entry<String, ObjectProperty<Object>> entry : this.values.entrySet()) {
                BigTableWidgetColumn column = BigTableWidget.this.getColumn(entry.getKey());
                if (column.isNotEditable() || !column.isCellValueChanged(this.item, entry.getValue().get())) continue;
                return true;
            }
            return false;
        }

        T getPopulatedData() {
            Object result = BigTableWidget.this.itemsProvider.createOne();
            for (Map.Entry<String, ObjectProperty<Object>> entry : this.values.entrySet()) {
                BigTableWidgetColumn column = BigTableWidget.this.getColumn(entry.getKey());
                column.setCellValue(result, entry.getValue().getValue());
            }
            return result;
        }
    }
}

