/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;

public class NestedEntityReferenceColumn<T, R extends BaseEntity, N extends BaseEntity>
extends BigTableWidgetColumn<T, NestedEntityReference<R, N>> {
    private final Class<R> rootEntityType;
    private final Class<N> nestedEntityType;
    private final Function<T, NestedEntityReference<R, N>> getter;
    private final BiConsumer<T, NestedEntityReference<R, N>> setter;
    private Supplier<List<NestedEntityReference<R, N>>> itemsSupplier;
    private Supplier<IndexListParameters<R, ?>> listParametersSupplier;
    private MultiSupplier<IndexListParameters<R, ?>> listParametersMultiSupplier;
    private Function<EntityIndex<R>, NestedEntityReference<R, N>> nestedReferenceBuilder;
    private boolean live;
    private final Callback<TableColumn<T, NestedEntityReference<R, N>>, TableCell<T, NestedEntityReference<R, N>>> cellFactory = column -> new NestedEntityBoxWidgetCell();

    public NestedEntityReferenceColumn(Class<R> rCls, Class<N> nCls, Function<T, NestedEntityReference<R, N>> aGetter, BiConsumer<T, NestedEntityReference<R, N>> aSetter) {
        this.rootEntityType = rCls;
        this.nestedEntityType = nCls;
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setItemsSupplier(Supplier<List<NestedEntityReference<R, N>>> itemsSupplier) {
        this.itemsSupplier = itemsSupplier;
    }

    public <I extends EntityIndex<R>> void setListParametersSupplier(Supplier<IndexListParameters<R, I>> listParametersSupplier) {
        this.listParametersSupplier = listParametersSupplier;
    }

    public void setListParametersMultiSupplier(MultiSupplier<IndexListParameters<R, ?>> listParametersMultiSupplier) {
        this.listParametersMultiSupplier = listParametersMultiSupplier;
    }

    public void setNestedReferenceBuilder(Function<EntityIndex<R>, NestedEntityReference<R, N>> nestedReferenceBuilder) {
        this.nestedReferenceBuilder = Objects.requireNonNull(nestedReferenceBuilder);
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    @Override
    protected NestedEntityReference<R, N> getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, NestedEntityReference<R, N> value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, NestedEntityReference<R, N> value) {
        return !MiscUtil.equals(value, this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, NestedEntityReference<R, N>>, TableCell<T, NestedEntityReference<R, N>>> getCellFactory() {
        return this.cellFactory;
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                return NestedEntityReferenceColumn.this.getClass().getSimpleName() + " [" + NestedEntityReferenceColumn.this.rootEntityType.getName() + "] [" + NestedEntityReferenceColumn.this.nestedEntityType.getName() + "] [" + NestedEntityReferenceColumn.this.getId() + ']';
            }
        };
    }

    class NestedEntityBoxWidgetCell
    extends TableCell<T, NestedEntityReference<R, N>> {
        private final PseudoClass EDITING_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"editing");
        private HyperlinkWidget viewWidget;
        private NestedEntityBoxWidget<R, N> editWidget;

        NestedEntityBoxWidgetCell() {
            this.setOnKeyPressed(Event::consume);
        }

        protected void updateItem(NestedEntityReference<R, N> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.getTableView().isEditable() && !NestedEntityReferenceColumn.this.isNotEditable()) {
                if (this.editWidget == null) {
                    this.editWidget = new NestedEntityBoxWidget(NestedEntityReferenceColumn.this.rootEntityType, NestedEntityReferenceColumn.this.nestedEntityType, false);
                    this.editWidget.setFieldName(NestedEntityReferenceColumn.this.getCaption());
                    this.editWidget.setMinWidth(Double.NEGATIVE_INFINITY);
                    this.editWidget.setMaxWidth(Double.MAX_VALUE);
                    this.editWidget.setLive(NestedEntityReferenceColumn.this.live);
                    if (NestedEntityReferenceColumn.this.itemsSupplier != null) {
                        this.editWidget.setItemsSupplier(NestedEntityReferenceColumn.this.itemsSupplier, false);
                    }
                    if (NestedEntityReferenceColumn.this.listParametersSupplier != null) {
                        this.editWidget.setListParametersSupplier(NestedEntityReferenceColumn.this.listParametersSupplier);
                    }
                    if (NestedEntityReferenceColumn.this.listParametersMultiSupplier != null) {
                        this.editWidget.setListParametersSupplier(NestedEntityReferenceColumn.this.listParametersMultiSupplier);
                    }
                    if (NestedEntityReferenceColumn.this.nestedReferenceBuilder != null) {
                        this.editWidget.setNestedReferenceBuilder(NestedEntityReferenceColumn.this.nestedReferenceBuilder);
                    }
                    this.editWidget.valueProperty().addListener((s, o, n) -> this.setItem(n));
                    this.editWidget.setOnKeyReleased(evt -> {
                        if (evt.getCode() == KeyCode.ESCAPE) {
                            this.editWidget.setValue((EntityReference)this.getItem());
                            this.cancelEdit();
                            evt.consume();
                        }
                    });
                    this.editWidget.focusedProperty().addListener((src, o, n) -> {
                        if (!n.booleanValue() && this.isEditing()) {
                            this.commitEdit(this.editWidget.getValue());
                        }
                        this.pseudoClassStateChanged(this.EDITING_PSEUDOCLASS, this.isEditing());
                    });
                }
                this.editWidget.setValue((EntityReference)this.getItem());
                this.setGraphic((Node)this.editWidget);
            } else {
                if (this.viewWidget == null) {
                    this.viewWidget = new HyperlinkWidget();
                }
                this.viewWidget.setOnAction(evt -> EntityEditorHelper.navigate(item, false));
                this.viewWidget.setText((String)StandardRenderers.GENERIC.apply(item));
                this.setGraphic((Node)this.viewWidget);
            }
        }
    }
}

