/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyWrapper;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.WrapperType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import javafx.util.StringConverter;

public class CurrencyValueWidget
extends StackPane
implements HasViewState,
HasValue<String> {
    static Supplier<List<CurrencyItem>> availableCurrenciesSupplier = () -> {
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        return Currency.getAvailableCurrencies().stream().map(curr -> new CurrencyItem((Currency)curr, currentLocale){
            final /* synthetic */ Currency val$curr;
            final /* synthetic */ Locale val$currentLocale;
            {
                this.val$curr = currency;
                this.val$currentLocale = locale;
            }

            @Override
            public String getCode() {
                return this.val$curr.getCurrencyCode();
            }

            @Override
            public String getDisplayName() {
                return this.val$curr.getDisplayName(this.val$currentLocale);
            }
        }).collect(Collectors.toList());
    };
    private ComboBoxWidget<CurrencyWrapper> comboBox;
    private Label readonlyLabel;
    private final ObjectProperty<String> value = new SimpleObjectProperty((Object)this, "value");
    private boolean percentValue;
    private boolean internalChange = false;
    private boolean percentOption = false;
    private final ViewState viewState = new ViewState();
    String promptText;
    private boolean noNulls;
    private boolean live;
    private boolean compactMode;

    public static void setAvailableCurrenciesSupplier(Supplier<List<CurrencyItem>> value) {
        availableCurrenciesSupplier = Objects.requireNonNull(value);
    }

    public CurrencyValueWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
        this.getStyleClass().addAll((Object[])new String[]{"currency-value-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener((s, o, val) -> {
            if (this.comboBox != null && this.internalChange) {
                return;
            }
            this.renderValue();
        });
        this.updateState();
        this.setDefaultValue();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.promptText = ViewState.isImmutable(n.intValue()) ? "\u2014" : UiUtil.NULL_TEXT;
            this.updateState();
        });
    }

    public void requestFocus() {
        if (this.comboBox != null) {
            this.comboBox.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setDefaultValue() {
        GlobalSettingsService service = GlobalSettingsService.get();
        this.value.set((Object)(service == null ? null : service.getDefaultCurrency()));
    }

    @Override
    public final ObjectProperty<String> valueProperty() {
        return this.value;
    }

    public final String getValue() {
        return (String)this.value.get();
    }

    public final void setValue(String val) {
        this.percentValue = false;
        this.value.set((Object)val);
    }

    public final void setCurrencyCode(String code) {
        if ("%".equals(code)) {
            this.percentValue = true;
            this.value.set(null);
        } else {
            this.percentValue = false;
            this.value.set((Object)(code == null ? null : code));
        }
    }

    public void setNoNulls(boolean val) {
        this.noNulls = val;
        if (this.comboBox != null) {
            this.comboBox.setNoNulls(this.noNulls);
        }
    }

    public void setPercentOption(boolean val) {
        this.percentOption = val;
    }

    public boolean isPercent() {
        return this.percentValue;
    }

    public void setLive(boolean val) {
        this.live = val;
        if (this.comboBox != null) {
            this.comboBox.setLive(this.live);
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setCompactMode(boolean value) {
        this.compactMode = value;
        if (this.comboBox != null) {
            this.comboBox.setButtonStyle(this.compactMode ? CustomComboBox.ButtonStyle.HIDDEN : CustomComboBox.ButtonStyle.STANDARD);
        }
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.comboBox != null) {
                this.comboBox = null;
            }
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.comboBox == null) {
                this.comboBox = new ComboBoxWidget(false);
                this.comboBox.setSortItems(false);
                this.comboBox.setLive(this.live);
                this.comboBox.setNoNulls(this.noNulls);
                this.comboBox.setButtonStyle(this.compactMode ? CustomComboBox.ButtonStyle.HIDDEN : CustomComboBox.ButtonStyle.STANDARD);
                this.comboBox.setItemsSupplier(() -> {
                    ArrayList<CurrencyWrapper> result = new ArrayList<CurrencyWrapper>();
                    if (this.percentOption) {
                        result.add(new CurrencyWrapper(WrapperType.PERCENT, null));
                    }
                    int count = 0;
                    for (String currency : GlobalSettingsService.get().getPreferredCurrencies()) {
                        result.add(new CurrencyWrapper(WrapperType.VALUE, currency));
                        ++count;
                    }
                    if (count == 0) {
                        result.add(new CurrencyWrapper(WrapperType.VALUE, GlobalSettingsService.get().getDefaultCurrency()));
                    }
                    result.add(new CurrencyWrapper(WrapperType.MORE, null));
                    return result;
                });
                this.comboBox.setValueApprover(val -> {
                    if (val == null || val.getType() != WrapperType.MORE) {
                        return true;
                    }
                    this.openCurrenciesDialog(currency -> this.comboBox.setValue(new CurrencyWrapper(WrapperType.VALUE, (String)currency)));
                    return false;
                });
                this.comboBox.setConverter(new StringConverter<CurrencyWrapper>(){

                    public String toString(CurrencyWrapper wrapper) {
                        if (wrapper == null) {
                            return CurrencyValueWidget.this.promptText;
                        }
                        if (wrapper.getType() == WrapperType.PERCENT) {
                            return "%";
                        }
                        if (wrapper.getType() == WrapperType.MORE) {
                            return Messages.General_More;
                        }
                        return wrapper.getCurrency();
                    }

                    public CurrencyWrapper fromString(String string) {
                        return null;
                    }
                });
                this.comboBox.valueProperty().addListener((s, o, n) -> {
                    this.internalChange = true;
                    this.percentValue = n != null && n.getType() == WrapperType.PERCENT;
                    this.value.setValue(n != null && n.getType() == WrapperType.VALUE ? n.getCurrency() : null);
                    this.internalChange = false;
                });
                this.getChildren().setAll((Object[])new Node[]{this.comboBox});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        String val = (String)this.value.get();
        if (this.comboBox != null) {
            if (this.percentValue) {
                this.comboBox.setValue(new CurrencyWrapper(WrapperType.PERCENT, null));
            } else {
                this.comboBox.setValue(val == null ? null : new CurrencyWrapper(WrapperType.VALUE, val));
            }
            this.comboBox.redraw();
        } else if (this.percentValue) {
            this.readonlyLabel.setText("%");
        } else {
            this.readonlyLabel.setText(val == null ? this.promptText : val);
        }
    }

    private void openCurrenciesDialog(Consumer<String> successAction) {
        final DataViewWidget<CurrencyItem> widget = new DataViewWidget<CurrencyItem>(true);
        TableColumnSettings col = new TableColumnSettings();
        col.setId("code");
        col.setDisplayName("\u041a\u043e\u0434");
        col.setSortable(false);
        widget.getTableView().getColumns().add(col.createColumn(item -> item.getCode()));
        col = new TableColumnSettings();
        col.setId("name");
        col.setDisplayName("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        col.setSortable(false);
        widget.getTableView().getColumns().add(col.createColumn(item -> item.getDisplayName()));
        SearchTextField searchField = new SearchTextField();
        searchField.textProperty().addListener((s, o, n) -> widget.reloadData());
        searchField.setPromptText(Messages.General_Find);
        Runnable selectAction = () -> {
            ObservableList items = widget.getTableView().getSelectionModel().getSelectedItems();
            if (!items.isEmpty()) {
                successAction.accept(((CurrencyItem)items.get(0)).getCode());
            }
        };
        final Supplier<List> filteredCurrencyItemsSupplier = () -> availableCurrenciesSupplier.get().stream().filter(currencyItem -> {
            if (TextUtil.nonBlank((String)searchField.getText())) {
                String value = searchField.getText().trim().toUpperCase();
                return currencyItem.getDisplayName().toUpperCase().contains(value) || currencyItem.getCode().toUpperCase().contains(value);
            }
            return true;
        }).collect(Collectors.toList());
        widget.setDefaultActionHandler(selectAction);
        widget.setHandler(new DataViewHandler<CurrencyItem>(){

            @Override
            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                Notifications.get().submitTask(() -> this.lambda$reloadData$1((Supplier)filteredCurrencyItemsSupplier), this.getMutex());
            }

            @Override
            protected int getOffset() {
                return 0;
            }

            @Override
            protected int getLimit() {
                return Integer.MAX_VALUE;
            }

            private /* synthetic */ void lambda$reloadData$1(Supplier filteredCurrencyItemsSupplier2) throws Exception {
                List currencies = (List)filteredCurrencyItemsSupplier2.get();
                Collections.sort(currencies, Comparator.comparing(CurrencyItem::getDisplayName));
                FxUtil.submitToFxThread(() -> this.getData().setAll((Collection)currencies));
            }
        });
        VBox body = new VBox(new Node[]{searchField, widget});
        body.getStyleClass().add((Object)"currency-value-widget-currencies-dialog");
        new Dialog().setTitle(Messages.General_Currency_choosing).setBody((Node)body).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, selectAction, (BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{widget.getTableView().getSelectionModel().selectedItemProperty()});
            }

            protected boolean computeValue() {
                return widget.getTableView().getSelectionModel().getSelectedItem() != null;
            }
        }).show((Node)this);
        FxUtil.submitToFxThread(widget::reloadData);
    }

    public static interface CurrencyItem {
        public String getCode();

        public String getDisplayName();
    }
}

