/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;

class DefaultListParametersMultiSupplier<E extends BaseEntity>
implements MultiSupplier<IndexListParameters<E, ?>> {
    private final Class<E> entityType;
    private List<Entry<E>> entries;

    DefaultListParametersMultiSupplier(Class<E> ett) {
        this.entityType = ett;
    }

    @Override
    public int count() {
        if (this.entries == null) {
            this.init();
        }
        return this.entries.size();
    }

    @Override
    public String getDisplayName(int idx) {
        if (this.entries == null) {
            this.init();
        }
        return this.entries.get((int)idx).name;
    }

    @Override
    public IndexListParameters<E, ?> get(int idx) {
        if (this.entries == null) {
            this.init();
        }
        return this.entries.get((int)idx).listParametersSupplier.get();
    }

    private void init() {
        RootEntityHandler entityHandler = RootEntityHandler.forEntityClass(this.entityType);
        if (entityHandler != null) {
            Entry entry = new Entry();
            entry.listParametersSupplier = () -> EntityIndexHandler.forIndexClass(entityHandler.getStandardIndexClass()).createListParameters();
            this.entries = Collections.singletonList(entry);
            return;
        }
        Collection<RootEntityHandler<?, ?>> handlers = ClientRegistry.get().allOf(RootEntityHandler.TYPE).values();
        this.entries = new ArrayList<Entry<E>>(handlers.size());
        HashSet<String> indexHandlers = new HashSet<String>(handlers.size());
        for (RootEntityHandler<?, ?> handler : handlers) {
            EntityIndexHandler indexHandler;
            if (!this.entityType.isAssignableFrom(handler.getEntityClass()) || handler.getStandardIndexClass() == null || (indexHandler = EntityIndexHandler.forIndexClass(handler.getStandardIndexClass())) == null || indexHandlers.contains(indexHandler.getId())) continue;
            indexHandlers.add(indexHandler.getId());
            Entry entry = new Entry();
            entry.name = EntityIndexHandler.format(indexHandler);
            entry.listParametersSupplier = () -> indexHandler.createListParameters();
            this.entries.add(entry);
        }
        this.entries.sort((lhs, rhs) -> TextUtil.compare((String)lhs.name, (String)rhs.name, (boolean)true, (boolean)false));
    }

    private static class Entry<E extends BaseEntity> {
        String name;
        Supplier<IndexListParameters<E, ?>> listParametersSupplier;

        Entry() {
        }
    }
}

