/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DicBoxSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.service.DictEditingService;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class DictBoxWidget<D extends BaseDictionary>
extends HBox
implements HasViewState,
HasValue<DictionaryReference<D>>,
DevTool {
    final Class<D> dictType;
    private final SimpleObjectProperty<DictionaryReference<D>> value = new SimpleObjectProperty();
    private ComboBoxWidget<DictionaryReference<D>> comboBox;
    private Hyperlink readonlyLink;
    Supplier<List<DictionaryReference<D>>> itemsSupplier;
    private boolean itemsSupplierAsync;
    DictMultiSupplier<? extends D> listParametersSupplier;
    private String fieldName = "";
    private final ViewState viewState = new ViewState();
    private boolean live;
    private StringConverter<DictionaryReference<D>> converter = StandardRenderers.DICT_CAPTION.createStatefulConverter(this.viewState::isImmutable);
    Consumer<DictItem<D>> valueSelectionListener;
    private String clearButtonTooltip;
    private Runnable clearAction;
    private Function<DictItem<D>, DictionaryReference<D>> valueBuilder = DictItem::getReference;
    private Node lookupDialogOwner = this;
    private boolean disableSuggestions = false;
    private boolean sortItems = true;
    private int suggestionsLimit = 10;

    public static <D extends BaseDictionary> DictMultiSupplier<? extends D> createDefaultListParametersSupplier(final Class<D> dictType) {
        return new DictMultiSupplier<D>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public DictListParameters get(int idx) {
                Class cls = this.getDictType(idx);
                DictHandler handler = DictHandler.forDictClass(cls);
                if (handler == null) {
                    throw Xeption.forDeveloper((String)("no handler found for dictionary class " + cls.getName()), (Object[])new Object[0]);
                }
                return handler.getStandardListParameters();
            }

            @Override
            public Class<D> getDictType(int idx) {
                return dictType;
            }
        };
    }

    public DictBoxWidget(Class<D> cls, boolean ro) {
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.dictType = Objects.requireNonNull(cls);
        this.listParametersSupplier = DictBoxWidget.createDefaultListParametersSupplier(cls);
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"dict-box-widget", "simple-widget"});
        this.value.addListener((s, o, n) -> this.updateLinkValue((DictionaryReference<D>)n));
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.comboBox != null) {
            this.comboBox.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public Class<D> getDictType() {
        return this.dictType;
    }

    public boolean isSortItems() {
        return this.sortItems;
    }

    public void setSortItems(boolean sortItems) {
        this.sortItems = sortItems;
        if (this.comboBox != null) {
            this.comboBox.setSortItems(sortItems);
        }
    }

    public void setFieldName(String val) {
        this.fieldName = val;
    }

    public void setItemsSupplier(Supplier<List<DictionaryReference<D>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
        if (this.comboBox != null) {
            this.configureComboBoxSupplier();
        }
    }

    public void setSuggestionsLimit(int suggestionsLimit) {
        this.suggestionsLimit = suggestionsLimit;
    }

    public void setLive(boolean val) {
        this.live = val;
        if (this.comboBox != null) {
            this.comboBox.setLive(this.live);
        }
    }

    public void setListParametersSupplier(DictMultiSupplier<? extends D> val) {
        if (val.count() <= 0) {
            throw new IllegalArgumentException("parameters count should be positive");
        }
        this.listParametersSupplier = val;
        if (this.comboBox != null) {
            this.configureComboBoxSupplier();
        }
    }

    public void setListParametersSupplier(final Supplier<DictListParameters> val) {
        this.listParametersSupplier = new DictMultiSupplier<D>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public DictListParameters get(int idx) {
                return (DictListParameters)val.get();
            }

            @Override
            public Class<D> getDictType(int idx) {
                return DictBoxWidget.this.dictType;
            }
        };
        if (this.comboBox != null) {
            this.configureComboBoxSupplier();
        }
    }

    public void setConverter(StringConverter<DictionaryReference<D>> val) {
        this.converter = val;
        if (this.comboBox != null) {
            this.comboBox.setConverter(this.converter);
        }
        this.redraw();
    }

    @Override
    public ObjectProperty<DictionaryReference<D>> valueProperty() {
        return this.value;
    }

    public DictionaryReference<D> getValue() {
        return (DictionaryReference)this.value.get();
    }

    public void setValue(DictionaryReference<D> val) {
        this.value.set(val);
    }

    public String getText() {
        return this.getText((DictionaryReference)this.value.get());
    }

    private String getText(DictionaryReference<D> ref) {
        if (this.converter != null) {
            return this.converter.toString(ref);
        }
        return ref == null ? null : ref.toString();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void redraw() {
        if (this.comboBox != null) {
            this.comboBox.setValue((DictionaryReference<D>)this.value.get());
            this.comboBox.redraw();
        } else {
            this.updateLinkValue((DictionaryReference)this.value.get());
        }
    }

    public void setClearButtonTooltip(String val) {
        this.clearButtonTooltip = val;
        if (this.comboBox != null) {
            this.comboBox.setClearButtonTooltip(this.clearButtonTooltip);
        }
    }

    public void setClearAction(Runnable val) {
        this.clearAction = val;
        if (this.comboBox != null) {
            this.comboBox.setClearAction(this.clearAction);
        }
    }

    public void setValueBuilder(Function<DictItem<D>, DictionaryReference<D>> val) {
        this.valueBuilder = Objects.requireNonNull(val);
    }

    public void setValueSelectionListener(Consumer<DictItem<D>> val) {
        this.valueSelectionListener = val;
    }

    private DictionaryReference<D> createValue(DictItem<D> selectedItem) {
        return this.valueBuilder.apply(selectedItem);
    }

    public void setLookupDialogOwner(Node val) {
        this.lookupDialogOwner = val;
    }

    protected void navigateTo(DictionaryReference<?> ref) {
        if (ref == null) {
            return;
        }
        DictEditingService service = DictEditingService.get();
        if (service == null) {
            return;
        }
        service.open(ref);
    }

    protected void showLookupDialog() {
        DictsListPane pane = new DictsListPane(new ObservableMutex(), new MultiSupplier<DictsListPaneConfiguration>(){

            @Override
            public int count() {
                return DictBoxWidget.this.listParametersSupplier.count();
            }

            @Override
            public String getDisplayName(int idx) {
                return DictBoxWidget.this.listParametersSupplier.getDisplayName(idx);
            }

            @Override
            public DictsListPaneConfiguration get(int idx) {
                DictsListPaneConfiguration result = new DictsListPaneConfiguration(DictHandler.forDictClass(DictBoxWidget.this.listParametersSupplier.getDictType(idx)));
                result.setSelectionMode(SelectionMode.SINGLE);
                result.setPatternSearchEnabled(true);
                result.setActionsEnabled(false);
                result.applyParameters((DictListParameters)DictBoxWidget.this.listParametersSupplier.get(idx));
                return result;
            }
        }){

            @Override
            protected void newConfigurationPopulated() {
                super.newConfigurationPopulated();
                this.getTableView().getColumns().add(TableColumnSettings.createActionColumn(item -> DictBoxWidget.this.navigateTo(item.getReference())));
            }
        };
        new Dialog().setTitle(Messages.getWritingField(this.fieldName)).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> {
            DictItem selected;
            List items = pane.getSelectedItems();
            if (!items.isEmpty()) {
                selected = (DictItem)items.get(0);
                this.valueProperty().set(this.createValue(selected));
            } else {
                selected = null;
                this.valueProperty().set(null);
            }
            if (this.valueSelectionListener != null) {
                this.valueSelectionListener.accept(selected);
            }
        }, (BooleanExpression)pane.selectionPresentProperty()).show(this.lookupDialogOwner);
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.comboBox != null) {
                this.value.unbindBidirectional(this.comboBox.valueProperty());
                this.comboBox = null;
            }
            if (this.readonlyLink == null) {
                this.readonlyLink = new HyperlinkWidget();
                this.readonlyLink.setMaxWidth(Double.MAX_VALUE);
                this.readonlyLink.setOnAction(evt -> this.navigateTo(this.getValue()));
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLink});
                this.updateLinkValue((DictionaryReference)this.value.get());
            }
        } else {
            this.readonlyLink = null;
            if (this.comboBox == null) {
                this.comboBox = new ComboBoxWidget<DictionaryReference<D>>(false){

                    @Override
                    protected boolean needDropDown() {
                        if (DictBoxWidget.this.itemsSupplier == null) {
                            DictBoxWidget.this.showLookupDialog();
                            return false;
                        }
                        return true;
                    }
                };
                HBox.setHgrow(this.comboBox, (Priority)Priority.ALWAYS);
                this.comboBox.setMaxWidth(Double.MAX_VALUE);
                this.comboBox.setSortItems(this.sortItems);
                this.comboBox.setConverter(this.converter);
                this.configureComboBoxSupplier();
                this.comboBox.setLive(this.live);
                this.comboBox.setValue((DictionaryReference<D>)this.value.get());
                this.value.bindBidirectional(this.comboBox.valueProperty());
                if (this.clearButtonTooltip != null) {
                    this.comboBox.setClearButtonTooltip(this.clearButtonTooltip);
                }
                if (this.clearAction != null) {
                    this.comboBox.setClearAction(this.clearAction);
                }
                Button navigateButton = new Button();
                navigateButton.setOnAction(evt -> this.navigateTo(this.comboBox.getValue()));
                UiUtil.setTooltip((Node)navigateButton, Messages.General_Open_object_in_new_tab);
                navigateButton.setGraphic((Node)new IconNode(StandardIconShapes.BOX_NAVIGATE, (Styleable)navigateButton, StandardIconIntentions.BOX_NAVIGATE_BUTTON_ACTION, (Styleable)navigateButton));
                navigateButton.getStyleClass().add((Object)"xtrip-button");
                this.getChildren().setAll((Object[])new Node[]{this.comboBox, navigateButton});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void configureComboBoxSupplier() {
        this.comboBox.setButtonStyle(this.itemsSupplier != null ? CustomComboBox.ButtonStyle.STANDARD : CustomComboBox.ButtonStyle.LIST);
        this.comboBox.setItemsSupplier(this.itemsSupplier);
        this.comboBox.setAsync(this.itemsSupplierAsync);
        if (this.disableSuggestions) {
            this.comboBox.setSuggestionsHandler(null);
            return;
        }
        if (this.itemsSupplier != null) {
            SimpleSuggestionsHandler suggestionsHandler = new SimpleSuggestionsHandler<DictionaryReference<D>>(this.converter, this.itemsSupplier, true){

                @Override
                public void onSuggestionSelected(DictionaryReference<D> val) {
                    if (DictBoxWidget.this.valueSelectionListener != null) {
                        DictBoxWidget.this.valueSelectionListener.accept(null);
                    }
                }
            };
            suggestionsHandler.setAsync(this.itemsSupplierAsync);
            this.comboBox.setSuggestionsHandler(suggestionsHandler);
        } else if (this.listParametersSupplier.count() == 1) {
            DictHandler<? extends D> handler = DictHandler.forDictClass(this.listParametersSupplier.getDictType(0));
            if (handler != null) {
                this.comboBox.setSuggestionsHandler(new DicBoxSuggestionsHandler<D>(handler, () -> (DictListParameters)this.listParametersSupplier.get(0), item -> this.valueBuilder.apply((DictItem<D>)item), item -> {
                    if (this.valueSelectionListener != null) {
                        this.valueSelectionListener.accept((DictItem<D>)item);
                    }
                }, () -> this.suggestionsLimit));
            }
        } else {
            this.comboBox.setSuggestionsHandler(null);
        }
    }

    private void updateLinkValue(DictionaryReference<D> val) {
        if (this.readonlyLink == null) {
            return;
        }
        this.readonlyLink.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, val == null);
        if (val == null) {
            this.readonlyLink.setText("\u2014");
            this.readonlyLink.setTooltip(null);
        } else {
            this.readonlyLink.setText(this.getText(val));
            this.readonlyLink.setTooltip(new Tooltip(Messages.General_Open_object_in_new_tab));
        }
    }

    public void setDisableSuggestions(boolean disableSuggestions) {
        this.disableSuggestions = disableSuggestions;
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                return DictBoxWidget.this.getClass().getSimpleName() + " [" + DictBoxWidget.this.getDictType().getName() + ']' + DevTools.getViewStateInfo(DictBoxWidget.this.viewState);
            }
        };
    }

    public static interface DictMultiSupplier<D extends BaseDictionary>
    extends MultiSupplier<DictListParameters> {
        public Class<D> getDictType(int var1);
    }
}

