/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class L10nTextAreaWidget
extends StackPane
implements HasViewState,
HasValue<L10nString> {
    private final SimpleObjectProperty<L10nString> value = new SimpleObjectProperty<L10nString>(){

        public void set(L10nString nv) {
            L10nString newValue;
            try {
                newValue = (L10nString)XCloneHelper.clone((XCloneable)nv);
            }
            catch (Exception e) {
                newValue = nv;
            }
            boolean same = this.get() == nv;
            super.set((Object)newValue);
            if (same) {
                this.fireValueChangedEvent();
            }
        }

        public L10nString get() {
            L10nString l10nString = (L10nString)super.get();
            if (l10nString == null) {
                l10nString = new L10nString();
                super.set((Object)l10nString);
            }
            return l10nString;
        }
    };
    private final CompactGroupsWidget<TextAreaWidget> groupWidget;
    private final ViewState viewState = new ViewState();
    private String promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
    private boolean notExpandable;
    private int prefRowCount;
    private boolean wrapText;
    private boolean monospace;

    public L10nTextAreaWidget(boolean ro) {
        this.groupWidget = new CompactGroupsWidget(ro);
        this.groupWidget.setConverter((taWidget, idx) -> {
            Locale locale = this.getLocale((TextAreaWidget)taWidget);
            return locale.getDisplayLanguage();
        });
        this.groupWidget.setViewFactory(new MultiProvider<TextAreaWidget>(){

            @Override
            public TextAreaWidget createOne() {
                throw new UnsupportedOperationException("expect createAny method");
            }

            @Override
            public void createAny(Consumer<Collection<TextAreaWidget>> consumer) {
                LocaleValueWidget widget = new LocaleValueWidget(false);
                widget.setFilter(loc -> !((L10nString)L10nTextAreaWidget.this.value.get()).getValues().containsKey(loc));
                new Dialog().setTitle(Messages.General_Language_choosing).setBody((Node)widget).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Choose, () -> {
                    Locale locale = widget.getValue();
                    ((L10nString)L10nTextAreaWidget.this.value.get()).getValues().put(locale, null);
                    consumer.accept(Collections.singletonList(L10nTextAreaWidget.this.createView(locale, null)));
                }).show((Node)L10nTextAreaWidget.this.groupWidget);
            }
        });
        this.groupWidget.setCallbackOnDelete(node -> {
            TextAreaWidget taWidget = (TextAreaWidget)node;
            Locale locale = this.getLocale(taWidget);
            this.groupWidget.getViews().remove(node);
            ((L10nString)this.value.get()).getValues().remove(locale);
        });
        this.getChildren().add(this.groupWidget);
        this.viewState.stateProperty().addListener(obj -> this.updateState());
        this.value.addListener(e -> this.readValue());
        this.updateState();
        this.viewState.setReadonly(ro);
    }

    public void setPrefRowCount(int val) {
        this.prefRowCount = val;
    }

    public void setPromptText(String val) {
        this.promptText = val;
    }

    public void setWrapText(boolean val) {
        this.wrapText = val;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setMonospace(boolean val) {
        this.monospace = val;
    }

    public void setNotExpandable(boolean val) {
        this.notExpandable = val;
    }

    public L10nString getValue() {
        return (L10nString)this.value.get();
    }

    public void setValue(L10nString val) {
        this.value.set((Object)val);
    }

    @Override
    public ObjectProperty<L10nString> valueProperty() {
        return this.value;
    }

    private void updateState() {
        for (TextAreaWidget view : this.groupWidget.getViews()) {
            this.updateState(view);
        }
    }

    private void updateState(TextAreaWidget taWidget) {
        taWidget.setPromptText(this.promptText);
        taWidget.setNotExpandable(this.notExpandable);
        taWidget.setMonospace(this.monospace);
        taWidget.setWrapText(this.wrapText);
        taWidget.setPrefRowCount(this.prefRowCount);
        taWidget.getViewState().setReadonly(this.viewState.isImmutable());
    }

    private Locale getLocale(TextAreaWidget taWidget) {
        return Locale.forLanguageTag(taWidget.getId());
    }

    private TextAreaWidget createView(Locale locale, String text) {
        TextAreaWidget taWidget = new TextAreaWidget(this.viewState.isReadonly());
        taWidget.setId(locale.toLanguageTag());
        taWidget.setValue(text);
        this.updateState(taWidget);
        taWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (!MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                this.updateValue(taWidget);
            }
        });
        return taWidget;
    }

    private void readValue() {
        ArrayList views = new ArrayList();
        if (this.value.get() != null) {
            Map values = ((L10nString)this.value.get()).getValues();
            values.keySet().stream().sorted(Comparator.comparing(Locale::getDisplayLanguage)).forEach(key -> views.add(this.createView((Locale)key, (String)values.get(key))));
        }
        this.groupWidget.getViews().setAll(views);
    }

    private void updateValue(TextAreaWidget taWidget) {
        Locale locale = this.getLocale(taWidget);
        ((L10nString)this.value.get()).getValues().put(locale, taWidget.getValue());
    }
}

