/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.PopupWindow;

public class MultiLingualWidget
extends GridPane
implements HasViewState,
HasValue<L10nString> {
    private final SimpleObjectProperty<L10nString> value = new SimpleObjectProperty<L10nString>(){

        public void set(L10nString nv) {
            L10nString newValue;
            try {
                newValue = (L10nString)XCloneHelper.clone((XCloneable)nv);
            }
            catch (Exception e) {
                newValue = nv;
            }
            boolean same = this.get() == nv;
            super.set((Object)newValue);
            if (same) {
                this.fireValueChangedEvent();
            }
        }
    };
    private String fieldName = "";
    private final TextFieldWidget textWidget = new TextFieldWidget(false);
    private final Button localeButton = new Button();
    private final ViewState viewState = new ViewState();
    private boolean extendedCode;

    public void setExtendedCode(boolean extendedCode) {
        this.extendedCode = extendedCode;
    }

    public MultiLingualWidget(boolean ro) {
        this.getStyleClass().addAll((Object[])new String[]{"multi-lingual-widget", "simple-widget"});
        ColumnConstraints cc = new ColumnConstraints(-1.0, -1.0, Double.MAX_VALUE);
        cc.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().add((Object)cc);
        cc = new ColumnConstraints(-1.0);
        cc.setHgrow(Priority.NEVER);
        this.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints(-1.0);
        rc.setVgrow(Priority.ALWAYS);
        rc.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)rc);
        UiUtil.setTooltip((Node)this.localeButton, Messages.General_Show_localizations);
        this.localeButton.getStyleClass().add((Object)"xtrip-button");
        this.addRow(0, new Node[]{this.textWidget, this.localeButton});
        this.turnViewMode();
        this.textWidget.controlFocusedProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                if (!this.viewState.isImmutable()) {
                    this.turnEditorMode();
                }
            } else {
                if (!this.viewState.isImmutable()) {
                    this.saveInput(this.textWidget.getValue());
                }
                this.turnViewMode();
            }
        });
        this.localeButton.setOnAction(e -> {
            if (this.viewState.isImmutable()) {
                this.showLocalesTooltip();
            } else {
                this.openLocalizationDialog();
            }
        });
        this.value.addListener(e -> this.turnViewMode());
        FxUtil.addListener(this.viewState.stateProperty(), (s, o, n) -> {
            this.textWidget.getViewState().setState(n.intValue());
            this.updateState();
        });
    }

    public void requestFocus() {
        if (this.textWidget != null) {
            this.textWidget.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<L10nString> valueProperty() {
        return this.value;
    }

    public L10nString getValue() {
        return (L10nString)this.value.get();
    }

    public void setValue(L10nString val) {
        this.value.set((Object)val);
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    private void updateState() {
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void saveInput(String input) {
        Locale locale = ClientSettings.get().getDataLocale();
        L10nString l10nString = (L10nString)this.valueProperty().get();
        if (l10nString == null) {
            if (TextUtil.isBlank((String)input)) {
                return;
            }
            l10nString = new L10nString();
            l10nString.getValues().put(locale, input.trim());
            this.valueProperty().set((Object)l10nString);
        }
        if (TextUtil.isBlank((String)input)) {
            l10nString.getValues().remove(locale);
        } else {
            l10nString.getValues().put(locale, input.trim());
        }
    }

    private void showLocalesTooltip() {
        CellsContainer ctr = new CellsContainer();
        ctr.getColumns().addAll((Object[])new CellsContainerColumn[]{new CellsContainerColumn(35.0), new CellsContainerColumn()});
        ArrayList<SimpleCell> cells = new ArrayList<SimpleCell>(10);
        cells.add(new SimpleCell(Messages.General_Language, SimpleCell.Style.CAPTION));
        cells.add(new SimpleCell(Messages.General_Value, SimpleCell.Style.CAPTION));
        if (this.valueProperty().get() != null) {
            for (Map.Entry entry : ((L10nString)this.valueProperty().get()).getValues().entrySet()) {
                cells.add(new SimpleCell(((Locale)entry.getKey()).getDisplayLanguage(), SimpleCell.Style.VALUE));
                cells.add(new SimpleCell((String)entry.getValue(), SimpleCell.Style.VALUE));
            }
        }
        ctr.getCells().addAll(cells);
        UiUtil.showPopup((PopupWindow)UiUtil.createPopup((Parent)ctr), (Region)this.localeButton);
    }

    private void openLocalizationDialog() {
        TableWidgetController<TableWidget<LocaleStringPair>, LocaleStringPair> controller = this.createTableController();
        if (this.valueProperty().get() != null) {
            controller.readData(((L10nString)this.valueProperty().get()).getValues().entrySet().stream().map(entry -> {
                LocaleStringPair pair = new LocaleStringPair();
                pair.locale = (Locale)entry.getKey();
                pair.string = (String)entry.getValue();
                return pair;
            }).collect(Collectors.toList()));
        }
        VBox body = new VBox(new Node[]{controller.getView()});
        body.getStyleClass().add((Object)"multi-lingual-dialog-body");
        SimpleBooleanProperty dialogDataChanged = new SimpleBooleanProperty();
        EventHandler actionHandler = arg_0 -> MultiLingualWidget.lambda$openLocalizationDialog$5((BooleanProperty)dialogDataChanged, controller, arg_0);
        body.addEventFilter(KeyEvent.ANY, actionHandler);
        body.addEventFilter(MouseEvent.ANY, actionHandler);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.General_Variants_localizations_of_field + " \"" + this.fieldName + "\"").setBody((Node)body).setAutoClose(false).setExpandToParent(true).setOnCloseRequest(dialog::close).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel, dialog::close).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Accept, () -> {
            ArrayList<LocaleStringPair> pairs = new ArrayList<LocaleStringPair>();
            controller.writeData(pairs);
            String message = this.validateLocalization(pairs);
            if (message != null) {
                MessagePane pane = MessagePane.error(message);
                body.getChildren().setAll((Object[])new Node[]{pane, controller.getView()});
                Notifications.get().getScheduler().schedule(() -> MultiLingualWidget.lambda$null$7(body, (Node)pane), 5L, TimeUnit.SECONDS);
                return;
            }
            L10nString l10nString = (L10nString)this.valueProperty().get();
            if (l10nString == null) {
                l10nString = new L10nString();
            }
            Map locales = l10nString.getValues();
            locales.clear();
            for (LocaleStringPair pair : pairs) {
                locales.put(pair.locale, pair.string.trim());
            }
            this.valueProperty().set((Object)l10nString);
            dialog.close();
            this.turnViewMode();
        }, (BooleanExpression)dialogDataChanged).show((Node)this.getParent());
    }

    private String validateLocalization(List<LocaleStringPair> pairs) {
        for (LocaleStringPair pair : pairs) {
            if (pair.locale != null && pair.string != null && !pair.string.trim().isEmpty()) continue;
            return Messages.General_Empty_values_unacceptable;
        }
        for (int i = 0; i < pairs.size(); ++i) {
            for (int j = 0; j < pairs.size(); ++j) {
                if (i == j || !pairs.get((int)i).locale.equals(pairs.get((int)j).locale)) continue;
                return Messages.General_Remove_doubles_of_localizations_fields;
            }
        }
        return null;
    }

    private TableWidgetController<TableWidget<LocaleStringPair>, LocaleStringPair> createTableController() {
        final TableWidget<LocaleStringPair> table = new TableWidget<LocaleStringPair>(false);
        final ValueHolder selectedLocales = new ValueHolder();
        table.setOnRowsAction((EventHandler<TableRowEvent>)((EventHandler)evt -> selectedLocales.set(null)));
        TextWidgetColumn<LocaleStringPair> translationColumn = new TextWidgetColumn<LocaleStringPair>(pair -> pair.string, (pair, str) -> {
            pair.string = str;
        });
        translationColumn.setCaption(Messages.General_Variant_of_localization);
        translationColumn.setId("value");
        table.setItemsProvider(() -> new LocaleStringPair());
        table.setColumns(Arrays.asList(new TableWidgetColumn<LocaleStringPair, LocaleValueWidget>(){
            {
                this.setCaption(Messages.General_Language);
                this.setId("locale");
                this.setPrefWidth(35.0);
            }

            @Override
            public LocaleValueWidget createNode() {
                LocaleValueWidget result = new LocaleValueWidget(false);
                result.setExtendedCode(MultiLingualWidget.this.extendedCode);
                result.setNoNulls(true);
                result.setFilter(locale -> {
                    if (selectedLocales.get() == null) {
                        selectedLocales.set(table.getRowsData().stream().filter(pair -> pair.locale != null).map(pair -> pair.locale).collect(Collectors.toSet()));
                    }
                    return !((Set)selectedLocales.get()).contains(locale);
                });
                return result;
            }

            @Override
            public void readData(LocaleStringPair model, LocaleValueWidget node) {
                node.setValue(model.locale);
            }

            @Override
            public void writeData(LocaleStringPair model, LocaleValueWidget node) {
                model.locale = node.getValue();
            }

            @Override
            public void setReadonly(LocaleValueWidget node, boolean ro) {
                node.getViewState().setReadonly(ro);
            }

            @Override
            public void setAclNotEditable(LocaleValueWidget node) {
                node.getViewState().setAclNotEditable(this.isAclNotEditable());
            }

            @Override
            public boolean isDataChanged(LocaleStringPair model, LocaleValueWidget node) {
                return !MiscUtil.equals((Object)node.getValue(), (Object)model.locale);
            }
        }, translationColumn));
        return new TableWidgetController<TableWidget<LocaleStringPair>, LocaleStringPair>(){

            @Override
            public TableWidget<LocaleStringPair> getView() {
                return table;
            }
        };
    }

    private void turnEditorMode() {
        Locale locale = ClientSettings.get().getDataLocale();
        L10nString prop = (L10nString)this.valueProperty().get();
        Map allValues = prop == null ? new HashMap() : prop.getValues();
        this.textWidget.setValue((String)allValues.get(locale));
        this.updateLocaleButton(locale);
    }

    private void turnViewMode() {
        Locale locale;
        L10nString prop = (L10nString)this.valueProperty().get();
        Map allValues = prop == null ? new HashMap() : prop.getValues();
        String text = (String)allValues.get(locale = ClientSettings.get().getDataLocale());
        if (text == null) {
            locale = ClientSettings.get().getUiLocale();
            text = (String)allValues.get(locale);
        }
        if (text == null && !allValues.isEmpty()) {
            Map.Entry entry = allValues.entrySet().iterator().next();
            locale = (Locale)entry.getKey();
            text = (String)entry.getValue();
        }
        this.textWidget.setValue(text);
        this.updateLocaleButton(text == null ? null : locale);
    }

    private void updateLocaleButton(Locale newLocale) {
        if (newLocale != null) {
            this.localeButton.setText(this.getLocaleText(newLocale));
        } else {
            this.localeButton.setText("??");
        }
    }

    private String getLocaleText(Locale newLocale) {
        return newLocale.getCountry().isEmpty() ? newLocale.getLanguage().toUpperCase() : newLocale.getCountry();
    }

    private static /* synthetic */ void lambda$null$7(VBox body, Node pane) {
        FxUtil.submitToFxThread(() -> body.getChildren().remove((Object)pane));
    }

    private static /* synthetic */ void lambda$openLocalizationDialog$5(BooleanProperty dialogDataChanged, TableWidgetController controller, InputEvent e) {
        if (!dialogDataChanged.get()) {
            dialogDataChanged.set(controller.isDataChanged());
        }
    }

    private static class LocaleStringPair {
        Locale locale;
        String string;

        LocaleStringPair() {
        }
    }
}

