/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BaseHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.HistoricalValue;
import java.math.BigDecimal;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.Node;

public class PriceHistoricalWidget
extends BaseHistoricalWidget<BigDecimal> {
    private final PriceValueWidget valueWidget;
    private boolean internalChanges = false;

    public PriceHistoricalWidget(boolean readonly) {
        this.getStyleClass().add((Object)"price-historical-widget");
        this.valueWidget = new PriceValueWidget(readonly);
        this.valueWidget.valueProperty().addListener((o, was, price) -> this.valueChanged((BigDecimal)price));
        this.init((Node)this.valueWidget, readonly);
        this.setConverter(StandardRenderers.PRICE.createStatefulConverter(this.valueWidget.getViewState()::isReadonly));
    }

    @Override
    public ViewState getViewState() {
        return this.valueWidget.getViewState();
    }

    @Override
    protected void updateCurrentValue(HistoricalValue<BigDecimal> historicalValue) {
        this.internalChanges = true;
        super.updateCurrentValue(historicalValue);
        this.valueWidget.valueProperty().set(historicalValue == null ? null : (BigDecimal)historicalValue.getValue());
        this.internalChanges = false;
    }

    @Override
    protected TableWidgetColumn<HistoricalValue<BigDecimal>, ?> createValueColumn() {
        Function<HistoricalValue, BigDecimal> getter = pair -> (BigDecimal)pair.getValue();
        BiConsumer<HistoricalValue, BigDecimal> setter = (pair, price) -> pair.setValue(price);
        PriceValueWidgetColumn<HistoricalValue<BigDecimal>> column = new PriceValueWidgetColumn<HistoricalValue<BigDecimal>>(getter, setter);
        column.setCaption(Messages.General_Value);
        column.setId("value");
        return column;
    }

    @Override
    protected void valueChanged(BigDecimal price) {
        if (!this.internalChanges) {
            super.valueChanged(price);
        }
    }
}

