/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.groups;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsSupport;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class CompactGroupsWidget<V extends Node>
extends BaseGroupsWidget<V> {
    protected final ReadOnlyObjectWrapper<V> selectedView = new ReadOnlyObjectWrapper();
    private NavPane navPane;
    protected Consumer<Node> callbackOnDelete;
    protected boolean suggestionsEnabled;

    public CompactGroupsWidget(boolean ro) {
        super(ro);
        this.getStyleClass().add((Object)"compact-groups-widget");
        this.getViews().addListener(change -> FxUtil.submitToFxThread(() -> {
            if (this.getViews().isEmpty()) {
                this.setTop(this.getPlaceholderPane());
                this.setCenter(null);
                this.selectedView.set(null);
                this.navPane = null;
                return;
            }
            if (this.navPane == null) {
                this.navPane = new NavPane();
                this.setTop((Node)this.navPane);
                this.setCenter((Node)this.navPane.contentPane);
            }
            this.navPane.updateState();
        }));
        this.setTop(this.getPlaceholderPane());
        this.getViewState().stateProperty().addListener((s, o, n) -> {
            if (this.navPane != null) {
                this.navPane.contentPane.getChildren().removeAll((Collection)this.navPane.contentPane.getChildren().stream().filter(node -> !node.isVisible()).collect(Collectors.toList()));
            }
        });
    }

    public ReadOnlyObjectProperty<V> selectedViewProperty() {
        return this.selectedView.getReadOnlyProperty();
    }

    @Override
    public V getSelectedView() {
        return (V)((Node)this.selectedView.get());
    }

    @Override
    public void selectView(V view) {
        if (this.navPane == null || view == null) {
            return;
        }
        this.navPane.selectView(view);
    }

    public void setCallbackOnDelete(Consumer<Node> callbackOnDelete) {
        this.callbackOnDelete = callbackOnDelete;
    }

    public void enableSuggestions(boolean enabled) {
        this.suggestionsEnabled = enabled;
    }

    private class NavPane
    extends BorderPane {
        protected final CustomComboBox<ValueHolder<V>> comboBox;
        final StackPane contentPane;

        NavPane() {
            Region button;
            this.getStyleClass().add((Object)"navigation-pane");
            this.contentPane = new StackPane();
            this.contentPane.getStyleClass().add((Object)"content-pane");
            this.comboBox = new CustomComboBox();
            this.comboBox.setNoNulls(true);
            this.comboBox.setButtonStyle(CustomComboBox.ButtonStyle.NAVIGATION);
            this.comboBox.setMaxWidth(Double.MAX_VALUE);
            this.comboBox.setConverter(new StringConverter<ValueHolder<V>>(){

                public String toString(ValueHolder<V> object) {
                    return CompactGroupsWidget.this.getConverter().toString(object == null ? null : (Node)object.get(), NavPane.this.comboBox.getItems().indexOf(object));
                }

                public ValueHolder<V> fromString(String string) {
                    return null;
                }
            });
            this.comboBox.valueProperty().addListener((s, o, n) -> {
                if (o != null) {
                    ((Node)o.get()).setVisible(false);
                }
                if (n == null) {
                    CompactGroupsWidget.this.selectedView.set(null);
                } else {
                    Node node = (Node)n.get();
                    if (!this.contentPane.getChildren().contains((Object)node)) {
                        this.contentPane.getChildren().add((Object)node);
                    }
                    node.setVisible(true);
                    CompactGroupsWidget.this.selectedView.set((Object)node);
                }
            });
            if (CompactGroupsWidget.this.suggestionsEnabled) {
                SuggestionsSupport.installSuggestions(this.comboBox, new SimpleSuggestionsHandler(this.comboBox, false));
            }
            UiUtil.setTooltip(this.comboBox, Messages.General_Choose_group_for_view_from_available);
            this.setCenter((Node)this.comboBox);
            ControlsPane controlsPane = new ControlsPane();
            if (CompactGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.PREV)) {
                UiUtil.setTooltip((Node)controlsPane.addButton(ControlsPane.ButtonType.PREV, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.comboBox.getSelectionModel().select(this.comboBox.getSelectionModel().getSelectedIndex() - 1)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return NavPane.this.comboBox.getSelectionModel().getSelectedIndex() < 1;
                    }
                }), Messages.General_Show_previous_group);
            }
            if (CompactGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.NEXT)) {
                UiUtil.setTooltip((Node)controlsPane.addButton(ControlsPane.ButtonType.NEXT, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.comboBox.getSelectionModel().select(this.comboBox.getSelectionModel().getSelectedIndex() + 1)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        return NavPane.this.comboBox.getSelectionModel().getSelectedIndex() >= NavPane.this.comboBox.getItems().size() - 1;
                    }
                }), Messages.General_Show_next_group);
            }
            ArrayList<Region> editButtons = new ArrayList<Region>(4);
            if (CompactGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    ValueHolder item = (ValueHolder)this.comboBox.getSelectionModel().getSelectedItem();
                    if (item != null) {
                        CompactGroupsWidget.this.doMoveDown((Node)item.get());
                    }
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        ValueHolder item = (ValueHolder)NavPane.this.comboBox.getSelectionModel().getSelectedItem();
                        return item == null || !CompactGroupsWidget.this.isMoveDownEnabled((Node)item.get());
                    }
                });
                UiUtil.setTooltip((Node)button, Messages.General_Move_group_down_to_one);
                editButtons.add(button);
            }
            if (CompactGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    ValueHolder item = (ValueHolder)this.comboBox.getSelectionModel().getSelectedItem();
                    if (item != null) {
                        CompactGroupsWidget.this.doMoveUp((Node)item.get());
                    }
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{NavPane.this.comboBox.getSelectionModel().selectedIndexProperty(), NavPane.this.comboBox.getItems()});
                    }

                    protected boolean computeValue() {
                        ValueHolder item = (ValueHolder)NavPane.this.comboBox.getSelectionModel().getSelectedItem();
                        return item == null || !CompactGroupsWidget.this.isMoveUpEnabled((Node)item.get());
                    }
                });
                UiUtil.setTooltip((Node)button, Messages.General_Move_group_up_to_one);
                editButtons.add(button);
            }
            if (CompactGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    if (CompactGroupsWidget.this.callbackOnDelete != null) {
                        CompactGroupsWidget.this.callbackOnDelete.accept((Node)CompactGroupsWidget.this.getSelectedView());
                    } else {
                        CompactGroupsWidget.this.getViews().remove(((ValueHolder)this.comboBox.getValue()).get());
                    }
                }));
                UiUtil.setTooltip((Node)button, Messages.General_Remove_group);
                editButtons.add(button);
            }
            if (CompactGroupsWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                button = ControlsPane.createButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> CompactGroupsWidget.this.getViewFactory().createAny(newViews -> {
                    if (newViews.isEmpty()) {
                        return;
                    }
                    int idx = CompactGroupsWidget.this.getViews().indexOf(((ValueHolder)this.comboBox.getValue()).get());
                    idx = idx == -1 ? CompactGroupsWidget.this.getViews().size() : ++idx;
                    CompactGroupsWidget.this.getViews().addAll(idx, newViews);
                    if (CompactGroupsWidget.this.newViewHandler != null) {
                        newViews.forEach(CompactGroupsWidget.this.newViewHandler::accept);
                    }
                    FxUtil.submitToFxThread(() -> this.selectView((Node)newViews.iterator().next()));
                })));
                UiUtil.setTooltip((Node)button, Messages.General_Add_new_group);
                editButtons.add(button);
            }
            if (!CompactGroupsWidget.this.getViewState().isImmutable()) {
                controlsPane.getChildren().addAll(editButtons);
            }
            this.setRight((Node)controlsPane);
            CompactGroupsWidget.this.getViewState().stateProperty().addListener((s, o, n) -> {
                controlsPane.getChildren().removeAll((Collection)editButtons);
                if (!CompactGroupsWidget.this.getViewState().isImmutable()) {
                    controlsPane.getChildren().addAll((Collection)editButtons);
                }
            });
        }

        void selectView(V view) {
            this.comboBox.getSelectionModel().select(CompactGroupsWidget.this.getViews().indexOf(view));
        }

        void updateState() {
            ArrayList<Node> toBeRemoved = new ArrayList<Node>();
            for (Node node : this.contentPane.getChildren()) {
                if (CompactGroupsWidget.this.getViews().contains((Object)node) && node.isVisible()) continue;
                toBeRemoved.add(node);
            }
            this.contentPane.getChildren().removeAll(toBeRemoved);
            int selected = this.comboBox.getSelectionModel().getSelectedIndex();
            this.comboBox.getItems().setAll((Collection)CompactGroupsWidget.this.getViews().stream().map(view -> new ValueHolder<Node>((Node)view)).collect(Collectors.toList()));
            if (!this.comboBox.getItems().isEmpty()) {
                this.comboBox.getSelectionModel().select(selected >= this.comboBox.getItems().size() ? this.comboBox.getItems().size() - 1 : (selected >= 0 ? selected : 0));
            }
        }
    }
}

