/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.groups;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import java.util.function.BiPredicate;
import javafx.beans.Observable;

public class StandardGroupsWidgetCoordinator {
    protected final BaseGroupsWidget<?> widget;
    protected BiPredicate<ControlsPane.ButtonType, Integer> predicate;
    private Observable[] triggers;

    StandardGroupsWidgetCoordinator(BaseGroupsWidget<?> widget) {
        this.widget = widget;
        this.triggers = new Observable[]{widget.getViewState().stateProperty(), widget.getViews()};
    }

    public boolean test(ControlsPane.ButtonType buttonType, Integer viewNumber) {
        if (this.predicate != null) {
            return this.predicate.test(buttonType, viewNumber);
        }
        if (!this.widget.controlButtonsAvailability.test(buttonType)) {
            return false;
        }
        switch (buttonType) {
            case DOWN: {
                return !this.widget.getViewState().isImmutable() && viewNumber != null && viewNumber < this.widget.getViews().size() - 1;
            }
            case UP: {
                return !this.widget.getViewState().isImmutable() && viewNumber != null && viewNumber > 0;
            }
            case REMOVE: {
                return !this.widget.getViewState().isImmutable() && viewNumber != null;
            }
            case ADD: {
                return !this.widget.getViewState().isImmutable();
            }
        }
        return true;
    }

    Observable[] getTriggers() {
        return this.triggers;
    }

    void setTriggers(Observable ... values) {
        if (values == null || values.length == 0) {
            this.triggers = new Observable[]{this.widget.getViewState().stateProperty(), this.widget.getViews()};
            return;
        }
        this.triggers = new Observable[values.length + 2];
        this.triggers[0] = this.widget.getViewState().stateProperty();
        this.triggers[1] = this.widget.getViews();
        System.arraycopy(values, 0, this.triggers, 2, values.length);
    }

    void setPredicate(BiPredicate<ControlsPane.ButtonType, Integer> predicate) {
        this.predicate = predicate;
    }
}

