/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.multi;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValues;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public abstract class BaseMultiWidget<T>
extends StackPane
implements HasViewState,
HasValues<T> {
    private static final int LIMIT = 5;
    private final ObservableList<T> values = FXCollections.observableArrayList();
    private String fieldName;
    protected final ViewState viewState = new ViewState();
    private Predicate<ControlsPane.ButtonType> controlButtonsAvailability = ControlsPane.ADD_REMOVE;
    private PlaceholderPane placeholderPane;
    protected GridPane gridPane;
    private static final ObservableValue<Object> NULL_OBJECT_WRAPPER = new ReadOnlyObjectWrapper();

    static <T> void massiveAdd(BaseMultiWidget<T> widget, Supplier<Collection<T>> newValuesSupplier) {
        Notifications.get().submitTask(() -> {
            Collection values = (Collection)newValuesSupplier.get();
            FxUtil.submitToFxThread(() -> {
                if (values.size() <= 200) {
                    widget.getValues().setAll(values);
                } else {
                    Dialog.confirm(Dialog.getGlobalWindow(), Messages.getMassive_add_confirmation(values.size()), null, Messages.Massive_add_button, () -> widget.getValues().setAll(values), null);
                }
            });
        }, Messages.General_Data_loading);
    }

    protected BaseMultiWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.getStyleClass().addAll((Object[])new String[]{"multi-widget", "table-widget"});
        this.viewState.stateProperty().addListener(obj -> this.reflow());
        this.values.addListener(change -> this.reflow());
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.reflow();
            }
        });
    }

    @Override
    public ObservableList<T> getValues() {
        return this.values;
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setControlButtonsAvailability(Predicate<ControlsPane.ButtonType> value) {
        this.controlButtonsAvailability = Objects.requireNonNull(value);
    }

    private void reflow() {
        if (this.getScene() == null) {
            return;
        }
        if (this.values.isEmpty()) {
            if (this.placeholderPane == null) {
                this.placeholderPane = new PlaceholderPane();
                this.placeholderPane.setPlaceholder(new Label(Messages.General_No_entries));
                if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                    ControlsPane controlsPane = new ControlsPane();
                    controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.addNew(0)));
                    controlsPane.visibleProperty().bind((ObservableValue)new BooleanBinding(){
                        {
                            this.bind(new Observable[]{BaseMultiWidget.this.viewState.stateProperty()});
                        }

                        protected boolean computeValue() {
                            return !BaseMultiWidget.this.viewState.isImmutable();
                        }
                    });
                    this.placeholderPane.setControlsPane(controlsPane);
                }
            }
            this.getChildren().setAll((Object[])new Node[]{this.placeholderPane});
            this.gridPane = null;
            return;
        }
        boolean withControls = !this.viewState.isImmutable();
        int size = this.isLimited() && this.values.size() > 5 ? 5 : this.values.size();
        ArrayList<Object> nodes = new ArrayList<Object>((withControls ? size * 2 : size) + 1);
        for (int row = 0; row < size; ++row) {
            boolean bottom = row == size - 1 && size == this.values.size();
            Node node = this.createNode(row);
            node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            node.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, row == 0);
            node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, !withControls);
            node.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, bottom);
            GridPane.setConstraints((Node)node, (int)0, (int)row);
            nodes.add(node);
            if (!withControls) continue;
            node = this.createControlsPanel(row);
            node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, row == 0);
            node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
            node.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, bottom);
            GridPane.setConstraints((Node)node, (int)1, (int)row);
            nodes.add(node);
        }
        if (size < this.values.size()) {
            CustomLabel label = new CustomLabel(String.format(Messages.getDisplayed_number(size, this.values.size()), new Object[0]));
            HyperlinkWidget link = new HyperlinkWidget();
            link.setText(Messages.Full_list_link);
            link.setOnAction(evt -> this.showFullDataDialog());
            HBox box = new HBox(new Node[]{label, link});
            box.getStyleClass().add((Object)"overflow-pane");
            GridPane.setConstraints((Node)box, (int)0, (int)size);
            if (withControls) {
                GridPane.setColumnSpan((Node)box, (Integer)2);
            }
            box.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
            box.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
            box.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, true);
            nodes.add(box);
        }
        this.placeholderPane = null;
        if (this.gridPane == null) {
            this.createGridPane();
        }
        this.gridPane.getColumnConstraints().setAll(this.buildConstraints(withControls));
        this.gridPane.getChildren().setAll(nodes);
        this.getChildren().setAll((Object[])new Node[]{this.gridPane});
    }

    private Node createControlsPanel(final int idx) {
        ControlsPane result = new ControlsPane();
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
            Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                this.gridPane.requestFocus();
                FxUtil.swap(this.values, idx, idx + 1);
            }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                {
                    this.bind(new Observable[]{BaseMultiWidget.this.viewState.stateProperty()});
                }

                protected boolean computeValue() {
                    return idx == BaseMultiWidget.this.getValues().size() - 1;
                }
            }), (Tooltip)new Tooltip(Messages.General_Move_line_down_to_one));
        }
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
            Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                this.gridPane.requestFocus();
                FxUtil.swap(this.values, idx - 1, idx);
            }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                {
                    this.bind(new Observable[]{BaseMultiWidget.this.viewState.stateProperty()});
                }

                protected boolean computeValue() {
                    return idx == 0;
                }
            }), (Tooltip)new Tooltip(Messages.General_Move_line_up_to_one));
        }
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
            Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                this.gridPane.requestFocus();
                this.values.remove(idx);
            }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                {
                    this.bind(new Observable[]{BaseMultiWidget.this.viewState.stateProperty()});
                }

                protected boolean computeValue() {
                    return false;
                }
            }), (Tooltip)new Tooltip(Messages.General_Remove_line));
        }
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
            Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                this.gridPane.requestFocus();
                this.addNew(idx + 1);
            }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                {
                    this.bind(new Observable[]{BaseMultiWidget.this.viewState.stateProperty()});
                }

                protected boolean computeValue() {
                    return false;
                }
            }), (Tooltip)new Tooltip(Messages.General_Add_new_line_after_this));
        }
        return result;
    }

    private List<ColumnConstraints> buildConstraints(boolean withControls) {
        ArrayList<ColumnConstraints> result = new ArrayList<ColumnConstraints>();
        ColumnConstraints cc = new ColumnConstraints();
        cc.setMaxWidth(Double.MAX_VALUE);
        cc.setHgrow(Priority.ALWAYS);
        result.add(cc);
        if (withControls) {
            cc = new ColumnConstraints();
            cc.setHgrow(Priority.NEVER);
            result.add(cc);
        }
        return result;
    }

    private void showFullDataDialog() {
        CustomTableView tableView = new CustomTableView();
        this.configureFullDataTable(tableView);
        FilteredList list = new FilteredList(this.values);
        tableView.setItems((ObservableList)list);
        SearchTextField searchField = new SearchTextField();
        searchField.textProperty().addListener((s, o, n) -> {
            Predicate<Object> predicate;
            if (TextUtil.isBlank((String)n)) {
                predicate = null;
            } else {
                String pattern = n.trim().toLowerCase();
                predicate = item -> StandardRenderers.toString(item).toLowerCase().contains(pattern);
            }
            list.setPredicate(predicate);
        });
        VBox box = new VBox(new Node[]{searchField, tableView});
        box.getStyleClass().add((Object)"multi-widget-full-pane");
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.getFull_list_title(this.getFieldName())).setBody((Node)box).setAutoClose(false).setOnCloseRequest(dialog::close).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close, dialog::close);
        if (!this.viewState.isImmutable()) {
            dialog.addButton(DialogButtonStyle.AUXILARY, Messages.Full_list_deleteSelected, () -> this.values.removeAll((Collection)tableView.getSelectionModel().getSelectedItems()), (BooleanExpression)Bindings.isNotEmpty((ObservableList)tableView.getSelectionModel().getSelectedItems()));
        }
        dialog.show((Node)this);
    }

    protected void createGridPane() {
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"grid-frame");
    }

    protected void configureFullDataTable(CustomTableView<T> tableView) {
        TableColumnSettings col = new TableColumnSettings();
        col.setId("title");
        col.setDisplayName(Messages.Full_list_column);
        col.setSortable(false);
        tableView.getColumns().add(col.createColumn(item -> StandardRenderers.toString(item)));
        tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        tableView.setOnKeyReleased(evt -> {
            if (evt.getCode() == KeyCode.DELETE && !this.viewState.isImmutable()) {
                this.values.removeAll((Collection)tableView.getSelectionModel().getSelectedItems());
            } else if (UiUtil.KEY_COMBINATION_COPY.match(evt)) {
                String text = tableView.getSelectionModel().getSelectedItems().stream().map(item -> StandardRenderers.toString(item)).collect(Collectors.joining("\n"));
                Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, text));
                Notifications.get().showFlashNotification(Messages.Full_list_copyDone, null);
            }
        });
        if (!this.viewState.isReadonly()) {
            TableColumn reorderingColumnSettings = new TableColumn();
            reorderingColumnSettings.setMinWidth(60.0);
            reorderingColumnSettings.setPrefWidth(60.0);
            reorderingColumnSettings.setMaxWidth(60.0);
            reorderingColumnSettings.setSortable(false);
            reorderingColumnSettings.setResizable(false);
            reorderingColumnSettings.setCellValueFactory(param -> {
                Object item = param.getValue();
                if (item == null) {
                    return NULL_OBJECT_WRAPPER;
                }
                return new ReadOnlyObjectWrapper(item);
            });
            reorderingColumnSettings.setCellFactory(param -> new TableCell<T, Object>(){
                private ControlsPane pane;
                private SimpleBooleanProperty upDisabled;
                private SimpleBooleanProperty downDisabled;

                protected void updateItem(Object item, boolean empty) {
                    int vi;
                    super.updateItem(item, empty);
                    this.setText(null);
                    if (empty) {
                        this.setGraphic(null);
                        return;
                    }
                    if (this.pane == null) {
                        this.upDisabled = new SimpleBooleanProperty();
                        this.downDisabled = new SimpleBooleanProperty();
                        this.pane = new ControlsPane();
                        this.pane.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                            ObservableList values = BaseMultiWidget.this.getValues();
                            Object value = this.getTableRow().getItem();
                            int idx = values.indexOf(value);
                            FxUtil.swap(values, idx, idx - 1);
                        }), (ObservableValue<? extends Boolean>)this.upDisabled);
                        this.pane.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                            ObservableList values = BaseMultiWidget.this.getValues();
                            Object value = this.getTableRow().getItem();
                            int idx = values.indexOf(value);
                            FxUtil.swap(values, idx, idx + 1);
                        }), (ObservableValue<? extends Boolean>)this.downDisabled);
                    }
                    this.upDisabled.set((vi = BaseMultiWidget.this.getValues().indexOf(item)) == 0);
                    this.downDisabled.set(vi == BaseMultiWidget.this.getValues().size() - 1);
                    this.setGraphic((Node)this.pane);
                }
            });
            tableView.getColumns().add((Object)reorderingColumnSettings);
        }
    }

    protected boolean isLimited() {
        return false;
    }

    protected abstract Node createNode(int var1);

    protected abstract void addNew(int var1);
}

