/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.multitable;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multitable.MultiTableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class MultiTableWidget<D, T extends Identity>
extends BorderPane
implements HasViewState,
DevTool {
    protected final ViewState viewState = new ViewState();
    protected MultiTableHandler<D, T> handler;
    protected Node placeholderNode;
    protected GridPane dataPane;
    protected HeaderSet<D, T> headerSet;
    private final ObservableList<TableSet<D, T>> tableSets = FXCollections.observableArrayList();
    private boolean changed = false;
    private int reflowCounter = 0;

    public MultiTableWidget(boolean readonly) {
        this.viewState.setReadonly(readonly);
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        this.getStyleClass().addAll((Object[])new String[]{"multi-table-widget", "table-widget"});
        PlaceholderPane placeholderPane = new PlaceholderPane();
        placeholderPane.setPlaceholder(new CustomLabel(Messages.General_No_entries));
        this.placeholderNode = new StackPane(new Node[]{placeholderPane});
        this.placeholderNode.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
        this.dataPane = new GridPane();
        this.dataPane.getStyleClass().add((Object)"grid-frame");
        this.setCenter((Node)this.dataPane);
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
            this.headerSet.getViewState().setReadonly(readonly);
            for (TableSet tableSet : this.tableSets) {
                tableSet.getViewState().setReadonly(readonly);
            }
        }, notEditable -> {
            this.headerSet.getViewState().setNotEditable(notEditable);
            for (TableSet tableSet : this.tableSets) {
                tableSet.getViewState().setNotEditable(notEditable);
            }
        }, aclNotEditable -> {
            this.headerSet.getViewState().setAclNotEditable(aclNotEditable);
            for (TableSet tableSet : this.tableSets) {
                tableSet.getViewState().setAclNotEditable(aclNotEditable);
            }
        }, aclNotViewable -> {
            this.headerSet.getViewState().setAclNotViewable(aclNotViewable);
            for (TableSet tableSet : this.tableSets) {
                tableSet.getViewState().setAclNotViewable(aclNotViewable);
            }
        }, aclNotCreatable -> {
            this.headerSet.getViewState().setAclNotCreatable(aclNotCreatable);
            for (TableSet tableSet : this.tableSets) {
                tableSet.getViewState().setAclNotCreatable(aclNotCreatable);
            }
        }, aclNotDeletable -> {
            this.headerSet.getViewState().setAclNotDeletable(aclNotDeletable);
            for (TableSet tableSet : this.tableSets) {
                tableSet.getViewState().setAclNotDeletable(aclNotDeletable);
            }
        })));
        this.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.reflow();
            }
        });
    }

    public void setHandler(MultiTableHandler<D, T> handler) {
        this.handler = Objects.requireNonNull(handler);
        this.headerSet = new HeaderSet<D, T>(this, handler, this.viewState.getState());
        this.tableSets.clear();
        EventHandler<MultiTableRowEvent> eventHandler = handler.createEventHandler();
        if (eventHandler != null) {
            this.setEventHandler(MultiTableRowEvent.ROW_ANY, eventHandler);
        }
        this.reflow();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public List<TableSet<D, T>> getTableSets() {
        return FXCollections.unmodifiableObservableList(this.tableSets);
    }

    public boolean isDataChanged() {
        if (this.viewState.isImmutable()) {
            return false;
        }
        if (this.changed) {
            return true;
        }
        for (TableSet tableSet : this.tableSets) {
            if (!tableSet.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    public void readData(D model) {
        this.reflowAdvice(() -> {
            ArrayList<T> tableSetModels = new ArrayList<T>(this.handler.getTableSets(model));
            this.tableSets.clear();
            for (Identity tableSetModel : tableSetModels) {
                TableSet<D, Identity> tableSet = new TableSet<D, Identity>(this, this.handler, tableSetModel, this.viewState.getState());
                this.tableSets.add(tableSet);
                tableSet.readData();
            }
            this.changed = false;
        });
    }

    public void writeData(D model) {
        for (TableSet tableSet : this.tableSets) {
            tableSet.writeData();
        }
        List tableSetModels = this.tableSets.stream().map(item -> item.model).collect(Collectors.toList());
        this.handler.setTableSets(model, tableSetModels);
        this.changed = false;
    }

    protected void reflow() {
        if (this.getScene() == null) {
            return;
        }
        if (this.dataPane == null) {
            this.dataPane = new GridPane();
            this.dataPane.getStyleClass().add((Object)"grid-frame");
        }
        this.dataPane.getColumnConstraints().clear();
        this.dataPane.getChildren().clear();
        if (this.tableSets.size() > 0) {
            int offset = 0;
            this.headerSet.reflow(0, offset, !this.viewState.isImmutable());
            offset += this.headerSet.getHeight();
            for (TableSet tableSet : this.tableSets) {
                tableSet.reflow(0, offset, !this.viewState.isImmutable());
                offset += tableSet.getHeight();
            }
        } else {
            ColumnConstraints constraints = new ColumnConstraints();
            constraints.setHgrow(Priority.ALWAYS);
            this.dataPane.getColumnConstraints().add((Object)constraints);
            GridPane.setConstraints((Node)this.placeholderNode, (int)0, (int)0);
            this.dataPane.getChildren().add((Object)this.placeholderNode);
        }
    }

    protected void reflowAdvice(Runnable runnable) {
        try {
            ++this.reflowCounter;
            if (runnable != null) {
                runnable.run();
            }
        }
        finally {
            --this.reflowCounter;
            if (this.reflowCounter == 0) {
                this.reflow();
            }
        }
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.unmodifiableList(MultiTableWidget.this.tableSets);
            }

            @Override
            public String getInfo() {
                return MultiTableWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(MultiTableWidget.this.viewState);
            }
        };
    }

    public static class Wrapper<D>
    implements Identity {
        private final String uid;
        private final D delegate;

        public static <D> Wrapper<D> of(String uid, D delegate) {
            return new Wrapper<D>(uid, delegate);
        }

        private Wrapper(String uid, D delegate) {
            this.uid = uid;
            this.delegate = delegate;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            throw new UnsupportedOperationException();
        }

        public D getDelegate() {
            return this.delegate;
        }
    }

    public static class Row<D, T extends Identity, R extends Identity>
    implements HasViewState {
        protected final ViewState viewState = new ViewState();
        final MultiTableWidget<D, T> widget;
        final Table<D, T, R> table;
        final R model;
        private final List<Node> nodes = new ArrayList<Node>();
        private ControlsPane controlsPane;

        Row(MultiTableWidget<D, T> widget, Table<D, T, R> table, R model, int state) {
            this.widget = widget;
            this.table = table;
            this.model = model;
            this.viewState.setState(state);
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            for (TableWidgetColumn column : this.table.columns) {
                Object node = column.createNode();
                node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
                this.nodes.add((Node)node);
            }
            this.controlsPane = new ControlsPane();
            this.controlsPane.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            Predicate<ControlsPane.ButtonType> controlButtonsAvailability = this.table.handler.getControlButtonsAvailability();
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                    int index = this.table.rows.indexOf((Object)this);
                    this.table.model.remove(this.model);
                    this.table.model.add(index + 1, this.model);
                    this.table.rows.remove((Object)this);
                    this.table.rows.add(index + 1, (Object)this);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), table.rows});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || table.rows.indexOf((Object)this) == table.rows.size() - 1;
                    }
                }), (Tooltip)new Tooltip(Messages.General_Move_line_down_to_one));
            }
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                    int index = this.table.rows.indexOf((Object)this);
                    this.table.model.remove(this.model);
                    this.table.model.add(index - 1, this.model);
                    this.table.rows.remove((Object)this);
                    this.table.rows.add(index - 1, (Object)this);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), table.rows});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || table.rows.indexOf((Object)this) == 0;
                    }
                }), (Tooltip)new Tooltip(Messages.General_Move_line_up_to_one));
            }
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)event -> {
                    this.table.model.remove(this.model);
                    this.table.rows.remove((Object)this);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), viewState.stateProperty()});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || viewState.isAclNotDeletable();
                    }
                }), (Tooltip)new Tooltip(Messages.General_Remove_line));
            }
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                Tooltip.install((Node)this.controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> this.table.handler.getItemsProvider().createAny(createdItems -> {
                    int index = this.table.rows.indexOf((Object)this);
                    List createdRows = createdItems.stream().map(item -> new Row<D, T, Identity>(this.widget, this.table, (Identity)item, 0)).collect(Collectors.toList());
                    for (Row createdRow : createdRows) {
                        createdRow.readData();
                    }
                    this.table.model.addAll(index + 1, createdItems);
                    this.table.rows.addAll(index + 1, createdRows);
                })), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{table.getViewState().stateProperty(), viewState.stateProperty()});
                    }

                    protected boolean computeValue() {
                        return table.getViewState().isImmutable() || viewState.isAclNotCreatable();
                    }
                }), (Tooltip)new Tooltip(Messages.General_Add_new_line_after_this));
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
                for (Node node : this.nodes) {
                    if (!(node instanceof HasViewState)) continue;
                    ((HasViewState)node).getViewState().setReadonly(readonly);
                }
            }, notEditable -> {
                for (Node node : this.nodes) {
                    if (!(node instanceof HasViewState)) continue;
                    ((HasViewState)node).getViewState().setNotEditable(notEditable);
                }
            }, aclNotEditable -> {
                for (Node node : this.nodes) {
                    if (!(node instanceof HasViewState)) continue;
                    ((HasViewState)node).getViewState().setAclNotEditable(aclNotEditable);
                }
            }, aclNotViewable -> {
                for (Node node : this.nodes) {
                    node.setVisible(!aclNotViewable);
                }
                this.widget.fireEvent(new MultiTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends MultiTableRowEvent>)MultiTableRowEvent.ROW_ANY, this));
            }, aclNotCreatable -> {}, aclNotDeletable -> {})));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        public String getId() {
            return this.model.getUid();
        }

        public Table<D, T, R> getTable() {
            return this.table;
        }

        public <N extends Node> N getWidget(String id) {
            int index = this.table.rows.indexOf((Object)this);
            for (TableWidgetColumn column : this.table.columns) {
                if (!MiscUtil.equals((Object)id, (Object)column.getId())) continue;
                return (N)column.getWidget(index);
            }
            throw new IllegalArgumentException("invalid column id " + id);
        }

        boolean isDataChanged() {
            for (int i = 0; i < this.table.columns.size(); ++i) {
                Node node;
                TableWidgetColumn column = this.table.columns.get(i);
                if (!column.isDataChanged(this.model, node = this.nodes.get(i))) continue;
                return true;
            }
            return false;
        }

        void readData() {
            this.widget.reflowAdvice(() -> {
                for (int i = 0; i < this.table.columns.size(); ++i) {
                    TableWidgetColumn column = this.table.columns.get(i);
                    Node node = this.nodes.get(i);
                    column.readData(this.model, node);
                }
            });
        }

        void writeData() {
            for (int i = 0; i < this.table.columns.size(); ++i) {
                TableWidgetColumn column = this.table.columns.get(i);
                Node node = this.nodes.get(i);
                column.writeData(this.model, node);
            }
        }

        void reflow(int x, int y, boolean useControls) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (this.nodes.get(i).isVisible()) {
                    Node node = this.nodes.get(i);
                    GridPane.setConstraints((Node)node, (int)(x + i), (int)y);
                    this.widget.dataPane.getChildren().add((Object)node);
                    continue;
                }
                CustomLabel label = new CustomLabel(Messages.hidden);
                StackPane node = new StackPane();
                node.getStyleClass().addAll((Object[])new String[]{"row-cell", "acl-not-viewable-cell", "grid-cell"});
                GridPane.setConstraints((Node)node, (int)(x + i), (int)y);
                node.getChildren().add((Object)label);
                this.widget.dataPane.getChildren().add((Object)node);
            }
            if (useControls) {
                GridPane.setConstraints((Node)this.controlsPane, (int)(x + this.nodes.size()), (int)y);
                this.widget.dataPane.getChildren().add((Object)this.controlsPane);
            }
        }
    }

    public static class Table<D, T extends Identity, R extends Identity>
    implements HasViewState,
    DevTool {
        protected final ViewState viewState = new ViewState();
        final MultiTableWidget<D, T> widget;
        final TableSet<D, T> tableSet;
        final TableHandler<T, R> handler;
        final List<R> model;
        final String title;
        final List<TableWidgetColumn<R, ?>> columns = new ArrayList();
        final ObservableList<Row<D, T, R>> rows = FXCollections.observableArrayList();
        private GridPane titlePane;
        private Node summaryNode;
        private Node placeholderNode;
        private ControlsPane controlsPane;
        private final TableColumnOwner<R> asOwner = new TableColumnOwner<R>(){

            @Override
            public ViewState getViewState() {
                return viewState;
            }

            @Override
            public int indexOfRow(Node node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <N extends Node> N getWidget(TableWidgetColumn<R, N> column, int index) {
                Row row = (Row)rows.get(index);
                return (N)((Node)row.nodes.get(columns.indexOf(column)));
            }

            @Override
            public void injectWidget(int row, Node widget) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void ejectWidget(int row) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getRowsCount() {
                throw new UnsupportedOperationException();
            }
        };

        Table(MultiTableWidget<D, T> widget, TableSet<D, T> tableSet, TableHandler<T, R> handler, List<R> model, String title, int state) {
            this.widget = widget;
            this.tableSet = tableSet;
            this.handler = handler;
            this.model = model;
            this.title = title;
            this.viewState.setState(state);
            this.columns.clear();
            this.columns.addAll(handler.getColumns());
            for (TableWidgetColumn<R, ?> column : this.columns) {
                column.setOwner(this.asOwner);
            }
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            this.titlePane = new GridPane();
            this.titlePane.getStyleClass().addAll((Object[])new String[]{"row-cell", "summary-cell", "grid-cell"});
            ColumnConstraints titleColumnConstraints = new ColumnConstraints();
            titleColumnConstraints.setHgrow(Priority.ALWAYS);
            ColumnConstraints amountColumnConstraints = new ColumnConstraints();
            amountColumnConstraints.setHgrow(Priority.NEVER);
            this.titlePane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{titleColumnConstraints, amountColumnConstraints});
            CustomLabel titleNode = new CustomLabel(this.title);
            GridPane.setConstraints((Node)titleNode, (int)0, (int)0);
            this.titlePane.getChildren().add((Object)titleNode);
            this.summaryNode = this.handler.createSummaryNode();
            if (this.summaryNode != null) {
                GridPane.setConstraints((Node)this.summaryNode, (int)1, (int)0);
                this.titlePane.getChildren().add((Object)this.summaryNode);
            }
            PlaceholderPane placeholderPane = new PlaceholderPane();
            placeholderPane.setPlaceholder(new CustomLabel(Messages.General_No_entries));
            this.placeholderNode = new StackPane(new Node[]{placeholderPane});
            this.placeholderNode.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            this.controlsPane = new ControlsPane();
            this.controlsPane.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            Predicate<ControlsPane.ButtonType> controlButtonsAvailability = this.handler.getControlButtonsAvailability();
            if (controlButtonsAvailability != null && controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                this.controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)event -> this.handler.getItemsProvider().createAny(createdItems -> {
                    List createdRows = createdItems.stream().map(item -> new Row<D, T, Identity>(this.widget, this, (Identity)item, 0)).collect(Collectors.toList());
                    for (Row createdRow : createdRows) {
                        createdRow.readData();
                    }
                    this.model.addAll(0, (Collection<R>)createdItems);
                    this.rows.addAll(0, createdRows);
                })), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{viewState.stateProperty()});
                    }

                    protected boolean computeValue() {
                        return viewState.isImmutable() || viewState.isAclNotCreatable();
                    }
                });
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
                for (Row row : this.rows) {
                    row.getViewState().setReadonly(readonly);
                }
            }, notEditable -> {
                for (Row row : this.rows) {
                    row.getViewState().setNotEditable(notEditable);
                }
            }, aclNotEditable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotEditable(aclNotEditable);
                }
            }, aclNotViewable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotViewable(aclNotViewable);
                }
            }, aclNotCreatable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotCreatable(aclNotCreatable);
                }
            }, aclNotDeletable -> {
                for (Row row : this.rows) {
                    row.getViewState().setAclNotDeletable(aclNotDeletable);
                }
            })));
            this.rows.addListener(change -> this.widget.reflowAdvice(() -> {
                ((MultiTableWidget)this.widget).changed = true;
                ArrayList events = new ArrayList();
                while (change.next()) {
                    if (change.wasPermutated() || change.wasUpdated()) {
                        events.addAll(IntStream.range(change.getFrom(), change.getTo()).mapToObj(index -> new MultiTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends MultiTableRowEvent>)MultiTableRowEvent.ROW_ANY, (Row)this.rows.get(index))).collect(Collectors.toList()));
                        continue;
                    }
                    events.addAll(change.getAddedSubList().stream().map(item -> new MultiTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends MultiTableRowEvent>)MultiTableRowEvent.ROW_ADD, (Row<?, ?, ?>)item)).collect(Collectors.toList()));
                    events.addAll(change.getRemoved().stream().map(item -> new MultiTableRowEvent(this.widget, (EventTarget)this.widget, (EventType<? extends MultiTableRowEvent>)MultiTableRowEvent.ROW_REMOVE, (Row<?, ?, ?>)item)).collect(Collectors.toList()));
                }
                for (MultiTableRowEvent event : events) {
                    this.widget.fireEvent(event);
                }
            }));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        public String getId() {
            return this.handler.getId();
        }

        public TableSet<D, T> getTableSet() {
            return this.tableSet;
        }

        public Node getSummaryNode() {
            return this.summaryNode;
        }

        public List<Row<D, T, R>> getRows() {
            return FXCollections.unmodifiableObservableList(this.rows);
        }

        public TableWidgetColumn<R, ?> getColumn(String id) {
            for (TableWidgetColumn<R, ?> column : this.columns) {
                if (!MiscUtil.equals((Object)id, (Object)column.getId())) continue;
                return column;
            }
            throw new IllegalArgumentException("invalid column ID " + id);
        }

        boolean isDataChanged() {
            for (Row row : this.rows) {
                if (!row.isDataChanged()) continue;
                return true;
            }
            return false;
        }

        void readData() {
            this.widget.reflowAdvice(() -> {
                for (Identity rowModel : this.model) {
                    Row<D, T, Identity> row = new Row<D, T, Identity>(this.widget, this, rowModel, this.viewState.getState());
                    this.rows.add(row);
                    row.readData();
                }
            });
        }

        void writeData() {
            for (Row row : this.rows) {
                row.writeData();
            }
            this.handler.setRows(this.tableSet.model, this.model);
        }

        void reflow(int x, int y, int height, boolean useControls, boolean useTitle) {
            int width = this.getWidth();
            if (useControls) {
                ++width;
            }
            for (int i = 0; i < height; ++i) {
                StackPane node;
                CustomLabel label;
                if (useTitle && i == 0) {
                    GridPane.setColumnSpan((Node)this.titlePane, (Integer)(useControls ? width - 1 : width));
                    GridPane.setConstraints((Node)this.titlePane, (int)x, (int)(y + i));
                    this.widget.dataPane.getChildren().add((Object)this.titlePane);
                    if (!useControls) continue;
                    label = new CustomLabel();
                    node = new StackPane(new Node[]{label});
                    node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
                    GridPane.setConstraints((Node)node, (int)(x + (width - 1)), (int)(y + i));
                    this.widget.dataPane.getChildren().add((Object)node);
                    continue;
                }
                if (i == (useTitle ? 1 : 0) && this.rows.size() == 0) {
                    GridPane.setColumnSpan((Node)this.placeholderNode, (Integer)(useControls ? width - 1 : width));
                    GridPane.setConstraints((Node)this.placeholderNode, (int)x, (int)(y + i));
                    this.widget.dataPane.getChildren().add((Object)this.placeholderNode);
                    if (!useControls) continue;
                    GridPane.setConstraints((Node)this.controlsPane, (int)(x + (width - 1)), (int)(y + i));
                    this.widget.dataPane.getChildren().add((Object)this.controlsPane);
                    continue;
                }
                if (i - (useTitle ? 1 : 0) < this.rows.size()) {
                    Row row = (Row)this.rows.get(i - (useTitle ? 1 : 0));
                    row.reflow(x, y + i, useControls);
                    continue;
                }
                label = new CustomLabel();
                node = new StackPane(new Node[]{label});
                node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
                GridPane.setColumnSpan((Node)node, (Integer)width);
                GridPane.setConstraints((Node)node, (int)x, (int)(y + i));
                this.widget.dataPane.getChildren().add((Object)node);
            }
        }

        int getWidth() {
            return this.columns.size();
        }

        int getHeight() {
            return (this.isUseTitle() ? 1 : 0) + (this.rows.size() > 0 ? this.rows.size() : 1);
        }

        boolean isUseControls() {
            return !this.viewState.isImmutable();
        }

        boolean isUseTitle() {
            return this.title != null && this.summaryNode != null;
        }

        @Override
        public DevToolItem asDevToolItem() {
            return new DevToolItem(){

                @Override
                public Collection<?> getSubItems() {
                    return Collections.unmodifiableList(columns);
                }

                @Override
                public String getInfo() {
                    return this.getClass().getSimpleName() + DevTools.getViewStateInfo(viewState);
                }
            };
        }
    }

    public static class TableSet<D, T extends Identity>
    implements HasViewState,
    DevTool {
        protected final ViewState viewState = new ViewState();
        final MultiTableWidget<D, T> widget;
        final MultiTableHandler<D, T> handler;
        final T model;
        final ObservableList<Table<D, T, ?>> tables = FXCollections.observableArrayList();

        TableSet(MultiTableWidget<D, T> widget, MultiTableHandler<D, T> handler, T model, int state) {
            this.widget = widget;
            this.handler = handler;
            this.model = model;
            this.viewState.setState(state);
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
                for (Table table : this.tables) {
                    table.getViewState().setReadonly(readonly);
                }
            }, notEditable -> {
                for (Table table : this.tables) {
                    table.getViewState().setNotEditable(notEditable);
                }
            }, aclNotEditable -> {
                for (Table table : this.tables) {
                    table.getViewState().setAclNotEditable(aclNotEditable);
                }
            }, aclNotViewable -> {
                for (Table table : this.tables) {
                    table.getViewState().setAclNotViewable(aclNotViewable);
                }
            }, aclNotCreatable -> {
                for (Table table : this.tables) {
                    table.getViewState().setAclNotCreatable(aclNotCreatable);
                }
            }, aclNotDeletable -> {
                for (Table table : this.tables) {
                    table.getViewState().setAclNotDeletable(aclNotDeletable);
                }
            })));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        public String getId() {
            return this.model.getUid();
        }

        public List<Table<D, T, ?>> getTables() {
            return FXCollections.unmodifiableObservableList(this.tables);
        }

        boolean isDataChanged() {
            for (Table table : this.tables) {
                if (!table.isDataChanged()) continue;
                return true;
            }
            return false;
        }

        void readData() {
            this.widget.reflowAdvice(() -> {
                List<TableHandler<T, ?>> handlers = this.handler.getHandlers();
                for (TableHandler<T, ?> handler : handlers) {
                    ArrayList rows = new ArrayList(handler.getRows(this.model));
                    String title = handler.getTitle(this.model);
                    Table table = new Table(this.widget, this, handler, rows, title, this.viewState.getState());
                    this.tables.add(table);
                    table.readData();
                }
            });
        }

        void writeData() {
            for (Table table : this.tables) {
                table.writeData();
            }
        }

        public void reflow(int x, int y, boolean useControls) {
            int height = this.getHeight();
            boolean useTitle = this.isUseTitle();
            int offset = x;
            for (int i = 0; i < this.tables.size(); ++i) {
                Table table = (Table)this.tables.get(i);
                table.reflow(x + offset, y, height, useControls, useTitle);
                offset += table.getWidth();
                if (useControls) {
                    ++offset;
                }
                if (i >= this.tables.size() - 1) continue;
                StackPane node = new StackPane(new Node[]{new CustomLabel()});
                node.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
                GridPane.setRowSpan((Node)node, (Integer)height);
                GridPane.setConstraints((Node)node, (int)(x + offset), (int)y);
                this.widget.dataPane.getChildren().add((Object)node);
                ++offset;
            }
        }

        int getHeight() {
            return this.tables.stream().mapToInt(item -> item.getHeight()).max().orElse(0);
        }

        boolean isUseTitle() {
            return this.tables.stream().anyMatch(item -> item.isUseTitle());
        }

        @Override
        public DevToolItem asDevToolItem() {
            return new DevToolItem(){

                @Override
                public Collection<?> getSubItems() {
                    return Collections.unmodifiableList(tables);
                }

                @Override
                public String getInfo() {
                    return this.getClass().getSimpleName() + DevTools.getViewStateInfo(viewState);
                }
            };
        }
    }

    public static class Header<D, T extends Identity, R extends Identity>
    implements HasViewState {
        protected final ViewState viewState = new ViewState();
        final MultiTableWidget<D, T> widget;
        final HeaderSet<D, T> headerSet;
        final TableHandler<T, R> handler;
        final List<TableWidgetColumn<R, ?>> columns = new ArrayList();
        private final List<MiscUtil.Pair<ColumnConstraints, Node>> nodes = new ArrayList<MiscUtil.Pair<ColumnConstraints, Node>>();

        Header(MultiTableWidget<D, T> widget, HeaderSet<D, T> headerSet, TableHandler<T, R> handler, int state) {
            this.widget = widget;
            this.headerSet = headerSet;
            this.handler = handler;
            this.viewState.setState(state);
            this.columns.clear();
            this.columns.addAll(handler.getColumns());
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            boolean hasPercents = this.columns.stream().anyMatch(item -> !item.isHidden() && item.getPrefWidth() != null);
            ColumnConstraints lastUnconstrainedCc = null;
            for (TableWidgetColumn column : this.columns) {
                ColumnConstraints constraints = new ColumnConstraints();
                if (column.getPrefWidthEm() != null || column.isNotHGrowable() || column.getMaxWidthEm() != null || column.getMinWidthEm() != null) {
                    constraints.setHgrow(Priority.NEVER);
                } else if (column.getPrefWidth() != null) {
                    constraints.setPercentWidth(column.getPrefWidth().doubleValue());
                } else {
                    constraints.setPrefWidth(-1.0);
                    constraints.setMinWidth(-1.0);
                    if (hasPercents) {
                        constraints.setMaxWidth(Double.NEGATIVE_INFINITY);
                        constraints.setHgrow(Priority.SOMETIMES);
                        lastUnconstrainedCc = constraints;
                    } else {
                        constraints.setMaxWidth(Double.MAX_VALUE);
                        constraints.setHgrow(Priority.ALWAYS);
                    }
                }
                if (lastUnconstrainedCc != null) {
                    lastUnconstrainedCc.setMaxWidth(Double.MAX_VALUE);
                    lastUnconstrainedCc.setHgrow(Priority.SOMETIMES);
                }
                CustomLabel label = new CustomLabel(column.getCaption());
                StackPane node = new StackPane(new Node[]{label});
                if (column.getHelp() != null) {
                    label.getStyleClass().add((Object)"hasTooltip");
                    label.setGraphic((Node)Buttons.quickHelpButton(() -> column.getHelp().get()));
                }
                node.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
                this.nodes.add((MiscUtil.Pair<ColumnConstraints, Node>)new MiscUtil.Pair((Object)constraints, (Object)node));
            }
        }

        public void reflow(int x, int y, boolean useControls) {
            StackPane node;
            for (int i = 0; i < this.nodes.size(); ++i) {
                node = this.nodes.get(i);
                this.widget.dataPane.getColumnConstraints().add(node.getFirst());
                GridPane.setConstraints((Node)((Node)node.getSecond()), (int)(x + i), (int)y);
                this.widget.dataPane.getChildren().add(node.getSecond());
            }
            if (useControls) {
                ColumnConstraints constraints = new ColumnConstraints();
                constraints.setHgrow(Priority.NEVER);
                node = new StackPane(new Node[]{new CustomLabel()});
                node.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
                this.widget.dataPane.getColumnConstraints().add((Object)constraints);
                GridPane.setConstraints((Node)node, (int)(x + this.nodes.size()), (int)y);
                this.widget.dataPane.getChildren().add((Object)node);
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(null));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        int getWidth() {
            return this.columns.size();
        }

        int getHeight() {
            return 1;
        }
    }

    public static class HeaderSet<D, T extends Identity>
    implements HasViewState {
        protected final ViewState viewState = new ViewState();
        final MultiTableWidget<D, T> widget;
        final MultiTableHandler<D, T> handler;
        final ObservableList<Header<D, T, ?>> headers = FXCollections.observableArrayList();

        HeaderSet(MultiTableWidget<D, T> widget, MultiTableHandler<D, T> handler, int state) {
            this.widget = widget;
            this.handler = handler;
            this.viewState.setState(state);
            this.createGUI();
            this.createBindings();
            this.createListeners();
        }

        private void createGUI() {
            List<TableHandler<T, ?>> handlers = this.handler.getHandlers();
            for (TableHandler<T, ?> handler : handlers) {
                Header header = new Header(this.widget, this, handler, this.viewState.getState());
                this.headers.add(header);
            }
        }

        private void createBindings() {
        }

        private void createListeners() {
            this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.widget.reflowAdvice(() -> UiUtil.updateState(oldValue.intValue(), newValue.intValue(), readonly -> {
                for (Header header : this.headers) {
                    header.getViewState().setReadonly(readonly);
                }
            }, notEditable -> {
                for (Header header : this.headers) {
                    header.getViewState().setNotEditable(notEditable);
                }
            }, aclNotEditable -> {
                for (Header header : this.headers) {
                    header.getViewState().setAclNotEditable(aclNotEditable);
                }
            }, aclNotViewable -> {
                for (Header header : this.headers) {
                    header.getViewState().setAclNotViewable(aclNotViewable);
                }
            }, aclNotCreatable -> {
                for (Header header : this.headers) {
                    header.getViewState().setAclNotCreatable(aclNotCreatable);
                }
            }, aclNotDeletable -> {
                for (Header header : this.headers) {
                    header.getViewState().setAclNotDeletable(aclNotDeletable);
                }
            })));
        }

        @Override
        public ViewState getViewState() {
            return this.viewState;
        }

        public void reflow(int x, int y, boolean useControls) {
            int offset = x;
            for (int i = 0; i < this.headers.size(); ++i) {
                Header header = (Header)this.headers.get(i);
                header.reflow(offset, y, useControls);
                offset += header.getWidth();
                if (useControls) {
                    ++offset;
                }
                if (i >= this.headers.size() - 1) continue;
                ColumnConstraints constraints = new ColumnConstraints();
                constraints.setHgrow(Priority.NEVER);
                StackPane node = new StackPane(new Node[]{new CustomLabel()});
                node.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
                this.widget.dataPane.getColumnConstraints().add((Object)constraints);
                GridPane.setConstraints((Node)node, (int)offset, (int)y);
                this.widget.dataPane.getChildren().add((Object)node);
                ++offset;
            }
        }

        int getHeight() {
            return this.headers.stream().mapToInt(item -> item.getHeight()).max().orElse(0);
        }
    }

    public static interface TableHandler<T extends Identity, R extends Identity> {
        public String getId();

        public List<TableWidgetColumn<R, ?>> getColumns();

        public List<R> getRows(T var1);

        public void setRows(T var1, List<R> var2);

        public MultiProvider<R> getItemsProvider();

        public Predicate<ControlsPane.ButtonType> getControlButtonsAvailability();

        default public String getTitle(T tableSet) {
            return null;
        }

        default public Node createSummaryNode() {
            return null;
        }
    }

    public static interface MultiTableHandler<D, T extends Identity> {
        public List<TableHandler<T, ?>> getHandlers();

        public List<T> getTableSets(D var1);

        public void setTableSets(D var1, List<T> var2);

        default public EventHandler<MultiTableRowEvent> createEventHandler() {
            return null;
        }
    }
}

