/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsSupport;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class StandardViewTypeProvider
implements Consumer<Consumer<NavigatorViewType>> {
    protected final BaseNavigatorWidget widget;

    protected StandardViewTypeProvider(BaseNavigatorWidget owner) {
        this.widget = owner;
    }

    protected List<NavigatorViewType> getTypes() {
        return new ArrayList<NavigatorViewType>(this.widget.getSupportedTypes());
    }

    @Override
    public void accept(Consumer<NavigatorViewType> resultConsumer) {
        List<NavigatorViewType> availableValues = this.getTypes();
        if (availableValues.isEmpty()) {
            return;
        }
        if (availableValues.size() == 1) {
            resultConsumer.accept(availableValues.get(0));
            return;
        }
        availableValues.sort((o1, o2) -> TextUtil.compare((String)o1.getDisplayName(), (String)o2.getDisplayName(), (boolean)true, (boolean)false));
        CustomComboBox comboBox = new CustomComboBox();
        comboBox.setConverter((StringConverter)new StringConverter<NavigatorViewType>(){

            public String toString(NavigatorViewType object) {
                return object == null ? "" : object.getDisplayName();
            }

            public NavigatorViewType fromString(String string) {
                return null;
            }
        });
        comboBox.getItems().setAll(availableValues);
        comboBox.setValue(availableValues.get(0));
        if (this.widget.suggestionsEnabled) {
            SuggestionsSupport.installSuggestions(comboBox, new SimpleSuggestionsHandler(comboBox, false));
        }
        StackPane pane = new StackPane(new Node[]{comboBox});
        pane.getStyleClass().add((Object)"dialog-type-selector");
        new Dialog().setTitle(TextUtil.isBlank((String)this.widget.getFieldName()) ? Messages.General_Choose_object_type : this.widget.getFieldName()).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Choose, () -> {
            NavigatorViewType value = (NavigatorViewType)comboBox.getValue();
            if (value != null) {
                resultConsumer.accept(value);
            }
        }).show((Node)this.widget);
        FxUtil.submitToFxThread(() -> comboBox.requestFocus());
    }
}

