/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasValues;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Pair;
import javafx.util.StringConverter;

public class KeyValueWidget<K>
extends HBox
implements HasViewState,
HasValue<Pair<K, Object>> {
    private final ObjectProperty<Pair<K, Object>> valueProperty = new SimpleObjectProperty();
    private Function<K, NodeRenderer> rendererSupplier = key -> null;
    private final ViewState viewState = new ViewState();
    private final ComboBoxWidget<K> keyWidget;
    private final RendererWidget valueWidget;

    public KeyValueWidget(boolean ro) {
        this.getStyleClass().add((Object)"key-value-widget");
        this.keyWidget = new ComboBoxWidget(ro);
        this.valueWidget = new RendererWidget(ro);
        HBox.setHgrow((Node)this.valueWidget, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.keyWidget, this.valueWidget});
        this.keyWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.valueProperty.setValue((Object)(newValue != null ? new Pair(newValue, null) : null));
            this.valueWidget.setRenderer(this.rendererSupplier.apply(newValue));
            this.addRendererListener();
        });
        this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> {
            this.keyWidget.getViewState().setState(newValue.intValue());
            this.valueWidget.getViewState().setState(newValue.intValue());
        });
    }

    public void setKeysSupplier(Supplier<List<K>> keysSupplier) {
        this.keyWidget.setItemsSupplier(keysSupplier);
        this.keyWidget.guessPrefWidth();
    }

    public void setKeyConverter(StringConverter<K> converter) {
        this.keyWidget.setConverter(converter);
        this.keyWidget.guessPrefWidth();
    }

    public void setRendererSupplier(Function<K, NodeRenderer> rendererSupplier) {
        this.rendererSupplier = Objects.requireNonNull(rendererSupplier);
        this.valueProperty.setValue((Object)(this.keyWidget.getValue() != null ? new Pair(this.keyWidget.getValue(), null) : null));
        this.valueWidget.setRenderer(rendererSupplier.apply(this.keyWidget.getValue()));
        this.addRendererListener();
    }

    @Override
    public ObjectProperty<Pair<K, Object>> valueProperty() {
        return this.valueProperty;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public Pair<K, Object> getValue() {
        return (Pair)this.valueProperty.getValue();
    }

    public void setValue(Pair<K, Object> value) {
        this.keyWidget.setValue(value != null ? value.getKey() : null);
        this.valueWidget.setValue(value != null ? value.getValue() : null);
    }

    private void addRendererListener() {
        Node valueNode = this.valueWidget.getValueNode();
        if (valueNode instanceof HasValue) {
            ((HasValue)valueNode).valueProperty().addListener((observable, oldValue, newValue) -> this.valueProperty.setValue((Object)new Pair(this.keyWidget.getValue(), newValue)));
        } else if (valueNode instanceof HasValues) {
            ((HasValues)valueNode).getValues().addListener(observable -> this.valueProperty.setValue((Object)new Pair(this.keyWidget.getValue(), (Object)observable)));
        }
    }
}

