/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValues;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.PopupWindow;
import javafx.util.StringConverter;

public class ValuesWidget<T>
extends HBox
implements HasViewState,
HasValues<T> {
    private static final String SELECTED_CHECKBOX_STYLE_CLASS = "selected";
    private static final int DROPDOWN_HEIGHT = 275;
    private final TextFlow textFlow;
    private final ObservableList<T> values = FXCollections.observableArrayList();
    private PopupControl popup;
    private final ViewState viewState = new ViewState();
    private StringConverter<T> converter = StandardRenderers.GENERIC.createStatefulConverter(this.viewState::isImmutable);
    private Supplier<List<T>> itemsSupplier = Collections::emptyList;
    private boolean async;
    private boolean keepSelectionOrder = false;
    private String promptText;
    private ActionData actionData;

    public ValuesWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"values-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.textFlow = new TextFlow();
        this.textFlow.getStyleClass().add((Object)"values-pane");
        StackPane wrapper = new StackPane(new Node[]{this.textFlow});
        HBox.setHgrow((Node)wrapper, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)wrapper);
        ChangeListener listener = (s, o, n) -> {
            if (!n.booleanValue()) {
                while (wrapper.getChildren().size() > 1) {
                    wrapper.getChildren().remove(wrapper.getChildren().size() - 1);
                }
                return;
            }
            if (this.viewState.isImmutable() || this.values.isEmpty()) {
                return;
            }
            if (wrapper.getChildren().size() == 1) {
                Region clearButton = Buttons.clearButton(() -> this.values.clear());
                StackPane.setAlignment((Node)clearButton, (Pos)Pos.TOP_RIGHT);
                wrapper.getChildren().add((Object)clearButton);
            }
        };
        this.focusedProperty().addListener(listener);
        this.hoverProperty().addListener(listener);
        this.values.addListener(change -> this.renderValue());
        this.updateState();
        this.renderValue();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.updateState();
            this.renderValue();
        });
    }

    public String getText() {
        return this.values.stream().map(arg_0 -> this.converter.toString(arg_0)).collect(Collectors.joining(", "));
    }

    public void setActionHandler(IconShape iconShape, String tooltip, Runnable handler) {
        this.actionData = handler == null ? null : new ActionData(Objects.requireNonNull(iconShape), tooltip, handler);
        this.updateState();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setAsync(boolean val) {
        this.async = val;
    }

    public Supplier<List<T>> getItemsSupplier() {
        return this.itemsSupplier;
    }

    public void setItemsSupplier(Supplier<List<T>> value) {
        this.itemsSupplier = Objects.requireNonNull(value);
    }

    public void setConverter(StringConverter<T> value) {
        this.converter = Objects.requireNonNull(value);
        this.renderValue();
    }

    @Override
    public ObservableList<T> getValues() {
        return this.values;
    }

    public boolean isKeepSelectionOrder() {
        return this.keepSelectionOrder;
    }

    public void setKeepSelectionOrder(boolean value) {
        this.keepSelectionOrder = value;
    }

    private void updateState() {
        String string = this.promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
        if (this.viewState.isImmutable()) {
            this.getChildren().setAll((Object[])new Node[]{(Node)this.getChildren().get(0)});
        } else {
            Button choicesButton = new Button();
            choicesButton.setGraphic((Node)new IconNode(StandardIconShapes.RULER_14X14, (Styleable)choicesButton, StandardIconIntentions.EXPAND_BUTTON_ACTION, (Styleable)choicesButton));
            choicesButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "choices-button"});
            choicesButton.setOnAction(evt -> {
                if (this.async) {
                    Notifications.get().submitTask(() -> {
                        List<T> list = this.itemsSupplier.get();
                        FxUtil.submitToFxThread(() -> this.showItemsPopup(choicesButton, list));
                    }, ObservableMutex.lookup((Node)this));
                } else {
                    this.showItemsPopup(choicesButton, this.itemsSupplier.get());
                }
            });
            choicesButton.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
                if (!evt.isAltDown() || evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                boolean alt = evt.isShiftDown();
                if (this.async) {
                    Notifications.get().submitTask(() -> {
                        List<T> list = this.itemsSupplier.get();
                        FxUtil.submitToFxThread(() -> this.copyToClipboard((Region)choicesButton, list, alt));
                    }, ObservableMutex.lookup((Node)this));
                } else {
                    this.copyToClipboard((Region)choicesButton, this.itemsSupplier.get(), alt);
                }
            });
            if (this.actionData != null) {
                Button actionButton = new Button();
                actionButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "action-button"});
                actionButton.setGraphic((Node)new IconNode(this.actionData.shape, (Styleable)actionButton, StandardIconIntentions.CONTROLS_QTY, (Styleable)actionButton));
                actionButton.setOnAction(evt -> this.actionData.handler.run());
                if (!TextUtil.isBlank((String)this.actionData.tooltip)) {
                    UiUtil.setTooltip((Node)actionButton, this.actionData.tooltip);
                }
                choicesButton.getStyleClass().add((Object)"action-button-sibling");
                this.getChildren().setAll((Object[])new Node[]{(Node)this.getChildren().get(0), choicesButton, actionButton});
            } else {
                this.getChildren().setAll((Object[])new Node[]{(Node)this.getChildren().get(0), choicesButton});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void copyToClipboard(Region anchor, List<T> items, boolean alt) {
        Function<Object, String> mapper = alt ? Object::toString : item -> this.converter.toString(item);
        String text = items.stream().map(mapper).collect(Collectors.joining("\n"));
        Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, text));
        UiUtil.showPopup((PopupWindow)UiUtil.createPopup((Parent)new Label(alt ? Messages.Combobox_Copy_Hint_1 : Messages.Combobox_Copy_Hint_2)), anchor);
    }

    private void showItemsPopup(Button choicesButton, List<T> list) {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.popup = UiUtil.createPopup(this.createScrollableList(list, (List<T>)this.values, this.textFlow.getWidth()));
        this.popup.focusedProperty().addListener((obj, o, n) -> {
            this.textFlow.pseudoClassStateChanged(Styles.FOCUSED_PSEUDOCLASS, n.booleanValue());
            choicesButton.pseudoClassStateChanged(Styles.EXPANDED_PSEUDOCLASS, n.booleanValue());
            choicesButton.pseudoClassStateChanged(Styles.FOCUSED_PSEUDOCLASS, n.booleanValue());
        });
        UiUtil.showPopup((PopupWindow)this.popup, (Region)this.textFlow);
    }

    private Parent createScrollableList(List<T> options, List<T> selectedItems, double width) {
        VBox vBox = new VBox();
        vBox.setFillWidth(true);
        Label labelAll = new Label(Messages.General_All);
        EventHandler handler = evt -> {
            this.values.setAll((Collection)options);
            this.popup.hide();
        };
        labelAll.setOnMouseClicked(handler);
        labelAll.setOnKeyPressed(handler);
        vBox.getChildren().add((Object)this.expanded((Node)labelAll));
        for (Object option : options) {
            StackPane checkWrap = new StackPane();
            checkWrap.getStyleClass().add((Object)"checkBoxWrap");
            checkWrap.setAlignment(Pos.CENTER_LEFT);
            CheckBox checkBox = new CheckBox();
            checkBox.setPrefWidth(width);
            checkBox.setGraphic((Node)new IconNode(StandardIconShapes.CHECK_14X14, (Styleable)checkBox, StandardIconIntentions.CHECK, (Styleable)checkBox));
            checkBox.getStyleClass().add((Object)"xtrip-checkbox");
            checkBox.setText(this.converter.toString(option));
            checkBox.setSelected(selectedItems.contains(option));
            Styles.manageStyle((Styleable)checkBox, SELECTED_CHECKBOX_STYLE_CLASS, checkBox.isSelected());
            checkBox.selectedProperty().addListener((obj, was, selected) -> this.doSelectOption(checkBox, (T)option, (boolean)selected, options, selectedItems));
            Styles.manageStyle((Styleable)checkWrap, "last-option", options.indexOf(option) == options.size() - 1);
            checkWrap.getChildren().add((Object)checkBox);
            vBox.getChildren().add((Object)checkWrap);
        }
        ScrollPane result = new ScrollPane((Node)vBox);
        result.hbarPolicyProperty().set((Object)ScrollPane.ScrollBarPolicy.NEVER);
        result.getStyleClass().addAll((Object[])new String[]{"xtrip-scroll-alt", "values-widget-dropdown"});
        result.setFitToWidth(true);
        result.setMaxWidth(width);
        result.setPrefWidth(width);
        result.setMinWidth(width);
        result.setMaxHeight(275.0);
        return result;
    }

    private void renderValue() {
        this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, this.values.isEmpty());
        if (this.values.isEmpty()) {
            this.textFlow.getChildren().setAll((Object[])new Node[]{new Text(this.promptText)});
            return;
        }
        ArrayList<Text> words = new ArrayList<Text>(this.values.size() * 2);
        for (Object value : this.values) {
            if (!words.isEmpty()) {
                words.add(new Text(", "));
            }
            String word = this.converter.toString(value);
            Text text = new Text(word);
            text.getStyleClass().add((Object)"word");
            text.setOnMouseClicked(e -> {
                if (this.viewState.isImmutable()) {
                    return;
                }
                this.values.remove(value);
            });
            words.add(text);
        }
        this.textFlow.getChildren().setAll(words);
    }

    private Pane expanded(Node node) {
        AnchorPane pane = new AnchorPane();
        Styles.addStyle((Styleable)pane, "labelWrap");
        AnchorPane.setLeftAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)0.0);
        pane.getChildren().add((Object)node);
        return pane;
    }

    private void doSelectOption(CheckBox checkBox, T option, boolean selected, List<T> allItems, List<T> selectedItems) {
        if (selected) {
            if (this.keepSelectionOrder) {
                selectedItems.add(option);
            } else {
                int pos = this.calculateValuePosition(option, allItems, selectedItems);
                if (pos >= 0) {
                    selectedItems.add(pos, option);
                } else {
                    selectedItems.add(option);
                }
            }
        } else {
            selectedItems.remove(option);
        }
        Styles.manageStyle((Styleable)checkBox, SELECTED_CHECKBOX_STYLE_CLASS, selected);
        this.renderValue();
    }

    private int calculateValuePosition(T targetValue, List<T> allValues, List<T> selectedValues) {
        int found = 0;
        for (T value : allValues) {
            if (this.strictContains(selectedValues, value)) {
                ++found;
            }
            if (value != targetValue) continue;
            return found;
        }
        return -1;
    }

    private boolean strictContains(List<T> list, T target) {
        for (T value : list) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    private class ActionData {
        final IconShape shape;
        final String tooltip;
        final Runnable handler;

        ActionData(IconShape is, String tt, Runnable h) {
            this.shape = is;
            this.tooltip = tt;
            this.handler = h;
        }
    }
}

