/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;

class WorkaroundSelectionModel<T>
extends MultipleSelectionModel<T> {
    private final ObjectProperty<T> valueProperty;
    private ObservableList<T> items;
    private int selectedRow = -1;

    public WorkaroundSelectionModel(ObservableList<T> comboBoxItems, ObjectProperty<T> property) {
        this.items = comboBoxItems;
        this.valueProperty = property;
    }

    public void selectAll() {
    }

    public void clearAndSelect(int row) {
        this.selectedRow = row;
        T item = this.getModelItem(row);
        this.valueProperty.set(item);
    }

    public ObservableList<Integer> getSelectedIndices() {
        return FXCollections.singletonObservableList((Object)this.selectedRow);
    }

    public ObservableList<T> getSelectedItems() {
        return FXCollections.singletonObservableList((Object)this.valueProperty.get());
    }

    public void selectIndices(int index, int ... indices) {
        this.selectedRow = index;
    }

    public void selectFirst() {
        this.selectedRow = 0;
    }

    public void selectLast() {
        this.selectedRow = this.items.size() - 1;
    }

    public void select(int index) {
        this.setSelectedIndex(index);
        this.selectedRow = index;
        this.valueProperty.set(this.getModelItem(this.selectedRow));
    }

    public void select(T obj) {
        this.selectedRow = this.items.indexOf(obj);
        this.setSelectedIndex(this.selectedRow);
        this.valueProperty.set(obj);
    }

    public void clearSelection(int index) {
        if (this.selectedRow == index) {
            this.selectedRow = -1;
            this.setSelectedIndex(this.selectedRow);
        }
    }

    public void clearSelection() {
        this.selectedRow = -1;
        this.setSelectedIndex(this.selectedRow);
    }

    public boolean isSelected(int index) {
        return this.selectedRow == index;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void selectPrevious() {
        if (this.selectedRow > 0) {
            --this.selectedRow;
        }
    }

    public void selectNext() {
        if (this.selectedRow < this.items.size() - 1) {
            ++this.selectedRow;
        }
    }

    protected T getModelItem(int index) {
        if (this.items == null) {
            return null;
        }
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return (T)this.items.get(index);
    }

    void setItems(ObservableList<T> collection) {
        this.items = collection;
    }
}

