/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor;

import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.RichContentEditor;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import java.io.File;
import java.util.Base64;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class PdfContentEditor
extends StackPane
implements RichContentEditor {
    private byte[] data;
    private WebView webView;

    public PdfContentEditor() {
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null && this.data != null && this.data.length > 0) {
                if (this.webView == null) {
                    this.createWebView();
                } else {
                    this.renderData();
                }
            }
        });
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] value) {
        this.data = value;
        if (this.data == null || this.data.length == 0) {
            this.getChildren().setAll((Object[])new Node[]{new Label(Messages.General_No_data)});
            this.webView = null;
            return;
        }
        if (this.getScene() == null) {
            return;
        }
        if (this.webView == null) {
            this.createWebView();
        } else {
            this.renderData();
        }
    }

    private void createWebView() {
        try {
            try {
                this.webView = new WebView();
            }
            catch (Error e) {
                ActivityManager.get().unloadTabs();
                this.webView = new WebView();
            }
            this.webView.setContextMenuEnabled(false);
            WebEngine engine = this.webView.getEngine();
            engine.setJavaScriptEnabled(true);
            engine.setOnError(evt -> ErrorHandler.handle(evt.getException()));
            engine.getLoadWorker().stateProperty().addListener((s, o, n) -> {
                if (this.webView == null) {
                    return;
                }
                if (n == Worker.State.SUCCEEDED) {
                    FxUtil.submitToFxThread(() -> {
                        if (this.webView != null && this.webView.getEngine().getLoadWorker().getState() == Worker.State.SUCCEEDED) {
                            this.webView.getEngine().executeScript("changeLanguage('" + LocaleManager.get().getCurrentLocale().toLanguageTag() + "')");
                        }
                    });
                    this.renderData();
                } else if (n == Worker.State.FAILED && this.webView.getEngine().getLoadWorker().getException() != null) {
                    ErrorHandler.handle(this.webView.getEngine().getLoadWorker().getException());
                }
            });
            engine.setUserDataDirectory(new File(Environment.getTempFolder(), "pdfjs"));
            engine.load(FxRes.class.getResource("pdfjs/viewer.html").toExternalForm());
            this.getChildren().setAll((Object[])new Node[]{this.webView});
        }
        catch (Throwable t) {
            ErrorHandler.LOG.error("failed rendering PDF", t);
            this.getChildren().setAll((Object[])new Node[]{new Label(Messages.PDF_rendering_error + '\n' + ErrorHandler.getMessage(t))});
            this.webView = null;
        }
    }

    private void renderData() {
        if (this.data == null || this.data.length == 0 || this.webView == null) {
            return;
        }
        String base64 = Base64.getEncoder().encodeToString(this.data);
        FxUtil.submitToFxThread(() -> {
            if (this.webView != null && this.webView.getEngine().getLoadWorker().getState() == Worker.State.SUCCEEDED) {
                this.webView.getEngine().executeScript("openFileFromBase64('" + base64 + "')");
            }
        });
    }

    @Override
    public void setReadonly(boolean value) {
    }

    @Override
    public boolean isDataChanged() {
        return false;
    }
}

