/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.editor.RichContentEditor;
import java.nio.charset.Charset;
import javafx.scene.layout.StackPane;

public class PlainTextContentEditor
extends StackPane
implements RichContentEditor {
    private static final int DATA_SIZE_LIMIT = 131072;
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final TextAreaWidget widget;
    private byte[] fullData;
    private boolean dataChanged;

    public PlainTextContentEditor() {
        this.getStyleClass().add((Object)"plain-text-content-editor");
        this.widget = new TextAreaWidget(false);
        this.widget.setMonospace(true);
        this.widget.setPrefRowCount(Integer.MAX_VALUE);
        this.widget.valueProperty().addListener(obj -> {
            this.dataChanged = true;
        });
        this.getChildren().add((Object)this.widget);
    }

    @Override
    public byte[] getData() {
        if (this.fullData != null) {
            return this.fullData;
        }
        String text = this.widget.getValue();
        return text == null ? null : text.getBytes(UTF8);
    }

    @Override
    public void setData(byte[] value) {
        if (value == null || value.length == 0) {
            this.widget.setValue(null);
            this.fullData = null;
        } else {
            String str = new String(value, UTF8);
            if (str.length() > 131072) {
                str = str.substring(0, 131073) + "\n\n... " + Messages.General_Too_much_data_for_view;
                this.fullData = value;
                this.widget.getViewState().setNotEditable(true);
            } else {
                this.fullData = null;
            }
            this.widget.setValue(str);
        }
        this.dataChanged = false;
    }

    @Override
    public void setReadonly(boolean value) {
        this.widget.getViewState().setReadonly(this.fullData != null || value);
    }

    @Override
    public boolean isDataChanged() {
        return this.dataChanged;
    }
}

