/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table;

import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

class Header<T> {
    private final List<TableWidgetColumn<T, ?>> columns;
    private final List<Node> nodes;
    private Node controlNode;

    Header(List<TableWidgetColumn<T, ?>> cols) {
        this.columns = cols;
        this.nodes = new ArrayList<Node>(this.columns.size());
        if (!this.columns.stream().anyMatch(col -> !TextUtil.isBlank((String)col.getCaption()))) {
            return;
        }
        for (TableWidgetColumn<T, ?> col2 : this.columns) {
            CustomLabel label = new CustomLabel(col2.getCaption());
            StackPane node = new StackPane(new Node[]{label});
            if (col2.getHelp() != null) {
                label.getStyleClass().add((Object)"hasTooltip");
                label.setGraphic((Node)Buttons.quickHelpButton(((Supplier<QuickHelp>)col2.getHelp())::get));
            }
            node.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
            this.nodes.add((Node)node);
        }
    }

    List<Node> getNodes() {
        return this.nodes;
    }

    List<ColumnConstraints> buildConstraints(boolean withControlColumn) {
        boolean hasPercents = this.columns.stream().anyMatch(col -> !col.isHidden() && col.getPrefWidth() != null);
        ArrayList<ColumnConstraints> result = new ArrayList<ColumnConstraints>(this.columns.size() + 1);
        ColumnConstraints lastUnconstrainedCc = null;
        for (TableWidgetColumn col2 : this.columns.stream().filter(c -> !c.isHidden()).collect(Collectors.toList())) {
            ColumnConstraints cc = new ColumnConstraints();
            result.add(cc);
            if (col2.getPrefWidthEm() != null || col2.isNotHGrowable() || col2.getMaxWidthEm() != null || col2.getMinWidthEm() != null) {
                cc.setHgrow(Priority.NEVER);
                continue;
            }
            if (col2.getPrefWidth() != null) {
                cc.setPercentWidth(col2.getPrefWidth().doubleValue());
                continue;
            }
            cc.setPrefWidth(-1.0);
            cc.setMinWidth(-1.0);
            if (hasPercents) {
                cc.setMaxWidth(Double.NEGATIVE_INFINITY);
                cc.setHgrow(Priority.SOMETIMES);
                lastUnconstrainedCc = cc;
                continue;
            }
            cc.setMaxWidth(Double.MAX_VALUE);
            cc.setHgrow(Priority.ALWAYS);
        }
        if (lastUnconstrainedCc != null) {
            lastUnconstrainedCc.setMaxWidth(Double.MAX_VALUE);
            lastUnconstrainedCc.setHgrow(Priority.SOMETIMES);
        }
        if (withControlColumn) {
            ColumnConstraints cc = new ColumnConstraints();
            cc.setHgrow(Priority.NEVER);
            result.add(cc);
        }
        return result;
    }

    Node getControlNode() {
        if (this.controlNode == null) {
            this.controlNode = new StackPane();
            this.controlNode.getStyleClass().addAll((Object[])new String[]{"header-cell", "grid-cell"});
        }
        return this.controlNode;
    }
}

