/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.Header;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.StandardTableWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.Identity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class TableWidget<T>
extends BorderPane
implements HasViewState,
DevTool {
    protected final List<TableWidgetColumn<T, ?>> columns = new ArrayList();
    protected final ObservableList<Row> rows = FXCollections.observableArrayList();
    private final Label placeholder;
    protected final ViewState viewState = new ViewState();
    private final ObjectProperty<EventHandler<TableRowEvent>> onRowsAction = new ObjectPropertyBase<EventHandler<TableRowEvent>>(){

        public Object getBean() {
            return TableWidget.this;
        }

        public String getName() {
            return "onRowsAction";
        }

        protected void invalidated() {
            TableWidget.this.setEventHandler(TableRowEvent.ROW_ANY, (EventHandler)this.get());
        }
    };
    protected MultiProvider<T> itemsProvider;
    protected Predicate<ControlsPane.ButtonType> controlButtonsAvailability = ControlsPane.ADD_REMOVE;
    protected BiPredicate<ControlsPane.ButtonType, Integer> controlButtonsCoordinator = new StandardTableWidgetCoordinator(this);
    protected Header<T> header;
    private GridPane gridPane;
    private PlaceholderPane placeholderPane;
    private FilteringPane<?> filteringPane;
    private String fieldName;
    private boolean rowsChanged;
    private final TableColumnOwner<T> asOwner = new TableColumnOwner<T>(){

        @Override
        public ViewState getViewState() {
            return TableWidget.this.viewState;
        }

        @Override
        public int indexOfRow(Node node) {
            for (int i = 0; i < TableWidget.this.rows.size(); ++i) {
                Row row = (Row)TableWidget.this.rows.get(i);
                if (!row.getCells().stream().anyMatch(cell -> node.equals(cell))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public <N extends Node> N getWidget(TableWidgetColumn<T, N> column, int rowIdx) {
            Row row = (Row)TableWidget.this.rows.get(rowIdx);
            return (N)row.getCells().get(TableWidget.this.columns.indexOf(column));
        }

        @Override
        public void injectWidget(int row, Node widget) {
            ((Row)TableWidget.this.rows.get(row)).inject(widget);
            TableWidget.this.reflow();
        }

        @Override
        public void ejectWidget(int row) {
            ((Row)TableWidget.this.rows.get(row)).eject();
            TableWidget.this.reflow();
        }

        @Override
        public int getRowsCount() {
            return TableWidget.this.rows.size();
        }
    };
    private Consumer<T> newRowHandler;

    public TableWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"table-widget");
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.placeholder = new Label(Messages.General_No_entries);
        this.viewState.stateProperty().addListener(obj -> this.reflow());
        this.rows.addListener(change -> {
            this.rowsChanged = true;
            ArrayList<TableRowEvent> events = new ArrayList<TableRowEvent>();
            while (change.next()) {
                events.addAll(this.buildRowEvents((ListChangeListener.Change<Row>)change));
            }
            events.forEach(arg_0 -> ((TableWidget)this).fireEvent(arg_0));
            this.reflow();
        });
        this.reflow();
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.reflow();
            }
        });
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setPlaceholder(String value) {
        this.placeholder.setText(value.length() > 0 ? Character.toUpperCase(value.charAt(0)) + value.substring(1) : value);
    }

    public void setColumns(List<TableWidgetColumn<T, ?>> value) {
        if (!this.rows.isEmpty()) {
            throw new IllegalStateException("table is not empty");
        }
        ArrayList oldColumns = new ArrayList(this.columns);
        oldColumns.forEach(column -> column.setOwner(null));
        value.forEach(column -> column.setOwner(this.asOwner));
        this.columns.clear();
        this.columns.addAll(value);
        this.header = null;
        this.reflow();
    }

    public List<TableWidgetColumn<T, ?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void hideColumn(TableWidgetColumn<T, ?> column) {
        column.setHidden(true);
        this.reflow();
    }

    public void unhideColumn(TableWidgetColumn<T, ?> column) {
        column.setHidden(false);
        this.reflow();
    }

    public TableWidgetColumn<T, ?> getColumn(String id) {
        for (TableWidgetColumn<T, ?> col : this.columns) {
            if (!id.equals(col.getId())) continue;
            return col;
        }
        throw new IllegalArgumentException("invalid column ID " + id);
    }

    public void setItemsProvider(MultiProvider<T> value) {
        this.itemsProvider = Objects.requireNonNull(value);
    }

    public void setControlButtonsAvailability(Predicate<ControlsPane.ButtonType> value) {
        this.controlButtonsAvailability = Objects.requireNonNull(value);
        this.placeholderPane = null;
        this.reflow();
    }

    public void setControlButtonsCoordinator(BiPredicate<ControlsPane.ButtonType, Integer> value) {
        this.controlButtonsCoordinator = Objects.requireNonNull(value);
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public <N extends Node> void setFiltering(Supplier<N> filtersPaneSupplier, Function<N, Predicate<T>> predicateSupplier, boolean collapsible) {
        FilteringPane<Node> pane = filtersPaneSupplier == null ? null : new FilteringPane<Node>(filtersPaneSupplier, collapsible);
        this.filteringPane = pane;
        if (pane != null) {
            pane.setOnApply(filtersPane -> {
                Predicate predicate = (Predicate)predicateSupplier.apply(filtersPane);
                Iterator iterator = this.rows.iterator();
                while (iterator.hasNext()) {
                    Row row;
                    row.setFilteredOut(!predicate.test((row = (Row)iterator.next()).getPopulatedData(true)));
                }
                this.reflow();
            });
        } else {
            this.rows.forEach(row -> row.setFilteredOut(false));
        }
        this.reflow();
    }

    public ObjectProperty<EventHandler<TableRowEvent>> onRowsActionProperty() {
        return this.onRowsAction;
    }

    public EventHandler<TableRowEvent> getOnRowsAction() {
        return (EventHandler)this.onRowsAction.get();
    }

    public void setOnRowsAction(EventHandler<TableRowEvent> value) {
        this.onRowsAction.set(value);
    }

    public int getRowsCount() {
        return this.rows.size();
    }

    public T getData(int row) {
        return ((Row)this.rows.get(row)).getData();
    }

    public void addRow(int pos) {
        this.itemsProvider.createAny(this.buildItemsConsumer(pos));
    }

    public void addRow(int pos, T item) {
        this.rows.add(pos, (Object)new Row(item));
        if (this.filteringPane != null) {
            this.filteringPane.reset();
        }
    }

    public void addRow(T item) {
        this.addRow(this.rows.size(), item);
    }

    public void removeRow(int pos) {
        this.rows.remove(pos);
    }

    public void removeAllRows() {
        this.rows.clear();
    }

    public Collection<T> getRowsData() {
        return this.rows.stream().map(r -> r.getPopulatedData(false)).collect(Collectors.toList());
    }

    public void setNewRowHandler(Consumer<T> value) {
        this.newRowHandler = value;
    }

    private List<TableRowEvent> buildRowEvents(ListChangeListener.Change<? extends Row> change) {
        ArrayList<TableRowEvent> result = new ArrayList<TableRowEvent>();
        if (change.wasPermutated() || change.wasUpdated()) {
            for (int i = change.getFrom(); i < change.getTo(); ++i) {
                result.add(new TableRowEvent(this, (EventTarget)this, TableRowEvent.ROW_ANY, i));
            }
        } else {
            if (change.getRemovedSize() > 0) {
                if (change.getFrom() == change.getTo()) {
                    result.add(new TableRowEvent(this, (EventTarget)this, TableRowEvent.ROW_REMOVE, change.getFrom()));
                }
                for (int rowIdx = change.getFrom(); rowIdx < change.getTo(); ++rowIdx) {
                    result.add(new TableRowEvent(this, (EventTarget)this, TableRowEvent.ROW_REMOVE, rowIdx));
                }
            }
            for (Row row : change.getAddedSubList()) {
                result.add(new TableRowEvent(this, (EventTarget)this, TableRowEvent.ROW_ADD, this.rows.indexOf((Object)row)));
            }
        }
        return result;
    }

    protected void reflow() {
        if (this.getScene() == null) {
            return;
        }
        if (this.rows.isEmpty()) {
            if (this.placeholderPane == null) {
                this.placeholderPane = new PlaceholderPane();
                this.placeholderPane.setPlaceholder(this.placeholder);
                if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                    ControlsPane controlsPane = new ControlsPane();
                    controlsPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.itemsProvider.createAny(this.buildItemsConsumer(null))));
                    controlsPane.visibleProperty().bind((ObservableValue)new BooleanBinding(){
                        {
                            this.bind(new Observable[]{TableWidget.this.viewState.stateProperty()});
                        }

                        protected boolean computeValue() {
                            return TableWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, null);
                        }
                    });
                    this.placeholderPane.setControlsPane(controlsPane);
                }
            }
            this.setTop((Node)this.placeholderPane);
            this.setCenter(null);
            this.header = null;
            this.gridPane = null;
            return;
        }
        if (this.header == null) {
            this.header = new Header<T>(this.columns);
        }
        if (this.filteringPane != null) {
            long filtered = this.rows.stream().filter(row -> !row.isFilteredOut()).count();
            this.filteringPane.setCaption(Messages.getGeneral_Paging_filter(this.fieldName, filtered, this.rows.size()));
        }
        ArrayList<Node> nodes = new ArrayList<Node>((this.columns.size() + 1) * (this.rows.size() + 1));
        boolean withControls = !this.viewState.isImmutable() && this.isControlColumnRequired();
        int rowIdx = 0;
        int colIdx = 0;
        for (int i = 0; i < this.header.getNodes().size(); ++i) {
            if (this.columns.get(i).isHidden()) continue;
            Node node = this.header.getNodes().get(i);
            nodes.add(node);
            node.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, colIdx == 0);
            node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
            node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, false);
            GridPane.setConstraints((Node)node, (int)colIdx, (int)rowIdx);
            ++colIdx;
        }
        if (!nodes.isEmpty()) {
            if (withControls) {
                Node node = this.header.getControlNode();
                node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, true);
                node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
                GridPane.setConstraints((Node)node, (int)colIdx, (int)rowIdx);
                nodes.add(node);
                ++colIdx;
            } else {
                ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
            }
            ++rowIdx;
        }
        for (Row row2 : this.rows) {
            if (row2.isFilteredOut()) continue;
            boolean lastRow = row2.equals(this.rows.get(this.rows.size() - 1));
            int colIdx2 = 0;
            for (int i = 0; i < row2.getCells().size(); ++i) {
                TableWidgetColumn<T, ?> column = this.columns.get(i);
                if (column.isHidden()) continue;
                Node cell = row2.getCells().get(i);
                nodes.add(cell);
                cell.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, colIdx2 == 0);
                cell.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, rowIdx == 0);
                cell.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, false);
                cell.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow && row2.getInjected() == null);
                column.setReadonly(cell, this.viewState.isReadonly());
                column.setAclNotEditable(cell);
                GridPane.setConstraints((Node)cell, (int)colIdx2, (int)rowIdx);
                ++colIdx2;
            }
            if (withControls) {
                Node node = row2.getControlsPane();
                node.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, rowIdx == 0);
                node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
                node.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow && row2.getInjected() == null);
                GridPane.setConstraints((Node)node, (int)colIdx2, (int)rowIdx);
                nodes.add(node);
                ++colIdx2;
            } else {
                ((Node)nodes.get(nodes.size() - 1)).pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
            }
            ++rowIdx;
            if (row2.getInjected() == null) continue;
            Node node = row2.getInjected();
            GridPane.setConstraints((Node)node, (int)0, (int)rowIdx, (int)colIdx2, (int)1);
            node.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, true);
            node.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, true);
            node.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, lastRow);
            nodes.add(node);
            ++rowIdx;
        }
        this.placeholderPane = null;
        if (this.gridPane == null) {
            this.gridPane = new GridPane();
            this.gridPane.getStyleClass().add((Object)"grid-frame");
        }
        this.gridPane.getColumnConstraints().setAll(this.header.buildConstraints(withControls));
        this.gridPane.getChildren().setAll(nodes);
        this.setTop((Node)this.filteringPane);
        this.setCenter((Node)this.gridPane);
    }

    void readData(Collection<T> model) {
        if (model.isEmpty()) {
            this.rows.clear();
        } else {
            this.rows.setAll((Collection)model.stream().map(x$0 -> new Row(x$0)).collect(Collectors.toList()));
        }
        if (this.filteringPane != null) {
            this.filteringPane.reset();
        }
        this.rowsChanged = false;
    }

    void writeData(Collection<T> model) {
        ArrayList list = new ArrayList(this.rows.size());
        Iterator<T> it = model.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof Identity) continue;
            it.remove();
        }
        for (Row row : this.rows) {
            Object data = row.getData();
            if (data instanceof Identity) {
                String uid = ((Identity)data).getUid();
                if (uid == null) {
                    uid = UUID.randomUUID().toString();
                    ((Identity)data).setUid(uid);
                } else {
                    T existing = this.getExisting(model, uid);
                    if (existing != null) {
                        row.setData(existing);
                    }
                }
            }
            list.add(row.getPopulatedData(false));
        }
        model.clear();
        model.addAll(list);
        this.rowsChanged = false;
    }

    private T getExisting(Collection<T> model, String uid) {
        if (uid == null || model.isEmpty()) {
            return null;
        }
        Iterator<T> it = model.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (!(item instanceof Identity) || !uid.equals(((Identity)item).getUid())) continue;
            it.remove();
            return item;
        }
        return null;
    }

    boolean isDataChanged() {
        if (this.rowsChanged) {
            return true;
        }
        for (Row row : this.rows) {
            if (!row.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    Consumer<Collection<T>> buildItemsConsumer(Integer pos) {
        return items -> {
            if (items == null || items.isEmpty()) {
                return;
            }
            ArrayList<Row> list = new ArrayList<Row>();
            for (Object item : items) {
                if (item == null) continue;
                if (this.newRowHandler != null) {
                    this.newRowHandler.accept(item);
                }
                list.add(new Row(item));
            }
            if (pos == null) {
                this.rows.addAll(list);
            } else {
                this.rows.addAll(pos > this.rows.size() ? this.rows.size() : pos.intValue(), list);
            }
        };
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return TableWidget.this.getColumns();
            }

            @Override
            public String getInfo() {
                return TableWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(TableWidget.this.viewState);
            }
        };
    }

    private boolean isControlColumnRequired() {
        return Stream.of(ControlsPane.ButtonType.values()).anyMatch(this.controlButtonsAvailability);
    }

    class Row {
        private final List<Node> cells;
        private T data;
        private Pane injectedWidget;
        private Node controlsPane;
        private boolean filteredOut;

        Row(T item) {
            this.cells = new ArrayList<Node>(TableWidget.this.columns.size());
            this.injectedWidget = null;
            this.data = item;
            for (TableWidgetColumn col : TableWidget.this.columns) {
                Object node = col.createNode();
                col.readData(this.data, node);
                String style = "";
                if (col.getPrefWidthEm() != null) {
                    style = style + "-fx-pref-width:" + col.getPrefWidthEm() + "em;";
                }
                if (col.getMaxWidthEm() != null) {
                    style = style + "-fx-max-width:" + col.getMaxWidthEm() + "em;";
                }
                if (col.getMinWidthEm() != null) {
                    style = style + "-fx-min-width:" + col.getMinWidthEm() + "em;";
                }
                if (!style.isEmpty()) {
                    node.setStyle(style);
                }
                Styles.addStyle(node, "row-cell");
                Styles.addStyle(node, "grid-cell");
                this.cells.add((Node)node);
            }
        }

        private Node createControlsPanel() {
            ControlsPane result = new ControlsPane();
            if (TableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
                Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    int idx = TableWidget.this.rows.indexOf((Object)this);
                    FxUtil.swap(TableWidget.this.rows, idx, idx + 1);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{TableWidget.this.viewState.stateProperty(), TableWidget.this.rows});
                    }

                    protected boolean computeValue() {
                        return !TableWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.DOWN, TableWidget.this.rows.indexOf((Object)Row.this));
                    }
                }), (Tooltip)new Tooltip(Messages.General_Move_line_down_to_one));
            }
            if (TableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
                Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> {
                    int idx = TableWidget.this.rows.indexOf((Object)this);
                    FxUtil.swap(TableWidget.this.rows, idx - 1, idx);
                }), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{TableWidget.this.viewState.stateProperty(), TableWidget.this.rows});
                    }

                    protected boolean computeValue() {
                        return !TableWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.UP, TableWidget.this.rows.indexOf((Object)Row.this));
                    }
                }), (Tooltip)new Tooltip(Messages.General_Move_line_up_to_one));
            }
            if (TableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
                Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> TableWidget.this.rows.remove((Object)this)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{TableWidget.this.viewState.stateProperty(), TableWidget.this.rows});
                    }

                    protected boolean computeValue() {
                        return !TableWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.REMOVE, TableWidget.this.rows.indexOf((Object)Row.this));
                    }
                }), (Tooltip)new Tooltip(Messages.General_Remove_line));
            }
            if (TableWidget.this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
                Tooltip.install((Node)result.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> TableWidget.this.itemsProvider.createAny(TableWidget.this.buildItemsConsumer(TableWidget.this.rows.indexOf((Object)this) + 1))), (ObservableValue<? extends Boolean>)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{TableWidget.this.viewState.stateProperty(), TableWidget.this.rows});
                    }

                    protected boolean computeValue() {
                        return !TableWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, TableWidget.this.rows.indexOf((Object)Row.this));
                    }
                }), (Tooltip)new Tooltip(Messages.General_Add_new_line_after_this));
            }
            return result;
        }

        List<Node> getCells() {
            return this.cells;
        }

        T getData() {
            return this.data;
        }

        void setData(T value) {
            this.data = value;
        }

        T getPopulatedData(boolean forFiltering) {
            Object result = forFiltering ? TableWidget.this.itemsProvider.createOne() : this.data;
            for (int idx = 0; idx < TableWidget.this.columns.size(); ++idx) {
                TableWidgetColumn col = TableWidget.this.columns.get(idx);
                col.writeData(result, this.cells.get(idx));
            }
            return result;
        }

        boolean isDataChanged() {
            for (int idx = 0; idx < TableWidget.this.columns.size(); ++idx) {
                TableWidgetColumn col = TableWidget.this.columns.get(idx);
                if (!col.isDataChanged(this.data, this.cells.get(idx))) continue;
                return true;
            }
            return false;
        }

        Row getThisRow() {
            return this;
        }

        void inject(Node widget) {
            StackPane wrapper = new StackPane(new Node[]{widget});
            wrapper.getStyleClass().add((Object)"injected");
            this.injectedWidget = new StackPane(new Node[]{wrapper});
            this.injectedWidget.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
        }

        void eject() {
            this.injectedWidget = null;
        }

        Node getInjected() {
            return this.injectedWidget;
        }

        boolean isFilteredOut() {
            return this.filteredOut;
        }

        void setFilteredOut(boolean value) {
            this.filteredOut = value;
        }

        Node getControlsPane() {
            if (this.controlsPane == null) {
                this.controlsPane = this.createControlsPanel();
                this.controlsPane.getStyleClass().addAll((Object[])new String[]{"row-cell", "grid-cell"});
            }
            return this.controlsPane;
        }
    }
}

