/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.StringConverter;

public class ComboBoxWidgetColumn<M, I>
extends TableWidgetColumn<M, ComboBoxWidget<I>> {
    private final Function<M, I> getter;
    private final BiConsumer<M, I> setter;
    private Supplier<List<I>> itemsSupplier = () -> Collections.emptyList();
    private StringConverter<I> converter = StandardRenderers.GENERIC.createStatefulConverter(() -> {
        TableColumnOwner owner = this.getOwner();
        return owner == null ? true : owner.getViewState().isImmutable();
    });
    private boolean sortItems = true;
    private boolean noNulls;
    private Function<I, IconNode> iconsSupplier;
    private boolean live;
    private boolean async;
    private SuggestionsHandler<I> suggestionsHandler;
    private String promptText = UiUtil.NULL_TEXT;
    private Consumer<I> navigationHandler;

    public ComboBoxWidgetColumn(Function<M, I> aGetter, BiConsumer<M, I> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public boolean isSortItems() {
        return this.sortItems;
    }

    public void setSortItems(boolean value) {
        this.sortItems = value;
        this.applyToAllRows(widget -> widget.setSortItems(this.sortItems));
    }

    public void setNoNulls(boolean value) {
        this.noNulls = value;
        this.applyToAllRows(widget -> widget.setNoNulls(this.noNulls));
    }

    public void setLive(boolean value) {
        this.live = value;
        this.applyToAllRows(widget -> widget.setLive(this.live));
    }

    public void setAsync(boolean value) {
        this.async = value;
        this.applyToAllRows(widget -> widget.setAsync(this.async));
    }

    public StringConverter<I> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<I> value) {
        this.converter = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setConverter(this.converter));
    }

    public Supplier<List<I>> getItemsSupplier() {
        return this.itemsSupplier;
    }

    public void setItemsSupplier(Supplier<List<I>> value) {
        this.itemsSupplier = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier));
    }

    public void setIconsSupplier(Function<I, IconNode> value) {
        this.iconsSupplier = value;
        this.applyToAllRows(widget -> widget.setIconsSupplier(this.iconsSupplier));
    }

    public void setSuggestionsHandler(SuggestionsHandler<I> value) {
        this.suggestionsHandler = value;
        this.applyToAllRows(widget -> widget.setSuggestionsHandler(this.suggestionsHandler));
    }

    public void setPromptText(String val) {
        this.promptText = Objects.requireNonNull(val);
        this.applyToAllRows(widget -> widget.setPromptText(this.promptText));
    }

    public void setNavigationHandler(Consumer<I> val) {
        this.navigationHandler = val;
        this.applyToAllRows(widget -> widget.setNavigationHandler(this.navigationHandler));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public ComboBoxWidget<I> createNode() {
        ComboBoxWidget<Object> result = new ComboBoxWidget<Object>(this.getOwner().getViewState().isReadonly());
        result.setIconsSupplier(this.iconsSupplier);
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setItemsSupplier(this.itemsSupplier);
        result.setConverter(this.converter);
        result.setSortItems(this.sortItems);
        result.setNoNulls(this.noNulls);
        result.setLive(this.live);
        result.setAsync(this.async);
        result.setSuggestionsHandler(this.suggestionsHandler);
        result.setPromptText(this.promptText);
        result.setNavigationHandler(this.navigationHandler);
        return result;
    }

    @Override
    public void readData(M model, ComboBoxWidget<I> node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, ComboBoxWidget<I> node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(ComboBoxWidget<I> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(ComboBoxWidget<I> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, ComboBoxWidget<I> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), this.getter.apply(model));
    }
}

