/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ExpandableColumn;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;

public class ControllerBasedExpandableColumn<M, I, V extends Node>
extends ExpandableColumn<M, V> {
    private final Function<M, I> getter;
    private final Supplier<ViewController<V, I>> controllerSupplier;

    public ControllerBasedExpandableColumn(Function<M, I> aGgetter, Supplier<ViewController<V, I>> cs) {
        this.getter = aGgetter;
        this.controllerSupplier = cs;
    }

    @Override
    protected V createView() {
        ViewController<V, I> controller = this.controllerSupplier.get();
        V result = controller.getView();
        result.getProperties().put((Object)"controller", controller);
        return result;
    }

    @Override
    public void readData(M model, ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)node.getView().getProperties().get((Object)"controller");
        controller.readData(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)node.getView().getProperties().get((Object)"controller");
        controller.writeData(this.getter.apply(model));
    }

    @Override
    public void setReadonly(ExpandableColumn.ViewHolder<V> node, boolean readonly) {
        ViewController controller = (ViewController)node.getView().getProperties().get((Object)"controller");
        controller.setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)node.getView().getProperties().get((Object)"controller");
        controller.setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, ExpandableColumn.ViewHolder<V> node) {
        ViewController controller = (ViewController)node.getView().getProperties().get((Object)"controller");
        return controller.isDataChanged();
    }
}

