/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class DoubleValueWidgetColumn<M>
extends TableWidgetColumn<M, DoubleValueWidget> {
    private final Function<M, Double> getter;
    private final BiConsumer<M, Double> setter;
    private Double defaultValue = 0.0;

    public DoubleValueWidgetColumn(Function<M, Double> aGetter, BiConsumer<M, Double> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setDefaultValue(Double value) {
        this.defaultValue = value;
        this.applyToAllRows(widget -> widget.setDefaultValue(this.defaultValue));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public DoubleValueWidget createNode() {
        DoubleValueWidget result = new DoubleValueWidget(this.getOwner().getViewState().isReadonly());
        result.setDefaultValue(this.defaultValue);
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, DoubleValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, DoubleValueWidget node) {
        this.setter.accept(model, (Double)node.valueProperty().get());
    }

    @Override
    public void setReadonly(DoubleValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(DoubleValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, DoubleValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

