/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.FloatValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FloatValueWidgetColumn<M>
extends TableWidgetColumn<M, FloatValueWidget> {
    private final Function<M, Float> getter;
    private final BiConsumer<M, Float> setter;
    private Float defaultValue = Float.valueOf(0.0f);

    public FloatValueWidgetColumn(Function<M, Float> aGetter, BiConsumer<M, Float> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setDefaultValue(Float value) {
        this.defaultValue = value;
        this.applyToAllRows(widget -> widget.setDefaultValue(this.defaultValue));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public FloatValueWidget createNode() {
        FloatValueWidget result = new FloatValueWidget(this.getOwner().getViewState().isReadonly());
        result.setDefaultValue(this.defaultValue);
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, FloatValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, FloatValueWidget node) {
        this.setter.accept(model, (Float)node.valueProperty().get());
    }

    @Override
    public void setReadonly(FloatValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(FloatValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, FloatValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

