/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class IntValueWidgetColumn<M>
extends TableWidgetColumn<M, IntValueWidget> {
    private final Function<M, Integer> getter;
    private final BiConsumer<M, Integer> setter;
    private Integer defaultValue = 0;
    private Predicate<Integer> valueValidator;

    public IntValueWidgetColumn(Function<M, Integer> aGetter, BiConsumer<M, Integer> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setValueValidator(Predicate<Integer> value) {
        this.valueValidator = value;
        this.applyToAllRows(widget -> widget.setValueValidator(this.valueValidator));
    }

    public void setDefaultValue(Integer value) {
        this.defaultValue = value;
        this.applyToAllRows(widget -> widget.setDefaultValue(this.defaultValue));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public IntValueWidget createNode() {
        IntValueWidget result = new IntValueWidget(this.getOwner().getViewState().isReadonly());
        result.setDefaultValue(this.defaultValue);
        result.setValueValidator(this.valueValidator);
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, IntValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, IntValueWidget node) {
        this.setter.accept(model, (Integer)node.valueProperty().get());
    }

    @Override
    public void setReadonly(IntValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(IntValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, IntValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

