/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.KeyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.Pair;
import javafx.util.StringConverter;

public class KeyValueWidgetColumn<M, K>
extends TableWidgetColumn<M, KeyValueWidget<K>> {
    private Function<K, NodeRenderer> rendererSupplier = key -> null;
    private final Function<M, Pair<K, Object>> getter;
    private final BiConsumer<M, Pair<K, Object>> setter;
    private StringConverter<K> converter = StandardRenderers.GENERIC.createStatefulConverter(() -> this.getOwner().getViewState().isReadonly());
    private Supplier<List<K>> keysSupplier;

    public KeyValueWidgetColumn(Function<M, Pair<K, Object>> aGetter, BiConsumer<M, Pair<K, Object>> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setKeysSupplier(Supplier<List<K>> keysSupplier) {
        this.keysSupplier = keysSupplier;
        this.applyToAllRows(widget -> widget.setKeysSupplier(keysSupplier));
    }

    public void setKeyConverter(StringConverter<K> converter) {
        this.converter = converter;
        this.applyToAllRows(widget -> widget.setKeyConverter(converter));
    }

    public void setRendererSupplier(Function<K, NodeRenderer> rendererSupplier) {
        this.rendererSupplier = Objects.requireNonNull(rendererSupplier);
        this.applyToAllRows(widget -> widget.setRendererSupplier(rendererSupplier));
    }

    @Override
    public KeyValueWidget<K> createNode() {
        KeyValueWidget<K> result = new KeyValueWidget<K>(this.getOwner().getViewState().isReadonly());
        result.setKeysSupplier(this.keysSupplier);
        result.setKeyConverter(this.converter);
        result.setRendererSupplier(this.rendererSupplier);
        return result;
    }

    @Override
    public void readData(M model, KeyValueWidget<K> node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, KeyValueWidget<K> node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(KeyValueWidget<K> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(KeyValueWidget<K> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, KeyValueWidget<K> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals(node.getValue(), this.getter.apply(model));
    }
}

